/*
 * Decompiled with CFR 0.152.
 */
package sh.sit.plp.util;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import sh.sit.plp.kotlin_shaded.Metadata;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0005R\u001a\u0010\n\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\u0005R\u001e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lsh/sit/plp/util/Animatable;", "", "initialValue", "", "<init>", "(F)V", "naturalFreq", "getNaturalFreq", "()F", "setNaturalFreq", "targetValue", "getTargetValue", "setTargetValue", "value", "currentValue", "getCurrentValue", "lastDisplacement", "lastVelocity", "updateValues", "", "timeElapsed", "player-locator-plus_client"})
@Environment(value=EnvType.CLIENT)
public final class Animatable {
    private float naturalFreq = 120.0f;
    private float targetValue;
    private float currentValue;
    private float lastDisplacement;
    private float lastVelocity;

    public Animatable(float initialValue) {
        this.targetValue = initialValue;
        this.currentValue = initialValue;
    }

    public final float getNaturalFreq() {
        return this.naturalFreq;
    }

    public final void setNaturalFreq(float f) {
        this.naturalFreq = f;
    }

    public final float getTargetValue() {
        return this.targetValue;
    }

    public final void setTargetValue(float f) {
        this.targetValue = f;
    }

    public final float getCurrentValue() {
        return this.currentValue;
    }

    public final void updateValues(float timeElapsed) {
        float adjustedDisplacement = this.lastDisplacement - this.targetValue;
        double deltaT = (double)timeElapsed / 1000.0;
        double displacement = 0.0;
        double currentVelocity = 0.0;
        float coeffA = adjustedDisplacement;
        float coeffB = this.lastVelocity + this.naturalFreq * adjustedDisplacement;
        double nFdT = (double)(-this.naturalFreq) * deltaT;
        displacement = ((double)coeffA + (double)coeffB * deltaT) * Math.exp(nFdT);
        currentVelocity = ((double)coeffA + (double)coeffB * deltaT) * Math.exp(nFdT) * (double)(-this.naturalFreq) + (double)coeffB * Math.exp(nFdT);
        float newValue = (float)(displacement + (double)this.targetValue);
        float newVelocity = (float)currentVelocity;
        this.lastDisplacement = newValue;
        this.lastVelocity = newVelocity;
        this.currentValue = newValue;
    }
}

