/*
 * Decompiled with CFR 0.152.
 */
package sh.sit.plp.kotlin_shadedx.datetime;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sh.sit.plp.kotlin_shaded.Metadata;
import sh.sit.plp.kotlin_shaded.jvm.internal.CollectionToArray;
import sh.sit.plp.kotlin_shaded.jvm.internal.DefaultConstructorMarker;
import sh.sit.plp.kotlin_shaded.jvm.internal.Intrinsics;
import sh.sit.plp.kotlin_shaded.jvm.internal.SourceDebugExtension;
import sh.sit.plp.kotlin_shaded.jvm.internal.markers.KMappedMarker;
import sh.sit.plp.kotlin_shaded.ranges.LongProgression;
import sh.sit.plp.kotlin_shadedx.datetime.DateTimeUnit;
import sh.sit.plp.kotlin_shadedx.datetime.LocalDate;
import sh.sit.plp.kotlin_shadedx.datetime.LocalDateProgressionIterator;
import sh.sit.plp.kotlin_shadedx.datetime.internal.MathKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0016\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001%B\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B!\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0016\u0010\u001d\u001a\u00020\u00162\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0016J\u0011\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0002H\u0096\u0002J\u0013\u0010!\u001a\u00020\u00162\b\u0010\"\u001a\u0004\u0018\u00010#H\u0096\u0002J\b\u0010$\u001a\u00020\u001aH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006&"}, d2={"Lsh/sit/plp/kotlin_shadedx/datetime/LocalDateProgression;", "", "Lsh/sit/plp/kotlin_shadedx/datetime/LocalDate;", "longProgression", "Lsh/sit/plp/kotlin_shaded/ranges/LongProgression;", "<init>", "(Lsh/sit/plp/kotlin_shaded/ranges/LongProgression;)V", "start", "endInclusive", "step", "", "(Lsh/sit/plp/kotlin_shadedx/datetime/LocalDate;Lsh/sit/plp/kotlin_shadedx/datetime/LocalDate;J)V", "getLongProgression$kotlinx_datetime", "()Lsh/sit/plp/kotlin_shaded/ranges/LongProgression;", "first", "getFirst", "()Lsh/sit/plp/kotlin_shadedx/datetime/LocalDate;", "last", "getLast", "iterator", "", "isEmpty", "", "toString", "", "size", "", "getSize", "()I", "containsAll", "elements", "contains", "value", "equals", "other", "", "hashCode", "Companion", "sh.sit.plp.kotlin_shadedx-datetime"})
@SourceDebugExtension(value={"SMAP\nLocalDateRange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalDateRange.kt\nkotlinx/datetime/LocalDateProgression\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,278:1\n1740#2,3:279\n*S KotlinDebug\n*F\n+ 1 LocalDateRange.kt\nkotlinx/datetime/LocalDateProgression\n*L\n73#1:279,3\n*E\n"})
public class LocalDateProgression
implements Collection<LocalDate>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LongProgression longProgression;
    @NotNull
    private final LocalDate first;
    @NotNull
    private final LocalDate last;

    public LocalDateProgression(@NotNull LongProgression longProgression) {
        Intrinsics.checkNotNullParameter(longProgression, "longProgression");
        this.longProgression = longProgression;
        this.first = LocalDate.Companion.fromEpochDays(this.longProgression.getFirst());
        this.last = LocalDate.Companion.fromEpochDays(this.longProgression.getLast());
    }

    @NotNull
    public final LongProgression getLongProgression$kotlinx_datetime() {
        return this.longProgression;
    }

    public LocalDateProgression(@NotNull LocalDate start, @NotNull LocalDate endInclusive, long step) {
        Intrinsics.checkNotNullParameter(start, "start");
        Intrinsics.checkNotNullParameter(endInclusive, "endInclusive");
        this(LongProgression.Companion.fromClosedRange(start.toEpochDays(), endInclusive.toEpochDays(), step));
    }

    @NotNull
    public final LocalDate getFirst() {
        return this.first;
    }

    @NotNull
    public final LocalDate getLast() {
        return this.last;
    }

    @Override
    @NotNull
    public Iterator<LocalDate> iterator() {
        return new LocalDateProgressionIterator(this.longProgression.iterator());
    }

    @Override
    public boolean isEmpty() {
        return this.longProgression.isEmpty();
    }

    @NotNull
    public String toString() {
        return this.longProgression.getStep() > 0L ? this.first + ".." + this.last + " step " + this.longProgression.getStep() + 'D' : this.first + " downTo " + this.last + " step " + this.longProgression.getStep() + 'D';
    }

    public int getSize() {
        return MathKt.getSizeUnsafe(this.longProgression);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> elements) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(elements, "elements");
            Iterable $this$all$iv = elements;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (it instanceof LocalDate && this.contains(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public boolean contains(@NotNull LocalDate value) {
        Intrinsics.checkNotNullParameter(value, "value");
        return MathKt.containsUnsafe(this.longProgression, value.toEpochDays());
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof LocalDateProgression && Intrinsics.areEqual(this.longProgression, ((LocalDateProgression)other).longProgression);
    }

    @Override
    public int hashCode() {
        return this.longProgression.hashCode();
    }

    @Override
    public boolean add(LocalDate element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(Collection<? extends LocalDate> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeAll(Collection<?> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean retainAll(Collection<?> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeIf(Predicate<? super LocalDate> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, "array");
        return CollectionToArray.toArray(this, array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray(this);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lsh/sit/plp/kotlin_shadedx/datetime/LocalDateProgression$Companion;", "", "<init>", "()V", "fromClosedRange", "Lsh/sit/plp/kotlin_shadedx/datetime/LocalDateProgression;", "rangeStart", "Lsh/sit/plp/kotlin_shadedx/datetime/LocalDate;", "rangeEnd", "stepValue", "", "stepUnit", "Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit$DayBased;", "fromClosedRange$kotlinx_datetime", "sh.sit.plp.kotlin_shadedx-datetime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LocalDateProgression fromClosedRange$kotlinx_datetime(@NotNull LocalDate rangeStart, @NotNull LocalDate rangeEnd, long stepValue, @NotNull DateTimeUnit.DayBased stepUnit) {
            Intrinsics.checkNotNullParameter(rangeStart, "rangeStart");
            Intrinsics.checkNotNullParameter(rangeEnd, "rangeEnd");
            Intrinsics.checkNotNullParameter(stepUnit, "stepUnit");
            return new LocalDateProgression(rangeStart, rangeEnd, MathKt.safeMultiplyOrClamp(stepValue, stepUnit.getDays()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

