/*
 * Decompiled with CFR 0.152.
 */
package sh.sit.plp.kotlin_shadedx.datetime;

import org.jetbrains.annotations.NotNull;
import sh.sit.plp.kotlin_shaded.Deprecated;
import sh.sit.plp.kotlin_shaded.Metadata;
import sh.sit.plp.kotlin_shaded.ReplaceWith;
import sh.sit.plp.kotlin_shaded.Unit;
import sh.sit.plp.kotlin_shaded.jvm.internal.Intrinsics;
import sh.sit.plp.kotlin_shaded.jvm.internal.SourceDebugExtension;
import sh.sit.plp.kotlin_shaded.time.Instant;
import sh.sit.plp.kotlin_shadedx.datetime.DateTimeFormatException;
import sh.sit.plp.kotlin_shadedx.datetime.DateTimePeriod;
import sh.sit.plp.kotlin_shadedx.datetime.DateTimePeriodKt;
import sh.sit.plp.kotlin_shadedx.datetime.DateTimeUnit;
import sh.sit.plp.kotlin_shadedx.datetime.InstantJvmKt;
import sh.sit.plp.kotlin_shadedx.datetime.InstantKt;
import sh.sit.plp.kotlin_shadedx.datetime.TimeZone;
import sh.sit.plp.kotlin_shadedx.datetime.UtcOffset;
import sh.sit.plp.kotlin_shadedx.datetime.format.DateTimeComponents;
import sh.sit.plp.kotlin_shadedx.datetime.format.DateTimeComponentsKt;
import sh.sit.plp.kotlin_shadedx.datetime.format.DateTimeFormat;
import sh.sit.plp.kotlin_shadedx.datetime.internal.MathKt;

@Metadata(mv={2, 1, 0}, k=5, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001a\u001a\u0010\b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u001a\u0010\r\u001a\u00020\u000e*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u001a\u0010\u0012\u001a\u00020\u0013*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f\u001a\u001a\u0010\u0014\u001a\u00020\u0013*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f\u001a\u001a\u0010\u0015\u001a\u00020\u0013*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f\u001a\u001a\u0010\b\u001a\u00020\n*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f\u001a\u001c\u0010\b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\fH\u0007\u001a\u0014\u0010\u0017\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0007\u001a\u0014\u0010\b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0007\u001a\u001a\u0010\u0017\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u001a\u0010\b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011\u001a\"\u0010\b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f\u001a\u001a\u0010\b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\"\u0010\b\u001a\u00020\u000e*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f\u001a\u001a\u0010\b\u001a\u00020\u000e*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\"\u0010\u0005\u001a\u00020\u0019*\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\u001a\u001a\u00020\u001b\"\u000e\u0010\u001c\u001a\u00020\u000eX\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001d\u001a\u00020\u000eX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"parse", "Lsh/sit/plp/kotlin_shaded/time/Instant;", "Lsh/sit/plp/kotlin_shaded/time/Instant$Companion;", "input", "", "format", "Lsh/sit/plp/kotlin_shadedx/datetime/format/DateTimeFormat;", "Lsh/sit/plp/kotlin_shadedx/datetime/format/DateTimeComponents;", "minus", "period", "Lsh/sit/plp/kotlin_shadedx/datetime/DateTimePeriod;", "timeZone", "Lsh/sit/plp/kotlin_shadedx/datetime/TimeZone;", "until", "", "other", "unit", "Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit$TimeBased;", "daysUntil", "", "monthsUntil", "yearsUntil", "Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit;", "plus", "value", "", "offset", "Lsh/sit/plp/kotlin_shadedx/datetime/UtcOffset;", "DISTANT_PAST_SECONDS", "DISTANT_FUTURE_SECONDS", "sh.sit.plp.kotlin_shadedx-datetime"}, xs="sh/sit/plp/kotlin_shadedx/datetime/InstantKt")
@SourceDebugExtension(value={"SMAP\nInstant.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Instant.kt\nkotlinx/datetime/InstantKt__InstantKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,417:1\n1#2:418\n*E\n"})
final class InstantKt__InstantKt {
    @NotNull
    public static final Instant parse(@NotNull Instant.Companion $this$parse, @NotNull CharSequence input, @NotNull DateTimeFormat<DateTimeComponents> format) {
        Instant instant;
        Intrinsics.checkNotNullParameter($this$parse, "<this>");
        Intrinsics.checkNotNullParameter(input, "input");
        Intrinsics.checkNotNullParameter(format, "format");
        try {
            instant = DateTimeComponents.toInstantUsingOffset$default(format.parse(input), null, 1, null);
        }
        catch (IllegalArgumentException e) {
            throw new DateTimeFormatException("Failed to parse an instant from '" + input + '\'', e);
        }
        return instant;
    }

    @NotNull
    public static final Instant minus(@NotNull Instant $this$minus, @NotNull DateTimePeriod period, @NotNull TimeZone timeZone) {
        Instant instant;
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(period, "period");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        if (period.getTotalNanoseconds$kotlinx_datetime() != Long.MIN_VALUE) {
            DateTimePeriod $this$minus_u24lambda_u240 = period;
            boolean bl = false;
            DateTimePeriod negatedPeriod = DateTimePeriodKt.buildDateTimePeriod(-$this$minus_u24lambda_u240.getTotalMonths$kotlinx_datetime(), -$this$minus_u24lambda_u240.getDays(), -$this$minus_u24lambda_u240.getTotalNanoseconds$kotlinx_datetime());
            instant = InstantJvmKt.plus($this$minus, negatedPeriod, timeZone);
        } else {
            DateTimePeriod $this$minus_u24lambda_u241 = period;
            boolean bl = false;
            DateTimePeriod negatedPeriod = DateTimePeriodKt.buildDateTimePeriod(-$this$minus_u24lambda_u241.getTotalMonths$kotlinx_datetime(), -$this$minus_u24lambda_u241.getDays(), -($this$minus_u24lambda_u241.getTotalNanoseconds$kotlinx_datetime() + 1L));
            instant = InstantKt.plus(InstantJvmKt.plus($this$minus, negatedPeriod, timeZone), 1, DateTimeUnit.Companion.getNANOSECOND());
        }
        return instant;
    }

    public static final long until(@NotNull Instant $this$until, @NotNull Instant other, @NotNull DateTimeUnit.TimeBased unit) {
        long l;
        Intrinsics.checkNotNullParameter($this$until, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter(unit, "unit");
        try {
            l = MathKt.multiplyAddAndDivide(other.getEpochSeconds() - $this$until.getEpochSeconds(), 1000000000L, other.getNanosecondsOfSecond() - $this$until.getNanosecondsOfSecond(), unit.getNanoseconds());
        }
        catch (ArithmeticException arithmeticException) {
            l = $this$until.compareTo(other) < 0 ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        return l;
    }

    public static final int daysUntil(@NotNull Instant $this$daysUntil, @NotNull Instant other, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$daysUntil, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        return MathKt.clampToInt(InstantJvmKt.until($this$daysUntil, other, (DateTimeUnit)DateTimeUnit.Companion.getDAY(), timeZone));
    }

    public static final int monthsUntil(@NotNull Instant $this$monthsUntil, @NotNull Instant other, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$monthsUntil, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        return MathKt.clampToInt(InstantJvmKt.until($this$monthsUntil, other, (DateTimeUnit)DateTimeUnit.Companion.getMONTH(), timeZone));
    }

    public static final int yearsUntil(@NotNull Instant $this$yearsUntil, @NotNull Instant other, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$yearsUntil, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        return MathKt.clampToInt(InstantJvmKt.until($this$yearsUntil, other, (DateTimeUnit)DateTimeUnit.Companion.getYEAR(), timeZone));
    }

    @NotNull
    public static final DateTimePeriod minus(@NotNull Instant $this$minus, @NotNull Instant other, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        return InstantJvmKt.periodUntil(other, $this$minus, timeZone);
    }

    @Deprecated(message="Use the minus overload with an explicit number of units", replaceWith=@ReplaceWith(expression="this.minus(1, unit, timeZone)", imports={}))
    @NotNull
    public static final Instant minus(@NotNull Instant $this$minus, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        return InstantJvmKt.plus($this$minus, -1, unit, timeZone);
    }

    @Deprecated(message="Use the plus overload with an explicit number of units", replaceWith=@ReplaceWith(expression="this.plus(1, unit)", imports={}))
    @NotNull
    public static final Instant plus(@NotNull Instant $this$plus, @NotNull DateTimeUnit.TimeBased unit) {
        Intrinsics.checkNotNullParameter($this$plus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        return InstantJvmKt.plus($this$plus, 1L, unit);
    }

    @Deprecated(message="Use the minus overload with an explicit number of units", replaceWith=@ReplaceWith(expression="this.minus(1, unit)", imports={}))
    @NotNull
    public static final Instant minus(@NotNull Instant $this$minus, @NotNull DateTimeUnit.TimeBased unit) {
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        return InstantJvmKt.plus($this$minus, -1L, unit);
    }

    @NotNull
    public static final Instant plus(@NotNull Instant $this$plus, int value, @NotNull DateTimeUnit.TimeBased unit) {
        Intrinsics.checkNotNullParameter($this$plus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        return InstantJvmKt.plus($this$plus, (long)value, unit);
    }

    @NotNull
    public static final Instant minus(@NotNull Instant $this$minus, int value, @NotNull DateTimeUnit.TimeBased unit) {
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        return InstantKt.minus($this$minus, (long)value, unit);
    }

    @NotNull
    public static final Instant minus(@NotNull Instant $this$minus, long value, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        return value != Long.MIN_VALUE ? InstantJvmKt.plus($this$minus, -value, unit, timeZone) : InstantJvmKt.plus(InstantJvmKt.plus($this$minus, -(value + 1L), unit, timeZone), 1, unit, timeZone);
    }

    @NotNull
    public static final Instant minus(@NotNull Instant $this$minus, long value, @NotNull DateTimeUnit.TimeBased unit) {
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        return value != Long.MIN_VALUE ? InstantJvmKt.plus($this$minus, -value, unit) : InstantKt.plus(InstantJvmKt.plus($this$minus, -(value + 1L), unit), 1, unit);
    }

    public static final long minus(@NotNull Instant $this$minus, @NotNull Instant other, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        return InstantJvmKt.until(other, $this$minus, unit, timeZone);
    }

    public static final long minus(@NotNull Instant $this$minus, @NotNull Instant other, @NotNull DateTimeUnit.TimeBased unit) {
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter(unit, "unit");
        return InstantKt.until(other, $this$minus, unit);
    }

    @NotNull
    public static final String format(@NotNull Instant $this$format, @NotNull DateTimeFormat<DateTimeComponents> format, @NotNull UtcOffset offset) {
        Intrinsics.checkNotNullParameter($this$format, "<this>");
        Intrinsics.checkNotNullParameter(format, "format");
        Intrinsics.checkNotNullParameter(offset, "offset");
        Instant instant = $this$format;
        return DateTimeComponentsKt.format(format, arg_0 -> InstantKt__InstantKt.format$lambda$2$InstantKt__InstantKt(instant, offset, arg_0));
    }

    public static /* synthetic */ String format$default(Instant instant, DateTimeFormat dateTimeFormat, UtcOffset utcOffset, int n, Object object) {
        if ((n & 2) != 0) {
            utcOffset = UtcOffset.Companion.getZERO();
        }
        return InstantKt.format(instant, (DateTimeFormat<DateTimeComponents>)dateTimeFormat, utcOffset);
    }

    private static final Unit format$lambda$2$InstantKt__InstantKt(Instant $instant, UtcOffset $offset, DateTimeComponents $this$format) {
        Intrinsics.checkNotNullParameter($this$format, "$this$format");
        $this$format.setDateTimeOffset($instant, $offset);
        return Unit.INSTANCE;
    }
}

