/*
 * Decompiled with CFR 0.152.
 */
package sh.sit.plp.kotlin_shaded.time;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sh.sit.plp.kotlin_shaded.Metadata;
import sh.sit.plp.kotlin_shaded.jvm.internal.Intrinsics;
import sh.sit.plp.kotlin_shaded.time.ExperimentalTime;
import sh.sit.plp.kotlin_shaded.time.Instant;
import sh.sit.plp.kotlin_shaded.time.InstantFormatException;
import sh.sit.plp.kotlin_shaded.time.InstantKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bs\u0018\u00002\u00020\u0001:\u0002\u0005\u0006J\b\u0010\u0002\u001a\u00020\u0003H&J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0003H&\u0082\u0001\u0002\u0007\b\u00a8\u0006\t"}, d2={"Lsh/sit/plp/kotlin_shaded/time/InstantParseResult;", "", "toInstant", "Lsh/sit/plp/kotlin_shaded/time/Instant;", "toInstantOrNull", "Success", "Failure", "Lsh/sit/plp/kotlin_shaded/time/InstantParseResult$Failure;", "Lsh/sit/plp/kotlin_shaded/time/InstantParseResult$Success;", "sh.sit.plp.kotlin_shaded-stdlib"})
@ExperimentalTime
interface InstantParseResult {
    @NotNull
    public Instant toInstant();

    @Nullable
    public Instant toInstantOrNull();

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lsh/sit/plp/kotlin_shaded/time/InstantParseResult$Failure;", "Lsh/sit/plp/kotlin_shaded/time/InstantParseResult;", "error", "", "input", "", "<init>", "(Ljava/lang/String;Ljava/lang/CharSequence;)V", "getError", "()Ljava/lang/String;", "getInput", "()Ljava/lang/CharSequence;", "toInstant", "Lsh/sit/plp/kotlin_shaded/time/Instant;", "toInstantOrNull", "sh.sit.plp.kotlin_shaded-stdlib"})
    public static final class Failure
    implements InstantParseResult {
        @NotNull
        private final String error;
        @NotNull
        private final CharSequence input;

        public Failure(@NotNull String error, @NotNull CharSequence input) {
            Intrinsics.checkNotNullParameter(error, "error");
            Intrinsics.checkNotNullParameter(input, "input");
            this.error = error;
            this.input = input;
        }

        @NotNull
        public final String getError() {
            return this.error;
        }

        @NotNull
        public final CharSequence getInput() {
            return this.input;
        }

        @Override
        @NotNull
        public Instant toInstant() {
            throw new InstantFormatException(this.error + " when parsing an Instant from \"" + InstantKt.access$truncateForErrorMessage(this.input, 64) + '\"');
        }

        @Override
        @Nullable
        public Instant toInstantOrNull() {
            return null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lsh/sit/plp/kotlin_shaded/time/InstantParseResult$Success;", "Lsh/sit/plp/kotlin_shaded/time/InstantParseResult;", "epochSeconds", "", "nanosecondsOfSecond", "", "<init>", "(JI)V", "getEpochSeconds", "()J", "getNanosecondsOfSecond", "()I", "toInstant", "Lsh/sit/plp/kotlin_shaded/time/Instant;", "toInstantOrNull", "sh.sit.plp.kotlin_shaded-stdlib"})
    public static final class Success
    implements InstantParseResult {
        private final long epochSeconds;
        private final int nanosecondsOfSecond;

        public Success(long epochSeconds, int nanosecondsOfSecond) {
            this.epochSeconds = epochSeconds;
            this.nanosecondsOfSecond = nanosecondsOfSecond;
        }

        public final long getEpochSeconds() {
            return this.epochSeconds;
        }

        public final int getNanosecondsOfSecond() {
            return this.nanosecondsOfSecond;
        }

        @Override
        @NotNull
        public Instant toInstant() {
            if (this.epochSeconds < Instant.Companion.getMIN$kotlin_stdlib().getEpochSeconds() || this.epochSeconds > Instant.Companion.getMAX$kotlin_stdlib().getEpochSeconds()) {
                throw new InstantFormatException("The parsed date is outside the range representable by Instant (Unix epoch second " + this.epochSeconds + ')');
            }
            return Instant.Companion.fromEpochSeconds(this.epochSeconds, this.nanosecondsOfSecond);
        }

        @Override
        @Nullable
        public Instant toInstantOrNull() {
            return this.epochSeconds < Instant.Companion.getMIN$kotlin_stdlib().getEpochSeconds() || this.epochSeconds > Instant.Companion.getMAX$kotlin_stdlib().getEpochSeconds() ? null : Instant.Companion.fromEpochSeconds(this.epochSeconds, this.nanosecondsOfSecond);
        }
    }
}

