/*
 * Decompiled with CFR 0.152.
 */
package sh.sit.plp.config;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.util.Utils;
import org.jetbrains.annotations.NotNull;
import sh.sit.plp.config.ModConfig;
import sh.sit.plp.kotlin_shaded.Metadata;
import sh.sit.plp.kotlin_shaded.io.FilesKt;
import sh.sit.plp.kotlin_shaded.jvm.internal.Intrinsics;
import sh.sit.plp.kotlin_shaded.jvm.internal.SourceDebugExtension;
import sh.sit.plp.kotlin_shadedx.serialization.DeserializationStrategy;
import sh.sit.plp.kotlin_shadedx.serialization.SerializationException;
import sh.sit.plp.kotlin_shadedx.serialization.SerializationStrategy;
import sh.sit.plp.kotlin_shadedx.serialization.StringFormat;
import sh.sit.plp.ktoml_shaded.Toml;
import sh.sit.plp.ktoml_shaded.TomlInputConfig;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\b\u0010\u0010\u001a\u00020\u0002H\u0016J\b\u0010\u0011\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lsh/sit/plp/config/KTomlConfigSerializer;", "Lme/shedaniel/autoconfig/serializer/ConfigSerializer;", "Lsh/sit/plp/config/ModConfig;", "definition", "Lme/shedaniel/autoconfig/annotation/Config;", "configClass", "Ljava/lang/Class;", "<init>", "(Lme/shedaniel/autoconfig/annotation/Config;Ljava/lang/Class;)V", "toml", "Lsh/sit/plp/ktoml_shaded/Toml;", "getConfigPath", "Ljava/nio/file/Path;", "serialize", "", "config", "deserialize", "createDefault", "player-locator-plus"})
@SourceDebugExtension(value={"SMAP\nKTomlConfigSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KTomlConfigSerializer.kt\nsh/sit/plp/config/KTomlConfigSerializer\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,62:1\n113#2:63\n123#2:64\n*S KotlinDebug\n*F\n+ 1 KTomlConfigSerializer.kt\nsh/sit/plp/config/KTomlConfigSerializer\n*L\n33#1:63\n46#1:64\n*E\n"})
public final class KTomlConfigSerializer
implements ConfigSerializer<ModConfig> {
    @NotNull
    private final Config definition;
    @NotNull
    private final Class<ModConfig> configClass;
    @NotNull
    private final Toml toml;

    public KTomlConfigSerializer(@NotNull Config definition, @NotNull Class<ModConfig> configClass) {
        Intrinsics.checkNotNullParameter(definition, "definition");
        Intrinsics.checkNotNullParameter(configClass, "configClass");
        this.definition = definition;
        this.configClass = configClass;
        this.toml = new Toml(new TomlInputConfig(true, false, false, false, false, false, 62, null), null, null, 6, null);
    }

    private final Path getConfigPath() {
        Path path = Utils.getConfigFolder().resolve(this.definition.name() + ".toml");
        Intrinsics.checkNotNullExpressionValue(path, "resolve(...)");
        return path;
    }

    /*
     * WARNING - void declaration
     */
    public void serialize(@NotNull ModConfig config) {
        Intrinsics.checkNotNullParameter(config, "config");
        Path configPath = this.getConfigPath();
        try {
            void $this$encodeToString$iv;
            StringFormat stringFormat = this.toml;
            ModConfig value$iv = config;
            boolean $i$f$encodeToString = false;
            $this$encodeToString$iv.getSerializersModule();
            String configString = $this$encodeToString$iv.encodeToString((SerializationStrategy)ModConfig.Companion.serializer(), value$iv);
            File file = configPath.toFile();
            Intrinsics.checkNotNullExpressionValue(file, "toFile(...)");
            FilesKt.writeText$default(file, configString, null, 2, null);
        }
        catch (IOException e) {
            throw new ConfigSerializer.SerializationException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ModConfig deserialize() {
        Path configPath = this.getConfigPath();
        if (Files.exists(configPath, new LinkOption[0])) {
            try {
                void $this$decodeFromString$iv;
                File file = configPath.toFile();
                Intrinsics.checkNotNullExpressionValue(file, "toFile(...)");
                String configString = FilesKt.readText$default(file, null, 1, null);
                StringFormat stringFormat = this.toml;
                String string$iv = configString;
                boolean $i$f$decodeFromString = false;
                $this$decodeFromString$iv.getSerializersModule();
                ModConfig config = (ModConfig)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)ModConfig.Companion.serializer(), string$iv);
                return config;
            }
            catch (IOException e) {
                throw new ConfigSerializer.SerializationException((Throwable)e);
            }
            catch (SerializationException e) {
                throw new ConfigSerializer.SerializationException((Throwable)e);
            }
        }
        return this.createDefault();
    }

    @NotNull
    public ModConfig createDefault() {
        Object object = Utils.constructUnsafely(this.configClass);
        Intrinsics.checkNotNullExpressionValue(object, "constructUnsafely(...)");
        return (ModConfig)object;
    }
}

