/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.enhancedgroups.config;

import de.maxhenkel.enhancedgroups.EnhancedGroupPermissionManager;
import de.maxhenkel.enhancedgroups.config.ForcedGroupType;
import de.maxhenkel.instantgroup.configbuilder.ConfigBuilder;
import de.maxhenkel.instantgroup.configbuilder.entry.ConfigEntry;

public class CommonConfig {
    public final ConfigEntry<Double> defaultInstantGroupRange;
    public final ConfigEntry<String> instantGroupName;
    public final ConfigEntry<EnhancedGroupPermissionManager.PermissionType> instantGroupCommandPermissionType;
    public final ConfigEntry<EnhancedGroupPermissionManager.PermissionType> persistentGroupCommandPermissionType;
    public final ConfigEntry<EnhancedGroupPermissionManager.PermissionType> autoJoinGroupCommandPermissionType;
    public final ConfigEntry<EnhancedGroupPermissionManager.PermissionType> autoJoinGroupGlobalCommandPermissionType;
    public final ConfigEntry<EnhancedGroupPermissionManager.PermissionType> forceJoinGroupCommandPermissionType;
    public final ConfigEntry<Boolean> groupSummary;
    public final ConfigEntry<ForcedGroupType> forceGroupType;

    public CommonConfig(ConfigBuilder builder) {
        this.defaultInstantGroupRange = builder.doubleEntry("default_instant_group_range", (Double)128.0, 1.0, (Double)Double.MAX_VALUE, new String[0]).comment(new String[]{"The default range for the /instantgroup command if no range was provided"});
        this.instantGroupName = builder.stringEntry("instant_group_name", "Instant Group", new String[0]).comment(new String[]{"The name of the instant group"});
        this.instantGroupCommandPermissionType = builder.enumEntry("instant_group_command_permission_level", EnhancedGroupPermissionManager.PermissionType.EVERYONE, new String[0]).comment(new String[]{"The default permission level of the /instantgroup command", "EVERYONE - Every player can use this command", "OPS - Operators can use this command", "NOONE - The command can't be used by anyone"});
        this.persistentGroupCommandPermissionType = builder.enumEntry("persistent_group_command_permission_level", EnhancedGroupPermissionManager.PermissionType.OPS, new String[0]).comment(new String[]{"The default permission level of the /persistentgroup command", "EVERYONE - Every player can use this command", "OPS - Operators can use this command", "NOONE - The command can't be used by anyone"});
        this.autoJoinGroupCommandPermissionType = builder.enumEntry("auto_join_group_command_permission_type", EnhancedGroupPermissionManager.PermissionType.EVERYONE, new String[0]).comment(new String[]{"The default permission level of the /autojoingroup command", "EVERYONE - Every player can use this command", "OPS - Operators can use this command", "NOONE - The command can't be used by anyone"});
        this.autoJoinGroupGlobalCommandPermissionType = builder.enumEntry("auto_join_group_global_command_permission_type", EnhancedGroupPermissionManager.PermissionType.OPS, new String[0]).comment(new String[]{"The default permission level of the /autojoingroup global command", "EVERYONE - Every player can use this command", "OPS - Operators can use this command", "NOONE - The command can't be used by anyone"});
        this.forceJoinGroupCommandPermissionType = builder.enumEntry("force_join_group_command_permission_type", EnhancedGroupPermissionManager.PermissionType.OPS, new String[0]).comment(new String[]{"The default permission level of the /forcejoingroup command", "EVERYONE - Every player can use this command", "OPS - Operators can use this command", "NOONE - The command can't be used by anyone"});
        this.groupSummary = builder.booleanEntry("group_summary", true, new String[0]).comment(new String[]{"Determines if a summary of all groups should be shown when a player joins the server"});
        this.forceGroupType = builder.enumEntry("force_group_type", ForcedGroupType.OFF, new String[0]).comment(new String[]{"Forces all groups to be of the given type", "OFF - No group type is forced", "NORMAL - All groups are forced to be normal groups", "OPEN - All groups are forced to be open groups", "ISOLATED - All groups are forced to be isolated groups"});
    }
}

