/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.enhancedgroups.command;

import com.mojang.brigadier.context.CommandContext;
import de.maxhenkel.admiral.annotations.Command;
import de.maxhenkel.admiral.annotations.Name;
import de.maxhenkel.admiral.annotations.RequiresPermission;
import de.maxhenkel.enhancedgroups.EnhancedGroups;
import de.maxhenkel.enhancedgroups.config.PersistentGroup;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2561;

@RequiresPermission(value="enhancedgroups.autojoingroup.global")
@Command(value={"autojoingroup", "global"})
public class AutoJoinGroupGlobalCommands {
    @Command(value={"set"})
    public int set(CommandContext<class_2168> context, @Name(value="group_name") String groupName) {
        PersistentGroup persistentGroup = EnhancedGroups.PERSISTENT_GROUP_STORE.getGroup(groupName);
        if (persistentGroup == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Group not found or not persistent"));
            return 0;
        }
        return AutoJoinGroupGlobalCommands.autoJoin(context, persistentGroup.getId());
    }

    @Command(value={"set"})
    public int set(CommandContext<class_2168> context, @Name(value="id") UUID groupId) {
        return AutoJoinGroupGlobalCommands.autoJoin(context, groupId);
    }

    @Command(value={"remove"})
    public int remove(CommandContext<class_2168> context) {
        EnhancedGroups.AUTO_JOIN_GROUP_STORE.removeGlobalGroup();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Global auto join successfully removed"), false);
        return 1;
    }

    @Command(value={"force"})
    public int setForce(CommandContext<class_2168> context, @Name(value="status") boolean status) {
        EnhancedGroups.AUTO_JOIN_GROUP_STORE.setGlobalGroupForced(status);
        if (status) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Global auto join is enforced from now on"), false);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Global auto join is not enforced anymore"), false);
        }
        return 1;
    }

    public static int autoJoin(CommandContext<class_2168> context, UUID groupId) {
        PersistentGroup group = EnhancedGroups.PERSISTENT_GROUP_STORE.getGroup(groupId);
        if (group == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Group not found or not persistent"));
            return 0;
        }
        if (group.getPassword() != null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Global auto join groups can't be password-protected"));
            return 0;
        }
        EnhancedGroups.AUTO_JOIN_GROUP_STORE.setGlobalGroup(group.getId());
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Everyone will now automatically connect to group '%s' when joining".formatted(group.getName())), false);
        return 1;
    }
}

