/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gui.console;

import java.util.ArrayList;
import java.util.Deque;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.api.util.ColorU8;
import net.caffeinemc.mods.sodium.client.console.Console;
import net.caffeinemc.mods.sodium.client.console.message.Message;
import net.caffeinemc.mods.sodium.client.console.message.MessageLevel;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5225;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.lwjgl.glfw.GLFW;

public class ConsoleRenderer {
    static final ConsoleRenderer INSTANCE = new ConsoleRenderer();
    private final LinkedList<ActiveMessage> activeMessages = new LinkedList();
    private static final EnumMap<MessageLevel, ColorPalette> COLORS = new EnumMap(MessageLevel.class);

    public void update(Console console, double currentTime) {
        this.purgeMessages(currentTime);
        this.pollMessages(console, currentTime);
    }

    private void purgeMessages(double currentTime) {
        this.activeMessages.removeIf(message -> currentTime > message.timestamp() + message.duration());
    }

    private void pollMessages(Console console, double currentTime) {
        Deque<Message> log = console.getMessageDrain();
        while (!log.isEmpty()) {
            this.activeMessages.add(ActiveMessage.create(log.poll(), currentTime));
        }
    }

    public void draw(class_332 context) {
        double currentTime = GLFW.glfwGetTime();
        class_310 minecraft = class_310.method_1551();
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416(0.0f, 0.0f, 1000.0f);
        int paddingWidth = 3;
        int paddingHeight = 1;
        ArrayList<MessageRender> renders = new ArrayList<MessageRender>();
        int x = 4;
        int y = 4;
        for (ActiveMessage message : this.activeMessages) {
            double opacity = ConsoleRenderer.getMessageOpacity(message, currentTime);
            if (opacity < 0.025) continue;
            ArrayList<class_5481> lines = new ArrayList<class_5481>();
            int messageWidth = 270;
            class_5225 splitter = minecraft.field_1772.method_27527();
            splitter.method_29971((class_5348)message.text(), messageWidth - 20, class_2583.field_24360, (text, lastLineWrapped) -> lines.add(class_2477.method_10517().method_30934(text)));
            Objects.requireNonNull(minecraft.field_1772);
            int messageHeight = 9 * lines.size() + paddingHeight * 2;
            renders.add(new MessageRender(x, y, messageWidth, messageHeight, message.level(), lines, opacity));
            y += messageHeight;
        }
        double mouseX = minecraft.field_1729.method_1603() / minecraft.method_22683().method_4495();
        double mouseY = minecraft.field_1729.method_1604() / minecraft.method_22683().method_4495();
        boolean hovered = false;
        for (MessageRender render : renders) {
            if (!(mouseX >= (double)render.x) || !(mouseX < (double)(render.x + render.width)) || !(mouseY >= (double)render.y) || !(mouseY < (double)(render.y + render.height))) continue;
            hovered = true;
            break;
        }
        for (MessageRender render : renders) {
            int x2 = render.x();
            int y2 = render.y();
            int width = render.width();
            int height = render.height();
            ColorPalette colors = COLORS.get((Object)render.level());
            double opacity = render.opacity();
            if (hovered) {
                opacity *= 0.4;
            }
            context.method_25294(x2, y2, x2 + width, y2 + height, ColorARGB.withAlpha(colors.background(), ConsoleRenderer.weightAlpha(opacity)));
            context.method_25294(x2, y2, x2 + 1, y2 + height, ColorARGB.withAlpha(colors.foreground(), ConsoleRenderer.weightAlpha(opacity)));
            for (class_5481 line : render.lines()) {
                context.method_51430(minecraft.field_1772, line, x2 + paddingWidth + 3, y2 + paddingHeight, ColorARGB.withAlpha(colors.text(), ConsoleRenderer.weightAlpha(opacity)), false);
                Objects.requireNonNull(minecraft.field_1772);
                y2 += 9;
            }
        }
        matrices.method_22909();
    }

    private static double getMessageOpacity(ActiveMessage message, double time) {
        double midpoint = message.timestamp() + message.duration() / 2.0;
        if (time > midpoint) {
            return ConsoleRenderer.getFadeOutOpacity(message, time);
        }
        if (time < midpoint) {
            return ConsoleRenderer.getFadeInOpacity(message, time);
        }
        return 1.0;
    }

    private static double getFadeInOpacity(ActiveMessage message, double time) {
        double animationDuration = 0.25;
        double animationStart = message.timestamp();
        double animationEnd = message.timestamp() + animationDuration;
        return ConsoleRenderer.getAnimationProgress(time, animationStart, animationEnd);
    }

    private static double getFadeOutOpacity(ActiveMessage message, double time) {
        double animationDuration = Math.min(0.5, message.duration() * 0.2);
        double animationStart = message.timestamp() + message.duration() - animationDuration;
        double animationEnd = message.timestamp() + message.duration();
        return 1.0 - ConsoleRenderer.getAnimationProgress(time, animationStart, animationEnd);
    }

    private static double getAnimationProgress(double currentTime, double startTime, double endTime) {
        return class_3532.method_15350((double)class_3532.method_15370((double)currentTime, (double)startTime, (double)endTime), (double)0.0, (double)1.0);
    }

    private static int weightAlpha(double scale) {
        return ColorU8.normalizedFloatToByte((float)scale);
    }

    static {
        COLORS.put(MessageLevel.INFO, new ColorPalette(ColorARGB.pack(255, 255, 255), ColorARGB.pack(15, 15, 15), ColorARGB.pack(15, 15, 15)));
        COLORS.put(MessageLevel.WARN, new ColorPalette(ColorARGB.pack(224, 187, 0), ColorARGB.pack(25, 21, 0), ColorARGB.pack(180, 150, 0)));
        COLORS.put(MessageLevel.SEVERE, new ColorPalette(ColorARGB.pack(220, 0, 0), ColorARGB.pack(25, 0, 0), ColorARGB.pack(160, 0, 0)));
    }

    private record ActiveMessage(MessageLevel level, class_2561 text, double duration, double timestamp) {
        public static ActiveMessage create(Message message, double timestamp) {
            class_5250 text = (message.translated() ? class_2561.method_43471((String)message.text()) : class_2561.method_43470((String)message.text())).method_27661().method_27694(style -> style.method_27704(class_310.field_24211));
            return new ActiveMessage(message.level(), (class_2561)text, message.duration(), timestamp);
        }
    }

    private record MessageRender(int x, int y, int width, int height, MessageLevel level, List<class_5481> lines, double opacity) {
    }

    private record ColorPalette(int text, int background, int foreground) {
    }
}

