/*
 * Decompiled with CFR 0.152.
 */
package net.wimods.zoom.test;

import java.time.Duration;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_155;
import net.minecraft.class_3532;
import net.minecraft.class_429;
import net.minecraft.class_442;
import net.minecraft.class_458;
import net.minecraft.class_525;
import net.minecraft.class_526;
import net.minecraft.class_6599;
import net.minecraft.class_8032;
import net.wimods.zoom.WiZoom;
import net.wimods.zoom.test.WiModsTestHelper;
import org.spongepowered.asm.mixin.MixinEnvironment;

public final class WiZoomTestClient
implements ClientModInitializer {
    public void onInitializeClient() {
        if (System.getProperty("wi_zoom.e2eTest") == null) {
            return;
        }
        Thread.ofVirtual().name("WI Zoom End-to-End Test").uncaughtExceptionHandler((t, e) -> {
            e.printStackTrace();
            System.exit(1);
        }).start(this::runTests);
    }

    private void runTests() {
        System.out.println("Starting WI Zoom End-to-End Test");
        WiModsTestHelper.waitForResourceLoading();
        if (WiModsTestHelper.submitAndGet(mc -> mc.field_1690.field_41785).booleanValue()) {
            System.out.println("Onboarding is enabled. Waiting for it");
            WiModsTestHelper.waitForScreen(class_8032.class);
            System.out.println("Reached onboarding screen");
            WiModsTestHelper.clickButton("gui.continue");
        }
        WiModsTestHelper.waitForScreen(class_442.class);
        WiModsTestHelper.waitForTitleScreenFade();
        System.out.println("Reached title screen");
        WiModsTestHelper.takeScreenshot("title_screen", Duration.ZERO);
        System.out.println("Clicking singleplayer button");
        WiModsTestHelper.clickButton("menu.singleplayer");
        if (WiModsTestHelper.submitAndGet(mc -> !mc.method_1586().method_235().method_43421()).booleanValue()) {
            System.out.println("World list is not empty. Waiting for it");
            WiModsTestHelper.waitForScreen(class_526.class);
            System.out.println("Reached select world screen");
            WiModsTestHelper.takeScreenshot("select_world_screen");
            WiModsTestHelper.clickButton("selectWorld.create");
        }
        WiModsTestHelper.waitForScreen(class_525.class);
        System.out.println("Reached create world screen");
        WiModsTestHelper.setTextFieldText(0, "E2E Test " + class_155.method_16673().method_48019());
        WiModsTestHelper.clickButton("selectWorld.gameMode");
        WiModsTestHelper.clickButton("selectWorld.gameMode");
        WiModsTestHelper.takeScreenshot("create_world_screen");
        System.out.println("Creating test world");
        WiModsTestHelper.clickButton("selectWorld.create");
        WiModsTestHelper.waitForWorldLoad();
        WiModsTestHelper.dismissTutorialToasts();
        WiModsTestHelper.waitForWorldTicks(200);
        WiModsTestHelper.runChatCommand("seed");
        System.out.println("Reached singleplayer world");
        WiModsTestHelper.takeScreenshot("in_game", Duration.ZERO);
        WiModsTestHelper.clearChat();
        System.out.println("Opening debug menu");
        WiModsTestHelper.toggleDebugHud();
        WiModsTestHelper.takeScreenshot("debug_menu");
        System.out.println("Closing debug menu");
        WiModsTestHelper.toggleDebugHud();
        System.out.println("Checking for broken mixins");
        MixinEnvironment.getCurrentEnvironment().audit();
        System.out.println("Opening inventory");
        WiModsTestHelper.openInventory();
        WiModsTestHelper.setKeyPressState(86, true);
        WiModsTestHelper.waitForWorldTicks(1);
        WiModsTestHelper.takeScreenshot("inventory");
        WiModsTestHelper.setKeyPressState(86, false);
        WiModsTestHelper.waitForWorldTicks(1);
        System.out.println("Closing inventory");
        WiModsTestHelper.closeScreen();
        WiModsTestHelper.runChatCommand("fill ~-1 ~-1 ~-1 ~1 ~-1 ~15 stone");
        WiModsTestHelper.runChatCommand("fill ~-1 ~ ~-1 ~1 ~30 ~15 air");
        WiModsTestHelper.runChatCommand("clear");
        WiModsTestHelper.clearChat();
        this.testZoomInWorld();
        System.out.println("Opening game menu");
        WiModsTestHelper.openGameMenu();
        WiModsTestHelper.takeScreenshot("game_menu");
        System.out.println("Clicking Options button");
        WiModsTestHelper.clickButton("menu.options");
        WiModsTestHelper.waitForScreen(class_429.class);
        System.out.println("Reached options screen");
        WiModsTestHelper.takeScreenshot("options_screen", Duration.ZERO);
        System.out.println("Clicking Controls button");
        WiModsTestHelper.clickButton("options.controls");
        WiModsTestHelper.waitForScreen(class_458.class);
        System.out.println("Reached controls screen");
        WiModsTestHelper.takeScreenshot("controls_screen", Duration.ZERO);
        System.out.println("Clicking Key Binds button");
        WiModsTestHelper.clickButton("controls.keybinds");
        WiModsTestHelper.waitForScreen(class_6599.class);
        System.out.println("Reached keybinds screen");
        for (int i = 0; i < 100; ++i) {
            WiModsTestHelper.scrollMouse(0, -1);
        }
        WiModsTestHelper.takeScreenshot("key_binds_screen");
        System.out.println("Changing zoom keybind to B");
        WiModsTestHelper.clickEditKeybindButton("key.wi_zoom.zoom");
        WiModsTestHelper.setKeyPressState(66, true);
        WiModsTestHelper.setKeyPressState(66, false);
        WiModsTestHelper.takeScreenshot("zoom_keybind_changed");
        System.out.println("Closing screens");
        WiModsTestHelper.clickButton("gui.done");
        WiModsTestHelper.clickButton("gui.done");
        WiModsTestHelper.clickButton("gui.done");
        WiModsTestHelper.clickButton("menu.returnToGame");
        this.testZoomWithChangedKeybind();
        System.out.println("Returning to title screen");
        WiModsTestHelper.openGameMenu();
        WiModsTestHelper.clickButton("menu.returnToMenu");
        WiModsTestHelper.waitForScreen(class_442.class);
        System.out.println("Changing zoom keybind back to V");
        WiModsTestHelper.submitAndWait(mc -> WiZoom.INSTANCE.getZoomKey().method_1422(WiZoom.INSTANCE.getZoomKey().method_1429()));
        WiModsTestHelper.submitAndWait(mc -> mc.field_1690.method_1640());
        System.out.println("Stopping the game");
        WiModsTestHelper.clickButton("menu.quit");
    }

    private void testZoomInWorld() {
        WiModsTestHelper.runChatCommand("summon minecraft:chicken ~ ~0.85 ~15 {NoAI:1,NoGravity:1,Rotation:[180f,0f]}");
        WiModsTestHelper.waitForWorldTicks(5);
        WiModsTestHelper.takeScreenshot("chicken_no_zoom");
        WiModsTestHelper.setKeyPressState(86, true);
        WiModsTestHelper.waitForWorldTicks(1);
        WiModsTestHelper.takeScreenshot("chicken_3x_zoom");
        this.scrollUpToMaxZoom();
        WiModsTestHelper.takeScreenshot("chicken_50x_zoom");
        this.assertSelectedSlotIsZero();
        WiModsTestHelper.setKeyPressState(86, false);
        WiModsTestHelper.waitForWorldTicks(1);
    }

    private void testZoomWithChangedKeybind() {
        WiModsTestHelper.setKeyPressState(66, true);
        WiModsTestHelper.waitForWorldTicks(1);
        this.scrollUpToMaxZoom();
        WiModsTestHelper.takeScreenshot("custom_keybind_50x_zoom");
        this.assertSelectedSlotIsZero();
        WiModsTestHelper.setKeyPressState(66, false);
        WiModsTestHelper.waitForWorldTicks(1);
    }

    private void scrollUpToMaxZoom() {
        int scrollsNeededFor50x = class_3532.method_15384((double)(Math.log(16.0) / Math.log(1.1)));
        for (int i = 0; i < scrollsNeededFor50x; ++i) {
            WiModsTestHelper.scrollMouse(0, 1);
        }
        WiModsTestHelper.waitForWorldTicks(1);
    }

    private void assertSelectedSlotIsZero() {
        if (WiModsTestHelper.submitAndGet(mc -> mc.field_1724.method_31548().field_7545 != 0).booleanValue()) {
            throw new RuntimeException("Scrolling up while zooming changed the selected slot");
        }
    }
}

