/*
 * Decompiled with CFR 0.152.
 */
package com.github.cargocats.util;

import com.github.cargocats.DisplayDelight;
import com.github.cargocats.block.FoodBlock;
import com.github.cargocats.block.PlatedFoodBlock;
import com.github.cargocats.block.SmallPlatedFoodBlock;
import com.github.cargocats.init.DisplayDelightBlocks;
import com.github.cargocats.util.DisplayDelightAssociations;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;

public class InteractionManager {
    public static boolean tryPlaceItem(class_1657 player, class_3218 world, class_1268 hand, class_3965 blockHitResult) {
        class_1799 itemStack = player.method_5998(hand);
        class_2338 clickedPos = blockHitResult.method_17777();
        class_2350 side = blockHitResult.method_17780();
        class_2248 block = DisplayDelightAssociations.getDisplayBlockForItem(itemStack.method_7909());
        class_2338 placePos = clickedPos.method_10093(side);
        class_2680 blockState = block.method_9564();
        if (block.equals(class_2246.field_10124)) {
            DisplayDelight.LOG.warn("Missing displayable block association for item {}", (Object)itemStack);
            return false;
        }
        if (!world.method_8320(placePos).method_26215()) {
            return false;
        }
        if (!blockState.method_26184((class_4538)world, placePos)) {
            return false;
        }
        if (!world.method_8628(blockState, placePos, class_3726.method_16195((class_1297)player))) {
            return false;
        }
        itemStack.method_57008(1, (class_1309)player);
        world.method_8652(placePos, block.method_9564(), 3);
        world.method_8396(null, placePos, block.method_9564().method_26231().method_10598(), class_3419.field_15245, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
        player.method_23667(hand, true);
        return true;
    }

    public static boolean tryPlaceItemOnSmallPlate(class_1657 player, class_3218 world, class_1268 hand, class_3965 blockHitResult) {
        class_1799 itemStack = player.method_5998(hand);
        class_2338 clickedPos = blockHitResult.method_17777();
        if (!(world.method_8320(clickedPos).method_26204() instanceof SmallPlatedFoodBlock)) {
            return false;
        }
        class_2248 block = DisplayDelightAssociations.getSmallPlateBlockForItem(itemStack.method_7909());
        class_2680 blockState = world.method_8320(clickedPos);
        if (block.equals(class_2246.field_10124) && !blockState.method_27852(DisplayDelightBlocks.SMALL_EMPTY_PLATE)) {
            DisplayDelight.LOG.warn("Missing small plate block association for item {}", (Object)itemStack);
            return false;
        }
        itemStack.method_57008(1, (class_1309)player);
        world.method_8652(clickedPos, (class_2680)block.method_9564().method_11657((class_2769)FoodBlock.field_11177, (Comparable)((class_2350)blockState.method_11654((class_2769)FoodBlock.field_11177))), 3);
        world.method_8396(null, clickedPos, block.method_9564().method_26231().method_10598(), class_3419.field_15245, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
        player.method_23667(hand, true);
        return true;
    }

    public static boolean tryPlaceItemOnPlate(class_1657 player, class_3218 world, class_1268 hand, class_3965 blockHitResult) {
        class_1799 itemStack = player.method_5998(hand);
        class_2338 blockPos = blockHitResult.method_17777();
        class_2680 blockState = world.method_8320(blockPos);
        if (!(blockState.method_26204() instanceof PlatedFoodBlock)) {
            return false;
        }
        class_2248 platedBlock = DisplayDelightAssociations.getPlateBlockForItem(itemStack.method_7909());
        if (platedBlock.equals(class_2246.field_10124) && !blockState.method_27852(DisplayDelightBlocks.EMPTY_PLATE)) {
            DisplayDelight.LOG.warn("Missing plate block association for item {}", (Object)itemStack);
            return false;
        }
        int count = 1;
        if (blockState.method_27852(DisplayDelightBlocks.EMPTY_PLATE)) {
            world.method_8652(blockPos, (class_2680)((class_2680)platedBlock.method_9564().method_11657((class_2769)PlatedFoodBlock.STACKS, (Comparable)Integer.valueOf(1))).method_11657((class_2769)FoodBlock.field_11177, (Comparable)((class_2350)blockState.method_11654((class_2769)FoodBlock.field_11177))), 3);
        } else {
            if (!platedBlock.equals(blockState.method_26204())) {
                return false;
            }
            PlatedFoodBlock platedFoodBlock = (PlatedFoodBlock)platedBlock;
            if (platedFoodBlock.getStacks(blockState) < platedFoodBlock.getMaxStacks()) {
                if (player.method_5715()) {
                    int stacksLeft = platedFoodBlock.getMaxStacks() - platedFoodBlock.getStacks(blockState);
                    count = player.method_7337() ? stacksLeft : Math.min(stacksLeft, itemStack.method_7947());
                    world.method_8652(blockPos, platedFoodBlock.incrementStackState(blockState, count), 3);
                } else {
                    world.method_8652(blockPos, platedFoodBlock.incrementStackState(blockState), 3);
                }
            } else {
                return false;
            }
        }
        itemStack.method_57008(count, (class_1309)player);
        world.method_8396(null, blockPos, platedBlock.method_9564().method_26231().method_10598(), class_3419.field_15245, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
        player.method_23667(hand, true);
        return true;
    }

    public static boolean tryTakeItemWithHand(class_1657 player, class_3218 world, class_1268 hand, class_3965 blockHitResult) {
        class_2338 blockPos = blockHitResult.method_17777();
        class_2680 blockState = world.method_8320(blockPos);
        class_2248 block = blockState.method_26204();
        if (block instanceof SmallPlatedFoodBlock) {
            SmallPlatedFoodBlock smallPlatedFoodBlock = (SmallPlatedFoodBlock)block;
            if (!blockState.method_27852(DisplayDelightBlocks.SMALL_EMPTY_PLATE)) {
                class_1792 plateItem = smallPlatedFoodBlock.getFoodItem();
                if (plateItem.equals(class_1802.field_8162)) {
                    return false;
                }
                world.method_8652(blockPos, DisplayDelightBlocks.SMALL_EMPTY_PLATE.method_9564(), 3);
                world.method_8396(null, blockPos, class_3417.field_15219, class_3419.field_15248, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                player.method_23667(hand, true);
                if (player.method_31548().method_18862(Set.of(plateItem))) {
                    player.method_31548().method_7394(new class_1799((class_1935)plateItem));
                } else {
                    player.method_6122(hand, new class_1799((class_1935)plateItem));
                }
                return true;
            }
        }
        if (block instanceof PlatedFoodBlock) {
            PlatedFoodBlock platedFoodBlock = (PlatedFoodBlock)block;
            if (!blockState.method_27852(DisplayDelightBlocks.EMPTY_PLATE)) {
                class_1792 plateItem = platedFoodBlock.getFoodItem();
                if (plateItem.equals(class_1802.field_8162)) {
                    return false;
                }
                int count = 1;
                if (player.method_5715()) {
                    count = platedFoodBlock.getStacks(blockState);
                    world.method_8652(blockPos, (class_2680)DisplayDelightBlocks.EMPTY_PLATE.method_9564().method_11657((class_2769)FoodBlock.field_11177, (Comparable)((class_2350)blockState.method_11654((class_2769)FoodBlock.field_11177))), 3);
                } else if (platedFoodBlock.getStacks(blockState) > 1) {
                    world.method_8652(blockPos, platedFoodBlock.decrementStackState(blockState), 3);
                } else {
                    world.method_8652(blockPos, (class_2680)DisplayDelightBlocks.EMPTY_PLATE.method_9564().method_11657((class_2769)FoodBlock.field_11177, (Comparable)((class_2350)blockState.method_11654((class_2769)FoodBlock.field_11177))), 3);
                }
                world.method_8396(null, blockPos, class_3417.field_15219, class_3419.field_15248, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                player.method_23667(hand, true);
                if (player.method_31548().method_18862(Set.of(plateItem))) {
                    player.method_7270(new class_1799((class_1935)plateItem, count));
                } else {
                    player.method_6122(hand, new class_1799((class_1935)plateItem, count));
                }
                return true;
            }
        }
        return false;
    }
}

