/*
 * Decompiled with CFR 0.152.
 */
package com.github.cargocats.block;

import com.github.cargocats.block.PlatedFoodBlock;
import com.github.cargocats.block.SmallPlatedFoodBlock;
import com.github.cargocats.init.DisplayDelightItems;
import com.github.cargocats.util.DisplayDelightAssociations;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2383;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5431;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoodBlock
extends class_2383 {
    public static final MapCodec<FoodBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.fieldOf("food_item_id").forGetter(block -> block.foodItemId), (App)FoodBlock.method_54096()).apply((Applicative)instance, FoodBlock::new));
    private final class_2960 foodItemId;

    public FoodBlock(class_2960 foodItemId, class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11043));
        this.foodItemId = foodItemId;
    }

    @NotNull
    protected MapCodec<? extends class_2383> method_53969() {
        return CODEC;
    }

    @NotNull
    protected List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        List droppedStacks = super.method_9560(state, builder);
        boolean usedSilktouch = false;
        class_1799 tool = (class_1799)builder.method_51873(class_181.field_1229);
        class_2378 enchantmentRegistry = builder.method_51870().method_30349().method_30530(class_7924.field_41265);
        Optional silkTouchEntry = enchantmentRegistry.method_40264(class_1893.field_9099);
        if (silkTouchEntry.isPresent() && class_1890.method_8225((class_6880)((class_6880)silkTouchEntry.get()), (class_1799)tool) > 0) {
            usedSilktouch = true;
        }
        class_2248 block = state.method_26204();
        class_1792 foodItem = this.getFoodItem();
        boolean fallBack = false;
        if (foodItem.equals(class_1802.field_8162) || usedSilktouch && !(block instanceof PlatedFoodBlock)) {
            Optional blockItem = class_7923.field_41178.method_17966(class_7923.field_41175.method_10221((Object)block));
            foodItem = blockItem.orElse(class_1802.field_8162);
            fallBack = true;
            DisplayDelightAssociations.ITEM_CACHE.put(class_7923.field_41175.method_10221((Object)block), foodItem);
        }
        if (block instanceof PlatedFoodBlock) {
            PlatedFoodBlock platedFoodBlock = (PlatedFoodBlock)block;
            if (usedSilktouch && platedFoodBlock.getStacks(state) >= platedFoodBlock.getMaxStacks()) {
                droppedStacks.add(new class_1799((class_1935)block));
            } else {
                droppedStacks.add(new class_1799((class_1935)foodItem, !fallBack ? platedFoodBlock.getStacks(state) : 1));
                if (!fallBack) {
                    droppedStacks.add(new class_1799((class_1935)DisplayDelightItems.EMPTY_PLATE));
                }
            }
        } else if (block instanceof SmallPlatedFoodBlock) {
            droppedStacks.add(new class_1799((class_1935)foodItem));
            if (!fallBack) {
                droppedStacks.add(new class_1799((class_1935)DisplayDelightItems.SMALL_EMPTY_PLATE));
            }
        } else {
            droppedStacks.add(new class_1799((class_1935)foodItem));
        }
        return droppedStacks;
    }

    public class_1792 getFoodItem() {
        return DisplayDelightAssociations.getFoodItem(this.foodItemId);
    }

    protected boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return world.method_8320(pos.method_10074()).method_30368((class_1922)world, pos.method_10074(), class_2350.field_11036, class_5431.field_25823);
    }

    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!state.method_26184((class_4538)world, pos)) {
            world.method_22352(pos, true);
        }
    }

    @NotNull
    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (!state.method_26184((class_4538)world, pos)) {
            world.method_39279(pos, (class_2248)this, 1);
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)ctx.method_8042().method_10153());
    }

    @NotNull
    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state) {
        return new class_1799((class_1935)this.getFoodItem());
    }

    @NotNull
    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return FoodBlock.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{field_11177});
    }
}

