/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.config.ConfigUtils;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigHandler;
import fi.dy.masa.malilib.config.IConfigValue;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigBooleanHotkeyed;
import fi.dy.masa.malilib.config.options.ConfigColor;
import fi.dy.masa.malilib.config.options.ConfigColorList;
import fi.dy.masa.malilib.config.options.ConfigDouble;
import fi.dy.masa.malilib.config.options.ConfigFloat;
import fi.dy.masa.malilib.config.options.ConfigHotkey;
import fi.dy.masa.malilib.config.options.ConfigInteger;
import fi.dy.masa.malilib.config.options.ConfigLockedList;
import fi.dy.masa.malilib.config.options.ConfigOptionList;
import fi.dy.masa.malilib.config.options.ConfigString;
import fi.dy.masa.malilib.config.options.ConfigStringList;
import fi.dy.masa.malilib.config.options.table.ConfigTable;
import fi.dy.masa.malilib.config.options.table.Label;
import fi.dy.masa.malilib.config.options.table.TableRow;
import fi.dy.masa.malilib.config.options.table.type.EntryTypes;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.KeyAction;
import fi.dy.masa.malilib.hotkeys.KeybindSettings;
import fi.dy.masa.malilib.test.ConfigTestLockedList;
import fi.dy.masa.malilib.test.ConfigTestOptList;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.time.DurationFormat;
import fi.dy.masa.malilib.util.time.TimeFormat;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;

public class MaLiLibConfigs
implements IConfigHandler {
    private static final String CONFIG_FILE_NAME = "malilib.json";
    private static final String GENERIC_KEY = "malilib.config.generic";
    private static final String DEBUG_KEY = "malilib.config.debug";
    private static final String TEST_KEY = "malilib.config.test";
    private static final KeybindSettings OVERLAY_TOGGLE = KeybindSettings.create(KeybindSettings.Context.ANY, KeyAction.PRESS, true, true, false, true);
    private static final KeybindSettings GUI_RELAXED_CANCEL = KeybindSettings.create(KeybindSettings.Context.GUI, KeyAction.PRESS, true, false, false, true);
    private static final String EXPERIMENTAL_KEY = "malilib.config.experimental";

    public static void loadFromFile() {
        Path configFile = FileUtils.getConfigDirectoryAsPath().resolve(CONFIG_FILE_NAME);
        if (Files.exists(configFile, new LinkOption[0]) && Files.isReadable(configFile)) {
            JsonElement element = JsonUtils.parseJsonFileAsPath(configFile);
            if (element != null && element.isJsonObject()) {
                JsonObject root = element.getAsJsonObject();
                ConfigUtils.readConfigBase(root, "Generic", Generic.OPTIONS);
                ConfigUtils.readConfigBase(root, "Debug", Debug.OPTIONS);
            } else {
                MaLiLib.LOGGER.error("loadFromFile(): Failed to parse config file '{}' as a JSON element.", (Object)configFile.toAbsolutePath());
            }
        }
    }

    public static void saveToFile() {
        Path dir = FileUtils.getConfigDirectoryAsPath();
        if (!Files.exists(dir, new LinkOption[0])) {
            FileUtils.createDirectoriesIfMissing(dir);
        }
        if (Files.isDirectory(dir, new LinkOption[0])) {
            JsonObject root = new JsonObject();
            ConfigUtils.writeConfigBase(root, "Generic", Generic.OPTIONS);
            ConfigUtils.writeConfigBase(root, "Debug", Debug.OPTIONS);
            JsonUtils.writeJsonToFileAsPath(root, dir.resolve(CONFIG_FILE_NAME));
        }
    }

    @Override
    public void onConfigsChanged() {
        MaLiLibConfigs.saveToFile();
        MaLiLibConfigs.loadFromFile();
    }

    @Override
    public void load() {
        MaLiLibConfigs.loadFromFile();
    }

    @Override
    public void save() {
        MaLiLibConfigs.saveToFile();
    }

    public static class Generic {
        public static final ConfigHotkey IGNORED_KEYS = (ConfigHotkey)new ConfigHotkey("ignoredKeys", "").apply("malilib.config.generic");
        public static final ConfigHotkey OPEN_GUI_CONFIGS = (ConfigHotkey)new ConfigHotkey("openGuiConfigs", "A,C").apply("malilib.config.generic");
        public static final ConfigInteger ACTIONBAR_HUD_TICKS = (ConfigInteger)new ConfigInteger("actionbarHudTicks", 60, 1, 240).apply("malilib.config.generic");
        public static final ConfigFloat IN_GAME_MESSAGE_TIMEOUT = (ConfigFloat)new ConfigFloat("inGameMessageTimeout", 5.0f, 0.5f, 15.0f).apply("malilib.config.generic");
        public static final ConfigBooleanHotkeyed ENABLE_CONFIG_SWITCHER = new ConfigBooleanHotkeyed("enableConfigSwitcher", true, "").apply("malilib.config.generic");
        public static final ConfigBooleanHotkeyed RENDER_TRANSPARENCY_FIX = new ConfigBooleanHotkeyed("renderTransparencyFix", true, "").apply("malilib.config.generic");
        public static final ConfigBoolean REALMS_COMMON_CONFIG = (ConfigBoolean)new ConfigBoolean("realmsCommonConfig", true).apply("malilib.config.generic");
        public static final ImmutableList<IConfigValue> OPTIONS = ImmutableList.of((Object)IGNORED_KEYS, (Object)OPEN_GUI_CONFIGS, (Object)ACTIONBAR_HUD_TICKS, (Object)IN_GAME_MESSAGE_TIMEOUT, (Object)ENABLE_CONFIG_SWITCHER, (Object)RENDER_TRANSPARENCY_FIX, (Object)REALMS_COMMON_CONFIG);
        public static final List<IHotkey> HOTKEY_LIST = ImmutableList.of((Object)OPEN_GUI_CONFIGS, (Object)ENABLE_CONFIG_SWITCHER, (Object)RENDER_TRANSPARENCY_FIX);
    }

    public static class Debug {
        public static final ConfigBoolean DEBUG_MESSAGES = (ConfigBoolean)new ConfigBoolean("debugMessages", false).apply("malilib.config.debug");
        public static final ConfigBoolean CONFIG_ELEMENT_DEBUG = (ConfigBoolean)new ConfigBoolean("configElementDebug", false).apply("malilib.config.debug");
        public static final ConfigBoolean INPUT_CANCELLATION_DEBUG = (ConfigBoolean)new ConfigBoolean("inputCancellationDebugging", false).apply("malilib.config.debug");
        public static final ConfigBoolean KEYBIND_DEBUG = (ConfigBoolean)new ConfigBoolean("keybindDebugging", false).apply("malilib.config.debug");
        public static final ConfigBoolean KEYBIND_DEBUG_ACTIONBAR = (ConfigBoolean)new ConfigBoolean("keybindDebuggingIngame", false).apply("malilib.config.debug");
        public static final ConfigBoolean MOUSE_SCROLL_DEBUG = (ConfigBoolean)new ConfigBoolean("mouseScrollDebug", false).apply("malilib.config.debug");
        public static final ConfigBoolean PRINT_TRANSLATION_KEYS = (ConfigBoolean)new ConfigBoolean("printTranslationKeys", false).apply("malilib.config.debug");
        public static final ImmutableList<IConfigValue> OPTIONS = ImmutableList.of((Object)DEBUG_MESSAGES, (Object)CONFIG_ELEMENT_DEBUG, (Object)INPUT_CANCELLATION_DEBUG, (Object)KEYBIND_DEBUG, (Object)KEYBIND_DEBUG_ACTIONBAR, (Object)MOUSE_SCROLL_DEBUG, (Object)PRINT_TRANSLATION_KEYS);
        public static final List<IHotkey> HOTKEY_LIST = ImmutableList.of();
    }

    public static class Experimental {
        public static final ConfigBoolean SORT_CONFIGS_BY_NAME = (ConfigBoolean)new ConfigBoolean("sortConfigsByName", false).apply("malilib.config.experimental");
        public static final ConfigBoolean SORT_EXTENSION_MOD_OPTIONS = (ConfigBoolean)new ConfigBoolean("sortExtensionModOptions", false).apply("malilib.config.experimental");
        public static final ConfigString ACTIVE_CONFIG_PROFILE = (ConfigString)new ConfigString("activeConfigProfile", "").apply("malilib.config.experimental");
        public static final ImmutableList<IConfigBase> OPTIONS = ImmutableList.of((Object)SORT_CONFIGS_BY_NAME, (Object)SORT_EXTENSION_MOD_OPTIONS, (Object)ACTIVE_CONFIG_PROFILE);
    }

    public static class Test {
        public static final ConfigBoolean TEST_CONFIG_BOOLEAN = (ConfigBoolean)new ConfigBoolean("testBoolean", false, "Test Boolean").apply("malilib.config.test");
        public static final ConfigBooleanHotkeyed TEST_CONFIG_BOOLEAN_HOTKEYED = new ConfigBooleanHotkeyed("testBooleanHotkeyed", false, "A,K").apply("malilib.config.test");
        public static final ConfigColor TEST_CONFIG_COLOR = new ConfigColor("testColor", "0x3022FFFF", "Test Color").apply("malilib.config.test");
        public static final ConfigColorList TEST_CONFIG_COLOR_LIST = (ConfigColorList)new ConfigColorList("testColorList", (ImmutableList<Color4f>)ImmutableList.of((Object)new Color4f(0.0f, 0.0f, 0.0f), (Object)new Color4f(255.0f, 255.0f, 255.0f, 255.0f)), "Test Color List").apply("malilib.config.test");
        public static final ConfigDouble TEST_CONFIG_DOUBLE = (ConfigDouble)new ConfigDouble("testDouble", 0.5, 0.0, 1.0, true, "Test Double").apply("malilib.config.test");
        public static final ConfigFloat TEST_CONFIG_FLOAT = (ConfigFloat)new ConfigFloat("testFloat", 0.5f, 0.0f, 1.0f, true, "Test Float").apply("malilib.config.test");
        public static final ConfigHotkey TEST_CONFIG_HOTKEY = (ConfigHotkey)new ConfigHotkey("testHotkey", "", "Test Hotkey").apply("malilib.config.test");
        public static final ConfigInteger TEST_CONFIG_INTEGER = (ConfigInteger)new ConfigInteger("testInteger", 0, "Test Integer").apply("malilib.config.test");
        public static final ConfigOptionList TEST_CONFIG_OPTIONS_LIST = (ConfigOptionList)new ConfigOptionList("testOptionList", ConfigTestOptList.TEST1, "Test Option List").apply("malilib.config.test");
        public static final ConfigString TEST_CONFIG_STRING = (ConfigString)new ConfigString("testString", "testString", "Test String").apply("malilib.config.test");
        public static final ConfigStringList TEST_CONFIG_STRING_LIST = (ConfigStringList)new ConfigStringList("testStringList", (ImmutableList<String>)ImmutableList.of((Object)"testString1", (Object)"testString2"), "Test String List").apply("malilib.config.test");
        public static final ConfigLockedList TEST_CONFIG_LOCKED_LIST = (ConfigLockedList)new ConfigLockedList("testLockedConfigList", ConfigTestLockedList.INSTANCE, "Test Locked List").apply("malilib.config.test");
        public static final ConfigTable TEST_CONFIG_TABLE_1 = (ConfigTable)new ConfigTable.Builder("testTable1", EntryTypes.STRING, EntryTypes.INTEGER, EntryTypes.BOOLEAN, EntryTypes.LABEL, EntryTypes.DOUBLE).build(true).apply("malilib.config.test");
        public static final ConfigTable TEST_CONFIG_TABLE_2 = (ConfigTable)new ConfigTable.Builder("testTable2", EntryTypes.LABEL, EntryTypes.DOUBLE, EntryTypes.DOUBLE, EntryTypes.DOUBLE).setEntryCount(4).setDefaultValue(Test.T(Test.L("cat:"), 0.0, 0.0, 0.0), Test.T(Test.L("dog:"), 0.0, 0.0, 0.0), Test.T(Test.L("cow:"), 0.0, 0.0, 0.0), Test.T(Test.L("fox:"), 0.0, 0.0, 0.0)).setAllowAddNewEntry(false).setDisplayString("Display string").setLabels("", "X position", "Y position", "Z position").build().apply("malilib.config.test");
        public static final ConfigTable TEST_CONFIG_TABLE_3 = (ConfigTable)new ConfigTable.Builder("testTable3", EntryTypes.STRING, EntryTypes.INTEGER, EntryTypes.INTEGER).setShowEntryNumbers(false).build().apply("malilib.config.test");
        public static final ConfigTable TEST_CONFIG_TABLE_4 = (ConfigTable)new ConfigTable.Builder("testTable4", EntryTypes.DOUBLE, EntryTypes.INTEGER, EntryTypes.STRING, EntryTypes.BOOLEAN).setDefaultValue(Test.T(0.0, 1, "2", true), Test.T(1.0, 3, "5", false)).setLabels("Label 1", Test.L("Label 2", "With a comment!"), Test.L("Label 3", "With a big\n\nand scary\n\ncomment >:3")).setComment("Comment").build().apply("malilib.config.test");
        public static final ConfigTable TEST_CONFIG_TABLE_5 = (ConfigTable)new ConfigTable.Builder("testTable5", EntryTypes.LABEL, EntryTypes.DOUBLE, EntryTypes.INTEGER, EntryTypes.STRING).setComment("Another comment").setDefaultValue(Test.T(Test.L("Horizontal label!", "With comments too!"), 213.0, 43, "22")).setEntryCount(5).setAllowAddNewEntry(false).setLabels(List.of("Label 1", "Label 2")).build().apply("malilib.config.test");
        public static final ConfigInteger TEST_BUNDLE_PREVIEW_WIDTH = (ConfigInteger)new ConfigInteger("testBundlePreviewWidth", 9, 6, 9, "Test Bundle Preview Width").apply("malilib.config.test");
        public static final ConfigBooleanHotkeyed TEST_INVENTORY_OVERLAY = new ConfigBooleanHotkeyed("testInventoryOverlay", false, "LEFT_ALT").apply("malilib.config.test");
        public static final ConfigBooleanHotkeyed TEST_INVENTORY_OVERLAY_OG = new ConfigBooleanHotkeyed("testInventoryOverlayOG", false, "").apply("malilib.config.test");
        public static final ConfigHotkey TEST_INVENTORY_OVERLAY_TOGGLE = (ConfigHotkey)new ConfigHotkey("testInventoryOverlayToggle", "BUTTON_3", OVERLAY_TOGGLE).apply("malilib.config.test");
        public static final ConfigHotkey TEST_GUI_KEYBIND = (ConfigHotkey)new ConfigHotkey("testGuiKeybind", "", GUI_RELAXED_CANCEL).apply("malilib.config.test");
        public static final ConfigOptionList TEST_DATE_TIME_OPTION = (ConfigOptionList)new ConfigOptionList("testDateTimeList", TimeFormat.RFC1123).apply("malilib.config.test");
        public static final ConfigOptionList TEST_DURATION_OPTION = (ConfigOptionList)new ConfigOptionList("testDurationList", DurationFormat.PRETTY).apply("malilib.config.test");
        public static final ConfigHotkey TEST_RUN_DATETIME_TEST = (ConfigHotkey)new ConfigHotkey("testRunDateTimeTest", "").apply("malilib.config.test");
        public static final ImmutableList<IConfigBase> OPTIONS = ImmutableList.of((Object)TEST_CONFIG_BOOLEAN, (Object)TEST_CONFIG_BOOLEAN_HOTKEYED, (Object)TEST_CONFIG_COLOR, (Object)TEST_CONFIG_COLOR_LIST, (Object)TEST_CONFIG_DOUBLE, (Object)TEST_CONFIG_FLOAT, (Object)TEST_CONFIG_HOTKEY, (Object)TEST_CONFIG_INTEGER, (Object)TEST_CONFIG_OPTIONS_LIST, (Object)TEST_CONFIG_STRING, (Object)TEST_CONFIG_STRING_LIST, (Object)TEST_CONFIG_LOCKED_LIST, (Object[])new IConfigBase[]{TEST_CONFIG_TABLE_1, TEST_CONFIG_TABLE_2, TEST_CONFIG_TABLE_3, TEST_CONFIG_TABLE_4, TEST_CONFIG_TABLE_5, TEST_BUNDLE_PREVIEW_WIDTH, TEST_INVENTORY_OVERLAY, TEST_INVENTORY_OVERLAY_OG, TEST_INVENTORY_OVERLAY_TOGGLE, TEST_GUI_KEYBIND, TEST_DATE_TIME_OPTION, TEST_DURATION_OPTION, TEST_RUN_DATETIME_TEST});
        public static final List<IHotkey> HOTKEY_LIST = ImmutableList.of((Object)TEST_CONFIG_BOOLEAN_HOTKEYED, (Object)TEST_INVENTORY_OVERLAY, (Object)TEST_INVENTORY_OVERLAY_OG, (Object)TEST_INVENTORY_OVERLAY_TOGGLE, (Object)TEST_GUI_KEYBIND, (Object)TEST_RUN_DATETIME_TEST);

        private static TableRow T(Object ... objects) {
            return TableRow.of(objects);
        }

        private static Label L(String ... strings) {
            return switch (strings.length) {
                case 0 -> Label.of();
                case 1 -> Label.of(strings[0]);
                case 2 -> Label.of(strings[0], strings[1]);
                default -> throw new IllegalArgumentException("Must be < 2 entries");
            };
        }
    }
}

