/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.minecraftApi;

import dev.kosmx.playerAnim.api.IPlayable;
import dev.kosmx.playerAnim.minecraftApi.codec.AnimationCodecs;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public final class PlayerAnimationRegistry {
    private static final HashMap<class_2960, IPlayable> animations = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(PlayerAnimationRegistry.class);

    @Nullable
    public static IPlayable getAnimation(@NotNull class_2960 identifier) {
        return animations.get(identifier);
    }

    @NotNull
    public static Optional<IPlayable> getAnimationOptional(@NotNull class_2960 identifier) {
        return Optional.ofNullable(PlayerAnimationRegistry.getAnimation(identifier));
    }

    public static Map<class_2960, IPlayable> getAnimations() {
        return Map.copyOf(animations);
    }

    @NotNull
    public static Map<String, IPlayable> getModAnimations(@NotNull String modid) {
        HashMap<String, IPlayable> map = new HashMap<String, IPlayable>();
        for (Map.Entry<class_2960, IPlayable> entry : animations.entrySet()) {
            if (!entry.getKey().method_12836().equals(modid)) continue;
            map.put(entry.getKey().method_12832(), entry.getValue());
        }
        return map;
    }

    @ApiStatus.Internal
    public static void resourceLoaderCallback(@NotNull class_3300 manager) {
        Collection<IPlayable> a;
        String extension;
        animations.clear();
        for (Map.Entry resource : manager.method_14488("player_animations", ignore -> true).entrySet()) {
            extension = AnimationCodecs.getExtension(((class_2960)resource.getKey()).method_12832());
            if (extension == null) continue;
            a = AnimationCodecs.deserialize(extension, () -> {
                try {
                    return ((class_3298)resource.getValue()).method_14482();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            for (IPlayable animation : a) {
                try {
                    animations.put(class_2960.method_60655((String)((class_2960)resource.getKey()).method_12836(), (String)PlayerAnimationRegistry.serializeTextToString(animation.getName())), animation);
                }
                catch (Throwable e) {
                    logger.debug("Failed to load animation with name space {} and name {}. Either a PAL animation or has an invalid name.", (Object)((class_2960)resource.getKey()).method_12836(), (Object)animation.getName());
                }
            }
        }
        for (Map.Entry resource : manager.method_14488("player_animation", ignore -> true).entrySet()) {
            extension = AnimationCodecs.getExtension(((class_2960)resource.getKey()).method_12832());
            if (extension == null) continue;
            logger.warn("[WARNING FOR MOD DEVS] Animation {} is in wrong directory: \"player_animation\", please place it in \"player_animations\".", (Object)((class_2960)resource.getKey()).method_12832());
            a = AnimationCodecs.deserialize(extension, () -> {
                try {
                    return ((class_3298)resource.getValue()).method_14482();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            for (IPlayable animation : a) {
                animations.put(class_2960.method_60655((String)((class_2960)resource.getKey()).method_12836(), (String)PlayerAnimationRegistry.serializeTextToString(animation.getName())), animation);
            }
        }
    }

    public static String serializeTextToString(String arg) {
        try {
            class_5250 component = class_2561.class_2562.method_10877((String)arg, (class_7225.class_7874)class_5455.field_40585);
            if (component != null) {
                return component.getString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arg.replace("\"", "");
    }
}

