/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.api.network;

import net.darkhax.bookshelf.common.api.PhysicalSide;
import net.darkhax.bookshelf.common.api.annotation.OnlyFor;
import net.darkhax.bookshelf.common.api.network.Destination;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.bookshelf.common.impl.Constants;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public interface IPacket<T extends class_8710> {
    public class_8710.class_9154<T> type();

    public class_9139<class_9129, T> streamCodec();

    public Destination destination();

    public void handle(@Nullable class_3222 var1, boolean var2, T var3);

    default public void toPlayer(class_3222 recipient, T payload) {
        if (!this.destination().handledByClient()) {
            Constants.LOG.error("Attempted to send invalid packet {} to client! Class: {} Destination: {} Payload: {}", new Object[]{this.type().comp_2242(), this.getClass(), this.destination(), payload.toString()});
            throw new IllegalStateException("Attempted to send invalid packet " + String.valueOf(this.type().comp_2242()) + " to client!");
        }
        Services.NETWORK.sendToPlayer(recipient, payload);
    }

    default public void toAllPlayers(class_3218 level, T payload) {
        this.toAllPlayers(level.method_8503(), payload);
    }

    default public void toAllPlayers(MinecraftServer server, T payload) {
        this.toAllPlayers(server.method_3760(), payload);
    }

    default public void toAllPlayers(class_3324 playerList, T payload) {
        for (class_3222 player : playerList.method_14571()) {
            this.toPlayer(player, payload);
        }
    }

    @OnlyFor(value=PhysicalSide.CLIENT)
    default public void toServer(T payload) {
        if (!this.destination().handledByServer()) {
            Constants.LOG.error("Attempted to send invalid packet {} to server! Class: {} Destination: {} Payload: {}", new Object[]{this.type().comp_2242(), this.getClass(), this.destination(), payload.toString()});
            throw new IllegalStateException("Attempted to send invalid packet " + String.valueOf(this.type().comp_2242()) + " to server!");
        }
        if (class_310.method_1551().method_1562() == null) {
            Constants.LOG.error("Attempted to send packet {} before a connection to a server has been established!", (Object)this.type().comp_2242());
            throw new IllegalStateException("Attempted to send packet " + String.valueOf(this.type().comp_2242()) + " before being connected to a server!");
        }
        Services.NETWORK.sendToServer(payload);
    }
}

