/*
 * Decompiled with CFR 0.152.
 */
package com.plsnerfrito.plsnerfmodcheck.server;

import com.plsnerfrito.plsnerfmodcheck.main.Config;
import com.plsnerfrito.plsnerfmodcheck.main.ModInfo;
import com.plsnerfrito.plsnerfmodcheck.main.ModListComparator;
import com.plsnerfrito.plsnerfmodcheck.net.Payload;
import com.plsnerfrito.plsnerfmodcheck.util.Logger;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class NetworkHandler {
    private static final ModListComparator serverComparator = new ModListComparator(Config.multiClient);
    private static final int TIMEOUT_SECONDS = Config.TIMEOUT_SECONDS;
    private static final Set<class_3222> playerPendingValidation = new HashSet<class_3222>();
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();

    public static void register() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            Logger.USER_LOGGER.info("Initializing network handling...");
            Logger.DEV_LOGGER.debug("[Server] Registering NetworkHandler with the server...");
            if (server.method_3816()) {
                PayloadTypeRegistry registry = PayloadTypeRegistry.playC2S();
                registry.register(Payload.ID, Payload.PACKET_CODEC);
                NetworkHandler.modCheck();
                NetworkHandler.handShake();
                Logger.USER_LOGGER.info("Network handler successfully registered.");
                Logger.DEV_LOGGER.debug("[Server] NetworkHandler successfully registered and ready to use.");
            }
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            Logger.USER_LOGGER.info("Server is shutting down...");
            Logger.DEV_LOGGER.debug("[Server] Stopping server and shutting down scheduler...");
            scheduler.shutdown();
            try {
                if (!scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                    scheduler.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                scheduler.shutdownNow();
                Thread.currentThread().interrupt();
            }
        });
    }

    public static void handShake() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            playerPendingValidation.add(player);
            scheduler.schedule(() -> {
                if (playerPendingValidation.contains(player)) {
                    Logger.USER_LOGGER.warn("Player {} disconnected: Missing required mod.", (Object)player.method_5477().getString());
                    Logger.DEV_LOGGER.debug("Player {} failed to validate the required mod in the allocated timeout.", (Object)player.method_5477().getString());
                    player.field_13987.method_52396((class_2561)class_2561.method_43470((String)("The server requires plsnerfModCheck version " + ModInfo.getModVersion() + ". Please download it from: " + ModInfo.getModHomepage())));
                    playerPendingValidation.remove(player);
                }
            }, (long)TIMEOUT_SECONDS, TimeUnit.SECONDS);
        });
    }

    public static void modCheck() {
        ServerPlayNetworking.registerGlobalReceiver(Payload.ID, (payload, context) -> {
            block6: {
                if (!context.server().method_3816()) {
                    return;
                }
                Logger.DEV_LOGGER.info("[Server] ModCheck message received.");
                if (payload instanceof Payload) {
                    block5: {
                        Payload $b$0 = payload;
                        try {
                            String patt1$temp;
                            String clientHash = patt1$temp = $b$0.message();
                            String serverHash = serverComparator.generateHash();
                            if (clientHash.equals(serverHash)) break block5;
                        }
                        catch (Throwable throwable) {
                            throw new MatchException(throwable.toString(), throwable);
                        }
                        context.player().field_13987.method_52396((class_2561)class_2561.method_43470((String)("Your mod list does not match the server's mod list! Please download the correct modpack here: " + Config.downloadLink)));
                        Logger.USER_LOGGER.warn("Player {} disconnected: Mod list mismatch.", (Object)context.player().method_5477().getString());
                        Logger.DEV_LOGGER.debug("[Server] Player {} was disconnected due to a client hash mismatching the server hash.", (Object)context.player().method_5477().getString());
                        break block6;
                    }
                    if (playerPendingValidation.contains(context.player())) {
                        playerPendingValidation.remove(context.player());
                    }
                    Logger.USER_LOGGER.info("Player {} successfully verified mod list.", (Object)context.player().method_5477().getString());
                    Logger.DEV_LOGGER.debug("[Server] Player {} passed the mod list validation.", (Object)context.player().method_5477().getString());
                }
            }
        });
    }
}

