/*
 * Decompiled with CFR 0.152.
 */
package com.plsnerfrito.plsnerfmodcheck.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.plsnerfrito.plsnerfmodcheck.main.Config;
import com.plsnerfrito.plsnerfmodcheck.util.Logger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class ManifestManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void createManifest() {
        File manifestFile = new File(Config.manifestPath);
        if (!manifestFile.exists()) {
            try (FileWriter writer = new FileWriter(manifestFile);){
                LinkedHashMap<String, Object> manifestTemplate = new LinkedHashMap<String, Object>();
                LinkedHashMap<String, Object> minecraft = new LinkedHashMap<String, Object>();
                minecraft.put("version", "1.21.1");
                minecraft.put("modLoaders", new Object[]{Map.of("id", "fabric-0.16.9", "primary", true)});
                manifestTemplate.put("minecraft", minecraft);
                manifestTemplate.put("manifestType", "minecraftModpack");
                manifestTemplate.put("manifestVersion", 1);
                manifestTemplate.put("name", "PlsnerfModCheck");
                manifestTemplate.put("version", "1.0.0");
                manifestTemplate.put("author", "plsnerfrito");
                manifestTemplate.put("files", new Object[0]);
                manifestTemplate.put("overrides", "overrides");
                GSON.toJson(manifestTemplate, (Appendable)writer);
                Logger.USER_LOGGER.info("The manifest.json file was successfully created.");
                Logger.DEV_LOGGER.debug("The manifest.json file was created at path: {}", (Object)manifestFile.getAbsolutePath());
            }
            catch (IOException e) {
                Logger.USER_LOGGER.error("An error occurred while creating the manifest.json file.");
                Logger.DEV_LOGGER.error("Error details while creating manifest.json: {}", (Object)e.getMessage());
            }
        } else {
            Logger.USER_LOGGER.info("The manifest.json file already exists. No action required.");
            Logger.DEV_LOGGER.debug("No action taken because manifest.json already exists at path: {}", (Object)manifestFile.getAbsolutePath());
        }
    }
}

