/*
 * Decompiled with CFR 0.152.
 */
package com.plsnerfrito.plsnerfmodcheck.client;

import com.plsnerfrito.plsnerfmodcheck.main.Config;
import com.plsnerfrito.plsnerfmodcheck.main.ModListComparator;
import com.plsnerfrito.plsnerfmodcheck.net.Payload;
import com.plsnerfrito.plsnerfmodcheck.util.Logger;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class ClientNetworkHandler {
    private static final ModListComparator clientComparator = new ModListComparator(Config.multiClient);

    public static void register() {
        Logger.USER_LOGGER.info("Initializing client network handler...");
        Logger.DEV_LOGGER.debug("[ClientNetworkHandler] Registering client network handler components.");
        PayloadTypeRegistry registry = PayloadTypeRegistry.playC2S();
        registry.register(Payload.ID, Payload.PACKET_CODEC);
        Logger.DEV_LOGGER.debug("[ClientNetworkHandler] Payload type registered for CLIENTBOUND communication.");
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            Logger.USER_LOGGER.info("Player joined the server. Initializing handshake and mod verification...");
            Logger.DEV_LOGGER.debug("[ClientNetworkHandler] Client joined the server. Preparing to send ModCheck payload.");
            ClientNetworkHandler.sendModCheck();
            Logger.USER_LOGGER.info("Client network handler registered successfully.");
        });
    }

    private static void sendModCheck() {
        Payload payload = new Payload(clientComparator.generateHash());
        ClientPlayNetworking.send((class_8710)payload);
        Logger.USER_LOGGER.info("Sent ModCheck packet with mod list hash to the server.");
        Logger.DEV_LOGGER.debug("[ClientNetworkHandler] ModCheck payload sent to the server: {}", (Object)payload);
    }
}

