/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.athena.impl.client.models;

import com.google.gson.JsonObject;
import earth.terrarium.athena.api.client.models.AthenaBlockModel;
import earth.terrarium.athena.api.client.models.AthenaModelFactory;
import earth.terrarium.athena.api.client.models.AthenaQuad;
import earth.terrarium.athena.api.client.utils.AppearanceAndTintGetter;
import earth.terrarium.athena.api.client.utils.CtmUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1058;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3518;
import net.minecraft.class_4730;

public class GiantBlockModel
implements AthenaBlockModel {
    public static final AthenaModelFactory FACTORY = new Factory();
    private final Int2ObjectMap<class_4730> materials;
    private final int width;
    private final int height;

    public GiantBlockModel(Int2ObjectMap<class_4730> materials, int width, int height) {
        this.materials = materials;
        this.width = width;
        this.height = height;
    }

    @Override
    public List<AthenaQuad> getQuads(AppearanceAndTintGetter level, class_2680 blockState, class_2338 pos, class_2350 direction) {
        int x = Math.abs(pos.method_10263());
        int y = Math.abs(pos.method_10264());
        int z = Math.abs(pos.method_10260());
        return switch (direction.method_10166()) {
            case class_2350.class_2351.field_11048 -> {
                if (direction.method_10171() == class_2350.class_2352.field_11056) {
                    z = Math.abs(z - this.width - 1);
                }
                yield List.of(AthenaQuad.withSprite(1 + z % this.width + y % this.height * this.height));
            }
            case class_2350.class_2351.field_11051 -> {
                if (direction.method_10171() == class_2350.class_2352.field_11060) {
                    x = Math.abs(x - this.width - 1);
                }
                yield List.of(AthenaQuad.withSprite(1 + x % this.width + y % this.height * this.height));
            }
            default -> {
                if (direction.method_10171() == class_2350.class_2352.field_11060) {
                    z = Math.abs(z - this.width - 1);
                }
                yield List.of(AthenaQuad.withSprite(1 + x % this.width + z % this.height * this.height));
            }
        };
    }

    @Override
    public Map<class_2350, List<AthenaQuad>> getDefaultQuads(class_2350 direction) {
        HashMap<class_2350, List<AthenaQuad>> quads = new HashMap<class_2350, List<AthenaQuad>>(class_2350.values().length);
        for (class_2350 dir : class_2350.values()) {
            quads.put(dir, List.of(AthenaQuad.withSprite(0)));
        }
        return quads;
    }

    @Override
    public Int2ObjectMap<class_1058> getTextures(Function<class_4730, class_1058> getter) {
        Int2ObjectArrayMap textures = new Int2ObjectArrayMap();
        for (Int2ObjectMap.Entry entry : this.materials.int2ObjectEntrySet()) {
            textures.put(entry.getIntKey(), (Object)getter.apply((class_4730)entry.getValue()));
        }
        return textures;
    }

    private static class Factory
    implements AthenaModelFactory {
        private Factory() {
        }

        @Override
        public Supplier<AthenaBlockModel> create(JsonObject json) {
            int width = class_3518.method_15260((JsonObject)json, (String)"width");
            int height = class_3518.method_15260((JsonObject)json, (String)"height");
            Int2ObjectMap<class_4730> materials = Factory.parseMaterials(class_3518.method_15296((JsonObject)json, (String)"ctm_textures"), width, height);
            return () -> new GiantBlockModel(materials, width, height);
        }

        private static Int2ObjectMap<class_4730> parseMaterials(JsonObject json, int width, int height) {
            Int2ObjectArrayMap materials = new Int2ObjectArrayMap();
            materials.put(0, (Object)CtmUtils.blockMat(class_3518.method_15265((JsonObject)json, (String)"particle")));
            for (int i = 1; i <= width * height; ++i) {
                class_4730 material = CtmUtils.blockMat(class_3518.method_15265((JsonObject)json, (String)String.valueOf(i)));
                materials.put(i, (Object)material);
            }
            return materials;
        }
    }
}

