/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.crafting;

import java.util.List;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.library.util.RecipeDebugUtil;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2371;
import net.minecraft.class_8786;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CategoryRecipeValidator<T extends class_1860<?>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int INVALID_COUNT = -1;
    private final IRecipeCategory<class_8786<T>> recipeCategory;
    private final IIngredientManager ingredientManager;
    private final int maxInputs;

    public CategoryRecipeValidator(IRecipeCategory<class_8786<T>> recipeCategory, IIngredientManager ingredientManager, int maxInputs) {
        this.recipeCategory = recipeCategory;
        this.ingredientManager = ingredientManager;
        this.maxInputs = maxInputs;
    }

    public boolean isRecipeValid(class_8786<T> recipeHolder) {
        return this.hasValidInputsAndOutputs(recipeHolder);
    }

    public boolean isRecipeHandled(class_8786<T> recipeHolder) {
        return this.recipeCategory.isHandled(recipeHolder);
    }

    private boolean hasValidInputsAndOutputs(class_8786<T> recipeHolder) {
        class_1860 recipe = recipeHolder.comp_1933();
        if (recipe.method_8118()) {
            return true;
        }
        class_1799 recipeOutput = RecipeUtil.getResultItem(recipe);
        if (recipeOutput == null || recipeOutput.method_7960()) {
            if (LOGGER.isDebugEnabled()) {
                String recipeInfo = RecipeDebugUtil.getDebugInfoFromRecipe(recipeHolder, this.recipeCategory, this.ingredientManager);
                LOGGER.debug("Skipping Recipe because it has no output. {}", (Object)recipeInfo);
            }
            return false;
        }
        class_2371 ingredients = recipe.method_8117();
        if (ingredients == null) {
            if (LOGGER.isDebugEnabled()) {
                String recipeInfo = RecipeDebugUtil.getDebugInfoFromRecipe(recipeHolder, this.recipeCategory, this.ingredientManager);
                LOGGER.debug("Skipping Recipe because it has no input Ingredients. {}", (Object)recipeInfo);
            }
            return false;
        }
        int inputCount = CategoryRecipeValidator.getInputCount((List<class_1856>)ingredients);
        if (inputCount == -1) {
            if (LOGGER.isDebugEnabled()) {
                String recipeInfo = RecipeDebugUtil.getDebugInfoFromRecipe(recipeHolder, this.recipeCategory, this.ingredientManager);
                LOGGER.debug("Skipping Recipe because it contains invalid inputs. {}", (Object)recipeInfo);
            }
            return false;
        }
        if (inputCount > this.maxInputs) {
            if (LOGGER.isDebugEnabled()) {
                String recipeInfo = RecipeDebugUtil.getDebugInfoFromRecipe(recipeHolder, this.recipeCategory, this.ingredientManager);
                LOGGER.debug("Skipping Recipe because it has too many inputs. {}", (Object)recipeInfo);
            }
            return false;
        }
        if (inputCount == 0 && this.maxInputs > 0) {
            if (LOGGER.isDebugEnabled()) {
                String recipeInfo = RecipeDebugUtil.getDebugInfoFromRecipe(recipeHolder, this.recipeCategory, this.ingredientManager);
                LOGGER.debug("Skipping Recipe because it has no inputs. {}", (Object)recipeInfo);
            }
            return false;
        }
        return true;
    }

    private static int getInputCount(List<class_1856> ingredientList) {
        int inputCount = 0;
        for (class_1856 ingredient : ingredientList) {
            class_1799[] input = ingredient.method_8105();
            if (input == null) {
                return -1;
            }
            ++inputCount;
        }
        return inputCount;
    }
}

