/*
 * Decompiled with CFR 0.152.
 */
package net.player005.recipe_modification.serialization;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.player005.recipe_modification.api.RecipeModification;
import net.player005.recipe_modification.api.RecipeModifierHolder;
import net.player005.recipe_modification.serialization.ModificationSetSerializer;
import net.player005.recipe_modification.serialization.RecipeFilterSerializer;
import org.slf4j.Logger;

public class RecipeModifierManager
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogUtils.getLogger();

    public RecipeModifierManager() {
        super(GSON, "recipe_modifier");
    }

    protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profiler) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry<class_2960, JsonElement> entry : object.entrySet()) {
            class_2960 id = entry.getKey();
            try {
                JsonObject json = entry.getValue().getAsJsonObject();
                builder.add((Object)new RecipeModifierHolder(id, RecipeFilterSerializer.fromJson(json.get("target_recipes")), ModificationSetSerializer.fromJson(json.get("modifiers"))));
            }
            catch (Exception exception) {
                LOGGER.error("Error loading recipe modifier {}:", (Object)id, (Object)exception);
            }
        }
        ImmutableList list = builder.build();
        RecipeModification.updateJsonRecipeModifiers((ImmutableList<RecipeModifierHolder>)list);
        LOGGER.info("Loaded {} recipe modifiers", (Object)list.size());
    }
}

