/*
 * Decompiled with CFR 0.152.
 */
package net.player005.recipe_modification.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.player005.recipe_modification.api.IngredientSelector;
import net.player005.recipe_modification.serialization.RecipeModifierParsingException;
import org.jetbrains.annotations.Nullable;

public abstract class IngredientSelectorSerializer {
    private static final Map<String, Function<JsonObject, IngredientSelector>> deserializers = new HashMap<String, Function<JsonObject, IngredientSelector>>();

    public static IngredientSelector fromJson(@Nullable JsonElement json) {
        if (json == null) {
            throw new RecipeModifierParsingException("Missing ingredient selector. Maybe you typed \"ingredient\" instead of \"ingredients\"?");
        }
        if (json instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)json;
            if (primitive.isNumber()) {
                return IngredientSelector.byOrdinals(primitive.getAsInt());
            }
            if (primitive.isString()) {
                return IngredientSelectorSerializer.fromString(primitive.getAsString());
            }
        }
        if (json instanceof JsonArray) {
            JsonArray array = (JsonArray)json;
            ArrayList<IngredientSelector> toReturn = new ArrayList<IngredientSelector>();
            for (JsonElement jsonElement : array) {
                toReturn.add(IngredientSelectorSerializer.fromJson(jsonElement));
            }
            return IngredientSelector.and((IngredientSelector[])toReturn.toArray(IngredientSelector[]::new));
        }
        if (json instanceof JsonObject) {
            JsonObject object = (JsonObject)json;
            Function<JsonObject, IngredientSelector> deserializer = deserializers.get(object.get("type").getAsString());
            if (deserializer == null) {
                throw new RecipeModifierParsingException("Invalid ingredient selector: unknown selector type " + object.get("type").getAsString());
            }
            return deserializer.apply(object);
        }
        throw new RecipeModifierParsingException("Invalid ingredient selector");
    }

    private static IngredientSelector fromString(String string) {
        class_1792 item;
        if (string.equals("*")) {
            return IngredientSelector.ALL_INGREDIENTS;
        }
        if (string.startsWith("#")) {
            return IngredientSelector.matchingTag((class_6862<class_1792>)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60654((String)string.substring(1))));
        }
        boolean isStrict = string.endsWith("!");
        if (isStrict) {
            string = string.substring(0, string.length() - 1);
        }
        if ((item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)string))) == class_1802.field_8162) {
            throw new RecipeModifierParsingException("Invalid item: " + string);
        }
        return isStrict ? IngredientSelector.matchingItem(item) : IngredientSelector.byItem(item);
    }

    public static void registerSerializer(String name, Function<JsonObject, IngredientSelector> deserializer) {
        deserializers.put(name, deserializer);
    }

    static {
        IngredientSelectorSerializer.registerSerializer("all", json -> IngredientSelector.ALL_INGREDIENTS);
        IngredientSelectorSerializer.registerSerializer("match_item", json -> {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)json.get("item").getAsString()));
            return IngredientSelector.byItem(item);
        });
        IngredientSelectorSerializer.registerSerializer("match_item_exact", json -> {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)json.get("item").getAsString()));
            return IngredientSelector.matchingItem(item);
        });
        IngredientSelectorSerializer.registerSerializer("match_tag", json -> {
            class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60654((String)json.get("tag").getAsString()));
            return IngredientSelector.matchingTag((class_6862<class_1792>)tag);
        });
        IngredientSelectorSerializer.registerSerializer("from_ordinals", json -> {
            ArrayList<Integer> ordinals = new ArrayList<Integer>();
            JsonElement patt0$temp = json.get("ordinals");
            if (patt0$temp instanceof JsonArray) {
                JsonArray array = (JsonArray)patt0$temp;
                for (JsonElement jsonElement : array) {
                    ordinals.add(jsonElement.getAsInt());
                }
            } else {
                JsonElement patt1$temp = json.get("ordinal");
                if (patt1$temp instanceof JsonPrimitive) {
                    JsonPrimitive primitive = (JsonPrimitive)patt1$temp;
                    ordinals.add(primitive.getAsInt());
                } else {
                    throw new RecipeModifierParsingException("Invalid ordinal selector");
                }
            }
            return IngredientSelector.byOrdinals(ordinals);
        });
    }
}

