/*
 * Decompiled with CFR 0.152.
 */
package forge.me.thosea.badoptimizations.mixin;

import forge.me.thosea.badoptimizations.config.Config;
import forge.me.thosea.badoptimizations.hook.CacheHooks;
import forge.me.thosea.badoptimizations.utils.PlatformMethods;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class BOMixinPlugin
implements IMixinConfigPlugin {
    private static final boolean isOnServer = PlatformMethods.isOnServer();

    public void onLoad(String mixinPackage) {
        if (isOnServer) {
            return;
        }
        Config.init();
        CacheHooks.init();
    }

    public boolean shouldApplyMixin(String targetClassName, String mixin) {
        if (isOnServer) {
            return false;
        }
        if ((mixin = mixin.substring("forge.me.thosea.badoptimizations.mixin.".length())).equals("tick.MixinLightTexture") || mixin.equals("accessors.GameRendererAccessor") || mixin.equals("accessors.PlayerAccessor")) {
            return Config.lightmapCaching.effectiveValue;
        }
        if (mixin.equals("tick.MixinClientWorld")) {
            return Config.skyColorCaching.effectiveValue;
        }
        if (mixin.startsWith("debug.")) {
            return Config.debugRendererDisableIfNotNeeded.effectiveValue;
        }
        if (mixin.equals("MixinParticleManager")) {
            return Config.particleManagerOptimization.effectiveValue;
        }
        if (mixin.equals("MixinToastComponent")) {
            return Config.toastOptimizations.effectiveValue;
        }
        if (mixin.equals("MixinWorldRenderer")) {
            return Config.skyAngleCaching.effectiveValue;
        }
        if (mixin.startsWith("renderer.entity.")) {
            return Config.entityRendererCaching.effectiveValue;
        }
        if (mixin.startsWith("renderer.blockentity.")) {
            return Config.blockEntityRendererCaching.effectiveValue;
        }
        if (mixin.equals("tick.MixinGameRenderer")) {
            return Config.removeRedundantFovCalcs.effectiveValue;
        }
        if (mixin.equals("tick.MixinTutorial")) {
            return Config.removeTutorialIfNotDemo.effectiveValue;
        }
        if (mixin.equals("MixinDebugHud_AddText")) {
            return Config.showF3Text;
        }
        throw new RuntimeException("No config option for mixin " + mixin);
    }

    public String getRefMapperConfig() {
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

