/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.integration.jei.transfer;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.block.entity.KegBlockEntity;
import umpaz.brewinandchewin.common.block.entity.container.KegMenu;
import umpaz.brewinandchewin.common.crafting.KegPouringRecipe;
import umpaz.brewinandchewin.common.network.serverbound.JEITransferKegRecipeServerboundPacket;
import umpaz.brewinandchewin.common.registry.BnCMenuTypes;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;
import umpaz.brewinandchewin.integration.jei.BnCJEIRecipeTypes;
import umpaz.brewinandchewin.integration.jei.KegFermentingPouringRecipe;

public class FermentingTransfer {

    private record InventoryState(Map<class_1735, class_1799> availableItemStacks, int filledCraftSlotCount, int emptySlotCount) {
        private boolean hasRoom(int inputCount) {
            return this.filledCraftSlotCount - inputCount <= this.emptySlotCount;
        }
    }

    public static class TransferOperations {
        public final List<Pair<class_1735, class_1735>> results = new ArrayList<Pair<class_1735, class_1735>>();
        public final List<Pair<class_1735, Long>> fluidResults = new ArrayList<Pair<class_1735, Long>>();
        public final List<Pair<class_1735, Long>> emptyingResults = new ArrayList<Pair<class_1735, Long>>();
        public final List<IRecipeSlotView> missingItems = new ArrayList<IRecipeSlotView>();
        public boolean canEmpty = true;
        public boolean notEnoughFluid = false;
        public boolean invalidFluid = false;

        public static TransferOperations readFromIntegers(List<Pair<Integer, Integer>> resultSlots, List<Pair<Integer, Long>> fluidSlots, List<Pair<Integer, Long>> emptyingSlots, class_1703 menu) {
            TransferOperations operations = new TransferOperations();
            for (Pair<Integer, Integer> pair : resultSlots) {
                int inventorySlotIndex = (Integer)pair.getFirst();
                int craftingSlotIndex = (Integer)pair.getSecond();
                operations.results.add((Pair<class_1735, class_1735>)Pair.of((Object)menu.method_7611(inventorySlotIndex), (Object)menu.method_7611(craftingSlotIndex)));
            }
            for (Pair pair : fluidSlots) {
                int fluidSlotIndex = (Integer)pair.getFirst();
                long fluidAmount = (Long)pair.getSecond();
                operations.fluidResults.add((Pair<class_1735, Long>)Pair.of((Object)menu.method_7611(fluidSlotIndex), (Object)fluidAmount));
            }
            for (Pair pair : emptyingSlots) {
                int emptyingSlotIndex = (Integer)pair.getFirst();
                long fluidAmount = (Long)pair.getSecond();
                operations.emptyingResults.add((Pair<class_1735, Long>)Pair.of((Object)menu.method_7611(emptyingSlotIndex), (Object)fluidAmount));
            }
            return operations;
        }
    }

    private record SlotReference(class_1735 slot, class_1799 stack, @Nullable Long fluidAmount, int shrinkAmount) {
    }

    public static class Handler
    implements IRecipeTransferHandler<KegMenu, KegFermentingPouringRecipe> {
        private final IRecipeTransferHandlerHelper helper;
        private final IStackHelper stackHelper;
        private final IPlatformFluidHelper<?> platformFluidHelper;

        public Handler(IRecipeTransferHandlerHelper helper, IStackHelper stackHelper, IPlatformFluidHelper<?> platformFluidHelper) {
            this.helper = helper;
            this.stackHelper = stackHelper;
            this.platformFluidHelper = platformFluidHelper;
        }

        public Class<? extends KegMenu> getContainerClass() {
            return KegMenu.class;
        }

        public Optional<class_3917<KegMenu>> getMenuType() {
            return Optional.of(BnCMenuTypes.KEG);
        }

        public RecipeType<KegFermentingPouringRecipe> getRecipeType() {
            return BnCJEIRecipeTypes.FERMENTING;
        }

        @Nullable
        public IRecipeTransferError transferRecipe(KegMenu menu, KegFermentingPouringRecipe recipe, IRecipeSlotsView view, class_1657 player, boolean maxTransfer, boolean doTransfer) {
            int requiredInv;
            if (!KegBlockEntity.isValidTemp(menu.getKegTemperature(), recipe.getTemperature())) {
                class_5250 message = class_2561.method_43471((String)"brewinandchewin.jei.tooltip.error.recipe.transfer.temperature");
                return this.helper.createUserErrorWithTooltip((class_2561)message);
            }
            Info info = Info.INSTANCE;
            List<class_1735> craftingSlots = Collections.unmodifiableList(info.getRecipeSlots(menu, recipe));
            List<class_1735> inventorySlots = Collections.unmodifiableList(info.getInventorySlots(menu, recipe));
            List<IRecipeSlotView> inputItemSlotViews = view.getSlotViews(RecipeIngredientRole.INPUT).stream().filter(ingredientView -> ingredientView.getAllIngredients().anyMatch(ingredient -> ingredient.getIngredient((IIngredientType)VanillaTypes.ITEM_STACK).isPresent())).toList();
            InventoryState inv = this.createInvState(craftingSlots, inventorySlots);
            if (!inv.hasRoom(requiredInv = inputItemSlotViews.size())) {
                class_5250 message = class_2561.method_43471((String)"jei.tooltip.error.recipe.transfer.inventory.full");
                return this.helper.createUserErrorWithTooltip((class_2561)message);
            }
            TransferOperations operations = this.createOperations(inv.availableItemStacks, inputItemSlotViews, recipe.getFluidIngredient().isPresent() ? (IRecipeSlotView)view.getSlotViews(RecipeIngredientRole.INPUT).stream().filter(ingredientView -> ingredientView.getAllIngredients().anyMatch(ingredient -> ingredient.getIngredient((IIngredientType)this.platformFluidHelper.getFluidIngredientType()).isPresent())).findFirst().orElse(null) : null, recipe, menu, craftingSlots, maxTransfer);
            if (!operations.canEmpty) {
                class_5250 message = class_2561.method_43471((String)"brewinandchewin.jei.tooltip.error.recipe.transfer.cant_empty");
                return this.helper.createUserErrorWithTooltip((class_2561)message);
            }
            if (operations.notEnoughFluid) {
                class_5250 message = class_2561.method_43471((String)"brewinandchewin.jei.tooltip.error.recipe.transfer.not_enough_fluid");
                return this.helper.createUserErrorWithTooltip((class_2561)message);
            }
            if (operations.invalidFluid) {
                class_5250 message = class_2561.method_43471((String)"brewinandchewin.jei.tooltip.error.recipe.transfer.invalid_fluid");
                return this.helper.createUserErrorWithTooltip((class_2561)message);
            }
            if (!operations.missingItems.isEmpty()) {
                class_5250 message = class_2561.method_43471((String)"jei.tooltip.error.recipe.transfer.missing");
                return this.helper.createUserErrorForMissingSlots((class_2561)message, operations.missingItems);
            }
            if (doTransfer) {
                BrewinAndChewin.getHelper().sendServerbound(new JEITransferKegRecipeServerboundPacket(recipe.getId(), operations.results.stream().map(pair -> Pair.of((Object)((class_1735)pair.getFirst()).field_7874, (Object)((class_1735)pair.getSecond()).field_7874)).toList(), operations.fluidResults.stream().map(pair -> Pair.of((Object)((class_1735)pair.getFirst()).field_7874, (Object)((Long)pair.getSecond()))).toList(), operations.emptyingResults.stream().map(pair -> Pair.of((Object)((class_1735)pair.getFirst()).field_7874, (Object)((Long)pair.getSecond()))).toList(), craftingSlots.stream().map(slot -> slot.field_7874).toList(), inventorySlots.stream().map(slot -> slot.field_7874).toList(), maxTransfer));
            }
            return null;
        }

        private InventoryState createInvState(Collection<class_1735> craftingSlots, Collection<class_1735> inventorySlots) {
            class_1799 stack;
            HashMap<class_1735, class_1799> availableItemStacks = new HashMap<class_1735, class_1799>();
            int filledCraftSlotCount = 0;
            int emptySlotCount = 0;
            for (class_1735 slot : craftingSlots) {
                stack = slot.method_7677();
                if (stack.method_7960()) continue;
                ++filledCraftSlotCount;
                availableItemStacks.put(slot, stack.method_7972());
            }
            for (class_1735 slot : inventorySlots) {
                stack = slot.method_7677();
                if (!stack.method_7960()) {
                    availableItemStacks.put(slot, stack.method_7972());
                    continue;
                }
                ++emptySlotCount;
            }
            return new InventoryState(availableItemStacks, filledCraftSlotCount, emptySlotCount);
        }

        /*
         * WARNING - void declaration
         */
        private TransferOperations createOperations(Map<class_1735, class_1799> availableItemStacks, List<IRecipeSlotView> requiredItemStacks, IRecipeSlotView requiredFluidStack, KegFermentingPouringRecipe recipe, KegMenu menu, List<class_1735> craftingSlots, boolean maxTransfer) {
            List allMatching;
            long l;
            void var21_28;
            TransferOperations operations = new TransferOperations();
            IdentityHashMap<IRecipeSlotView, Map> relevantSlots = new IdentityHashMap<IRecipeSlotView, Map>();
            IdentityHashMap<class_1799, List> emptyingSlots = new IdentityHashMap<class_1799, List>();
            boolean hasTooMuchFluid = false;
            long fluidCapacity = 0L;
            long largestFluidCapacity = 0L;
            long largestEmptyCapacity = 0L;
            for (Map.Entry<class_1735, class_1799> slotTuple : availableItemStacks.entrySet()) {
                long tankAmount;
                List<KegPouringRecipe> pouringRecipes;
                Optional<KegPouringRecipe> optional;
                for (IRecipeSlotView iRecipeSlotView : requiredItemStacks) {
                    if (iRecipeSlotView.isEmpty() || !iRecipeSlotView.getItemStacks().anyMatch(it -> this.stackHelper.isEquivalent(it, (class_1799)slotTuple.getValue(), UidContext.Ingredient))) continue;
                    relevantSlots.computeIfAbsent(iRecipeSlotView, it -> new Object2ObjectOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<class_1799>(){

                        public int hashCode(class_1799 o) {
                            return o.method_7909().hashCode();
                        }

                        public boolean equals(class_1799 a, class_1799 b) {
                            return stackHelper.isEquivalent(a, b, UidContext.Ingredient);
                        }
                    })).computeIfAbsent(slotTuple.getValue(), it -> new ArrayList()).add(new SlotReference(slotTuple.getKey(), slotTuple.getValue(), null, 1));
                }
                if (!(menu.kegTank.isEmpty() || maxTransfer && !recipe.getFluidIngredient().isEmpty() && recipe.getFluidIngredient().get().ingredient().matches(menu.kegTank.getAbstractedFluid()) || !(optional = (pouringRecipes = class_310.method_1551().field_1687.method_8433().method_30027(BnCRecipeTypes.KEG_POURING).stream().map(class_8786::comp_1933).filter(kegPouringRecipe -> kegPouringRecipe.getFluid((class_1799)slotTuple.getValue()).matches(menu.kegTank.getAbstractedFluid())).toList()).stream().filter(pouring -> {
                    if (pouring.isStrict()) {
                        return class_1799.method_31577((class_1799)((class_1799)slotTuple.getValue()), (class_1799)pouring.getContainer());
                    }
                    return class_1799.method_7984((class_1799)((class_1799)slotTuple.getValue()), (class_1799)pouring.getContainer());
                }).findFirst()).isPresent())) {
                    int shrinkAmount;
                    if (optional.get().getRawFluid().amount() <= menu.kegTank.getAbstractedFluid().amount()) {
                        shrinkAmount = (int)(menu.kegTank.getAbstractedFluid().amount() / optional.get().getRawFluid().amount());
                        emptyingSlots.computeIfAbsent(slotTuple.getValue(), it -> new ArrayList()).add(new SlotReference(slotTuple.getKey(), slotTuple.getValue(), optional.get().getRawFluid().amount() * (long)shrinkAmount, shrinkAmount));
                    }
                    if (recipe.getFluidIngredient().isPresent() && recipe.getFluidIngredient().get().ingredient().matches(menu.kegTank.getAbstractedFluid()) && optional.get().getRawFluid().amount() <= recipe.getFluidIngredient().get().amount() && fluidCapacity < recipe.getFluidIngredient().get().amount()) {
                        if (optional.get().getRawFluid().amount() > largestEmptyCapacity) {
                            relevantSlots.remove(requiredFluidStack);
                        }
                        shrinkAmount = (int)(recipe.getFluidIngredient().get().amount() / optional.get().getRawFluid().amount());
                        largestEmptyCapacity = optional.get().getRawFluid().amount();
                        relevantSlots.computeIfAbsent(requiredFluidStack, it -> new Object2ObjectOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<class_1799>(){

                            public int hashCode(class_1799 o) {
                                return o.method_7909().hashCode();
                            }

                            public boolean equals(class_1799 a, class_1799 b) {
                                return stackHelper.isEquivalent(a, b, UidContext.Ingredient);
                            }
                        })).computeIfAbsent(slotTuple.getValue(), it -> new ArrayList()).add(new SlotReference(slotTuple.getKey(), optional.get().method_8110((class_7225.class_7874)class_310.method_1551().field_1687.method_30349()).method_46651(shrinkAmount), optional.get().getRawFluid().amount() * (long)shrinkAmount, shrinkAmount));
                    }
                }
                if (!recipe.getFluidIngredient().isPresent() || requiredFluidStack.isEmpty() || !requiredFluidStack.getIngredients((IIngredientType)this.platformFluidHelper.getFluidIngredientType()).findFirst().isPresent()) continue;
                pouringRecipes = class_310.method_1551().field_1687.method_8433().method_30027(BnCRecipeTypes.KEG_POURING).stream().map(class_8786::comp_1933).filter(kegPouringRecipe -> kegPouringRecipe.canFill() && recipe.getFluidIngredient().get().ingredient().matches(kegPouringRecipe.getFluid((class_1799)slotTuple.getValue()))).toList();
                Optional<KegPouringRecipe> optional2 = pouringRecipes.stream().filter(pouring -> {
                    if (pouring.isStrict()) {
                        return class_1799.method_31577((class_1799)((class_1799)slotTuple.getValue()), (class_1799)pouring.getOutput());
                    }
                    return class_1799.method_7984((class_1799)((class_1799)slotTuple.getValue()), (class_1799)pouring.getOutput());
                }).findFirst();
                long l2 = tankAmount = recipe.getFluidIngredient().get().ingredient().matches(menu.kegTank.getAbstractedFluid()) ? menu.kegTank.getAbstractedFluid().amount() : 0L;
                if (!optional2.isPresent()) continue;
                if (optional2.get().getRawFluid().amount() <= menu.kegTank.getFluidCapacity() - tankAmount && fluidCapacity < menu.kegTank.getFluidCapacity() - tankAmount) {
                    if (optional2.get().getRawFluid().amount() > largestFluidCapacity) {
                        relevantSlots.remove(requiredFluidStack);
                    }
                    int shrinkAmount = (int)(recipe.getFluidIngredient().get().amount() / optional2.get().getRawFluid().amount() - tankAmount % recipe.getFluidIngredient().get().amount() / optional2.get().getRawFluid().amount());
                    largestFluidCapacity = optional2.get().getRawFluid().amount();
                    fluidCapacity += optional2.get().getRawFluid().amount() * (long)shrinkAmount;
                    relevantSlots.computeIfAbsent(requiredFluidStack, it -> new Object2ObjectOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<class_1799>(){

                        public int hashCode(class_1799 o) {
                            return o.method_7909().hashCode();
                        }

                        public boolean equals(class_1799 a, class_1799 b) {
                            return stackHelper.isEquivalent(a, b, UidContext.Ingredient);
                        }
                    })).computeIfAbsent(slotTuple.getValue(), it -> new ArrayList()).add(new SlotReference(slotTuple.getKey(), slotTuple.getValue(), optional2.get().getRawFluid().amount() * (long)shrinkAmount, shrinkAmount));
                    continue;
                }
                hasTooMuchFluid = true;
            }
            Object2ObjectArrayMap bestMatches = new Object2ObjectArrayMap();
            ArrayList emptyingBestMatches = new ArrayList();
            for (Map.Entry entry : relevantSlots.entrySet()) {
                ArrayList<List> countedAndSorted = new ArrayList<List>();
                for (Map.Entry foundSlots : ((Map)entry.getValue()).entrySet()) {
                    ((List)foundSlots.getValue()).sort((o1, o2) -> {
                        int compare;
                        int n = compare = o1.fluidAmount != null && o2.fluidAmount != null ? Long.compare(o1.fluidAmount, o2.fluidAmount) : Integer.compare(o1.stack.method_7947(), o2.stack.method_7947());
                        if (compare == 0) {
                            return Integer.compare(o1.slot.field_7874, o2.slot.field_7874);
                        }
                        return compare;
                    });
                    countedAndSorted.add((List)foundSlots.getValue());
                }
                countedAndSorted.sort((o1, o2) -> {
                    int compare = Long.compare(o2.stream().mapToLong(it -> it.stack.method_7947()).sum(), o1.stream().mapToLong(it -> it.stack.method_7947()).sum());
                    if (compare == 0) {
                        return Integer.compare(o1.stream().mapToInt(it -> it.slot.field_7874).min().orElse(0), o2.stream().mapToInt(it -> it.slot.field_7874).min().orElse(0));
                    }
                    return compare;
                });
                bestMatches.put((IRecipeSlotView)entry.getKey(), countedAndSorted);
            }
            for (Map.Entry entry : emptyingSlots.entrySet()) {
                ArrayList<List> countedAndSorted = new ArrayList<List>();
                ((List)entry.getValue()).sort((o1, o2) -> {
                    int compare;
                    int n = compare = o1.fluidAmount != null && o2.fluidAmount != null ? Long.compare(o1.fluidAmount, o2.fluidAmount) : Integer.compare(o1.stack.method_7947(), o2.stack.method_7947());
                    if (compare == 0) {
                        return Integer.compare(o1.slot.field_7874, o2.slot.field_7874);
                    }
                    return compare;
                });
                countedAndSorted.add((List)entry.getValue());
                countedAndSorted.sort((o1, o2) -> {
                    int compare = Long.compare(o2.stream().mapToLong(it -> it.stack.method_7947()).sum(), o1.stream().mapToLong(it -> it.stack.method_7947()).sum());
                    if (compare == 0) {
                        return Integer.compare(o1.stream().mapToInt(it -> it.slot.field_7874).min().orElse(0), o2.stream().mapToInt(it -> it.slot.field_7874).min().orElse(0));
                    }
                    return compare;
                });
                emptyingBestMatches.addAll(countedAndSorted);
            }
            ArrayList<IRecipeSlotView> inclusiveRequiredItemStacks = new ArrayList<IRecipeSlotView>(requiredItemStacks);
            if (requiredFluidStack != null) {
                inclusiveRequiredItemStacks.add(requiredFluidStack);
            }
            for (IRecipeSlotView ingredient : inclusiveRequiredItemStacks) {
                if (ingredient.isEmpty()) continue;
                bestMatches.computeIfAbsent(ingredient, it -> new ArrayList());
            }
            boolean bl = false;
            while (var21_28 < requiredItemStacks.size()) {
                IRecipeSlotView requiredItemStack = requiredItemStacks.get((int)var21_28);
                if (!requiredItemStack.isEmpty()) {
                    class_1735 craftingSlot = craftingSlots.get((int)var21_28);
                    SlotReference matching = ((List)bestMatches.get(requiredItemStack)).stream().flatMap(pairs -> pairs.stream().filter(p -> !p.stack.method_7960())).findFirst().orElse(null);
                    if (matching == null) {
                        operations.missingItems.add(requiredItemStack);
                    } else {
                        matching.stack.method_7934(matching.shrinkAmount);
                        operations.results.add((Pair<class_1735, class_1735>)Pair.of((Object)matching.slot, (Object)craftingSlot));
                    }
                }
                ++var21_28;
            }
            if (requiredFluidStack != null && recipe.getFluidIngredient().isPresent() && (l = Math.max((maxTransfer ? menu.kegTank.getFluidCapacity() : recipe.getFluidIngredient().get().amount()) - (recipe.getFluidIngredient().get().ingredient().matches(menu.kegTank.getAbstractedFluid()) ? menu.kegTank.getAbstractedFluid().amount() : 0L), 0L)) > 0L) {
                allMatching = ((List)bestMatches.get(requiredFluidStack)).stream().flatMap(pairs -> pairs.stream().filter(p -> !p.stack.method_7960() && p.fluidAmount != null)).toList();
                if (allMatching.isEmpty()) {
                    operations.missingItems.add(requiredFluidStack);
                    if (hasTooMuchFluid) {
                        operations.invalidFluid = true;
                    }
                } else {
                    ArrayList<SlotReference> toShrink = new ArrayList<SlotReference>();
                    for (SlotReference matching : allMatching) {
                        if (l <= 0L) break;
                        toShrink.add(matching);
                        operations.fluidResults.add((Pair<class_1735, Long>)Pair.of((Object)matching.slot, (Object)matching.fluidAmount));
                        l -= matching.fluidAmount != null ? matching.fluidAmount : 0L;
                    }
                    if (l > 0L) {
                        operations.fluidResults.clear();
                        operations.notEnoughFluid = true;
                    } else {
                        toShrink.forEach(slotReference -> slotReference.stack.method_7934(slotReference.shrinkAmount));
                    }
                }
            }
            if (!emptyingBestMatches.isEmpty()) {
                long l3 = menu.kegTank.getAbstractedFluid().amount();
                allMatching = emptyingBestMatches.stream().flatMap(pairs -> pairs.stream().filter(p -> !p.stack.method_7960() && p.fluidAmount != null)).toList();
                if (allMatching.isEmpty() && !menu.kegTank.isEmpty() && (recipe.getFluidIngredient().isEmpty() || !recipe.getFluidIngredient().get().ingredient().matches(menu.kegTank.getAbstractedFluid()))) {
                    operations.canEmpty = false;
                } else {
                    ArrayList<SlotReference> toShrink = new ArrayList<SlotReference>();
                    for (SlotReference matching : allMatching) {
                        if (l3 <= 0L) break;
                        toShrink.add(matching);
                        operations.emptyingResults.add((Pair<class_1735, Long>)Pair.of((Object)matching.slot, (Object)matching.fluidAmount));
                        l3 -= matching.fluidAmount != null ? matching.fluidAmount : 0L;
                    }
                    if (!(l3 <= 0L || menu.kegTank.isEmpty() || !recipe.getFluidIngredient().isEmpty() && recipe.getFluidIngredient().get().ingredient().matches(menu.kegTank.getAbstractedFluid()))) {
                        operations.emptyingResults.clear();
                        operations.canEmpty = false;
                    } else {
                        toShrink.forEach(slotReference -> slotReference.stack.method_7934(slotReference.shrinkAmount));
                    }
                }
            }
            if (!menu.kegTank.isEmpty() && emptyingBestMatches.isEmpty() && (recipe.getFluidIngredient().isEmpty() || !recipe.getFluidIngredient().get().ingredient().matches(menu.kegTank.getAbstractedFluid()) || recipe.getFluidIngredient().isPresent() && menu.kegTank.getAbstractedFluid().amount() % recipe.getFluidIngredient().get().amount() != 0L)) {
                operations.canEmpty = false;
            }
            return operations;
        }
    }

    public static class Info
    implements IRecipeTransferInfo<KegMenu, KegFermentingPouringRecipe> {
        public static final Info INSTANCE = new Info();

        protected Info() {
        }

        public Class<? extends KegMenu> getContainerClass() {
            return KegMenu.class;
        }

        public Optional<class_3917<KegMenu>> getMenuType() {
            return Optional.of(BnCMenuTypes.KEG);
        }

        public RecipeType<KegFermentingPouringRecipe> getRecipeType() {
            return BnCJEIRecipeTypes.FERMENTING;
        }

        public boolean canHandle(KegMenu container, KegFermentingPouringRecipe recipe) {
            return true;
        }

        public List<class_1735> getRecipeSlots(KegMenu container, KegFermentingPouringRecipe recipe) {
            ArrayList<class_1735> slots = new ArrayList<class_1735>();
            for (int i = 0; i < 4; ++i) {
                class_1735 slot = container.method_7611(i);
                slots.add(slot);
            }
            return slots;
        }

        public List<class_1735> getInventorySlots(KegMenu container, KegFermentingPouringRecipe recipe) {
            ArrayList<class_1735> slots = new ArrayList<class_1735>();
            for (int i = 6; i < 42; ++i) {
                class_1735 slot = container.method_7611(i);
                slots.add(slot);
            }
            return slots;
        }
    }
}

