/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.integration.jei.category;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9335;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.client.utility.BnCFluidItemDisplays;
import umpaz.brewinandchewin.common.BnCConfiguration;
import umpaz.brewinandchewin.common.crafting.KegPouringRecipe;
import umpaz.brewinandchewin.common.registry.BnCItems;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;
import umpaz.brewinandchewin.common.utility.BnCTextUtils;
import umpaz.brewinandchewin.integration.jei.BnCJEIRecipeTypes;
import umpaz.brewinandchewin.integration.jei.KegFermentingPouringRecipe;
import vectorwing.farmersdelight.common.utility.ClientRenderUtils;

public class FermentingRecipeCategory
implements IRecipeCategory<KegFermentingPouringRecipe> {
    public static final class_2960 UID = BrewinAndChewin.asResource("fermenting");
    protected final IModIdHelper modIdHelper;
    protected final IPlatformFluidHelper<?> fluidHelper;
    protected final IDrawableAnimated arrow;
    private final class_2561 title;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable cold;
    private final IDrawable chilly;
    private final IDrawable warm;
    private final IDrawable hot;
    protected final IDrawable timeIcon;
    protected final IDrawable expIcon;
    protected final IDrawable kegOverlay;
    protected final IDrawableAnimated leftBubble;
    protected final IDrawableAnimated rightBubble;

    public FermentingRecipeCategory(IGuiHelper guiHelper, IPlatformFluidHelper<?> fluidHelper, IModIdHelper modIdHelper) {
        this.modIdHelper = modIdHelper;
        this.fluidHelper = fluidHelper;
        this.title = BnCTextUtils.getTranslation("jei.fermenting", new Object[0]);
        class_2960 backgroundImage = BrewinAndChewin.asResource("textures/gui/jei/keg.png");
        this.background = guiHelper.createDrawable(backgroundImage, 12, 13, 136, 56);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)BnCItems.KEG));
        this.arrow = guiHelper.drawableBuilder(backgroundImage, 171, 4, 23, 16).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.cold = guiHelper.createDrawable(backgroundImage, 170, 0, 8, 3);
        this.chilly = guiHelper.createDrawable(backgroundImage, 178, 0, 9, 3);
        this.warm = guiHelper.createDrawable(backgroundImage, 195, 0, 9, 3);
        this.hot = guiHelper.createDrawable(backgroundImage, 204, 0, 8, 3);
        this.expIcon = guiHelper.createDrawable(backgroundImage, 170, 32, 9, 9);
        this.timeIcon = guiHelper.createDrawable(backgroundImage, 170, 21, 8, 11);
        this.kegOverlay = guiHelper.createDrawable(backgroundImage, 170, 45, 26, 30);
        this.leftBubble = guiHelper.drawableBuilder(backgroundImage, 170, 75, 9, 24).buildAnimated(50, IDrawableAnimated.StartDirection.BOTTOM, false);
        this.rightBubble = guiHelper.drawableBuilder(backgroundImage, 180, 75, 9, 24).buildAnimated(50, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    public RecipeType<KegFermentingPouringRecipe> getRecipeType() {
        return BnCJEIRecipeTypes.FERMENTING;
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, KegFermentingPouringRecipe recipe, IFocusGroup focusGroup) {
        if (recipe.getFluidIngredient().isPresent()) {
            if (((BnCConfiguration.Client)BnCConfiguration.CLIENT_CONFIG.get()).renderFluidInKeg()) {
                recipeSlot = builder.addSlot(RecipeIngredientRole.INPUT, 0, 2).setFluidRenderer(((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).keg().localizedCapacity(), false, 26, 30).setOverlay(this.kegOverlay, 0, 0);
                recipeSlot.addIngredients((IIngredientType)this.fluidHelper.getFluidIngredientType(), recipe.getFluidIngredient().get().ingredient().displayStacks().stream().map(abstractedFluidStack -> this.fluidHelper.create((class_6880)abstractedFluidStack.fluid().method_40178(), recipe.getFluidIngredient().get().loaderAmount(), abstractedFluidStack.componentPatch())).toList());
            } else {
                recipeSlot = builder.addInvisibleIngredients(RecipeIngredientRole.INPUT);
                recipeSlot.addIngredients((IIngredientType)this.fluidHelper.getFluidIngredientType(), recipe.getFluidIngredient().get().ingredient().displayStacks().stream().map(abstractedFluidStack -> this.fluidHelper.create((class_6880)abstractedFluidStack.fluid().method_40178(), recipe.getFluidIngredient().get().loaderAmount(), abstractedFluidStack.componentPatch())).toList());
            }
            IRecipeSlotBuilder itemSlot = builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 5, 5);
            for (AbstractedFluidStack stack : recipe.getFluidIngredient().get().ingredient().displayStacks()) {
                class_1799 itemDisplay = BnCFluidItemDisplays.getFluidItemDisplay((class_7225.class_7874)class_310.method_1551().field_1687.method_30349(), stack).method_7972();
                Optional<KegPouringRecipe> pouringRecipe = class_310.method_1551().field_1687.method_8433().method_30027(BnCRecipeTypes.KEG_POURING).stream().map(class_8786::comp_1933).sorted(Comparator.comparing(KegPouringRecipe::isStrict)).filter(kegPouringRecipe -> {
                    if (kegPouringRecipe.isStrict()) {
                        return class_1799.method_31577((class_1799)itemDisplay, (class_1799)kegPouringRecipe.method_8110((class_7225.class_7874)class_310.method_1551().field_1687.method_30349()));
                    }
                    return class_1799.method_7984((class_1799)itemDisplay, (class_1799)kegPouringRecipe.method_8110((class_7225.class_7874)class_310.method_1551().field_1687.method_30349()));
                }).findFirst();
                int pourCount = pouringRecipe.map(kegPouringRecipe -> (int)(Math.min(((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).keg().localizedCapacity(), recipe.getFluidIngredient().get().loaderAmount()) / kegPouringRecipe.getLoaderAmount())).orElse(1);
                itemDisplay.method_7939(pourCount);
                if (itemDisplay.method_7960()) continue;
                itemSlot.addItemStack(itemDisplay);
            }
        }
        class_2371<class_1856> recipeIngredients = recipe.method_8117();
        int borderSlotSize = 18;
        for (int row = 0; row < 2; ++row) {
            for (int column = 0; column < 2; ++column) {
                int inputIndex = row * 2 + column;
                if (inputIndex >= recipeIngredients.size()) continue;
                builder.addSlot(RecipeIngredientRole.INPUT, column * borderSlotSize + 29, row * borderSlotSize + 1).addItemStacks(Arrays.asList(((class_1856)recipeIngredients.get(inputIndex)).method_8105()));
            }
        }
        if (recipe.getResult().left().isPresent()) {
            AbstractedFluidStack result = (AbstractedFluidStack)recipe.getResult().left().get();
            if (((BnCConfiguration.Client)BnCConfiguration.CLIENT_CONFIG.get()).renderFluidInKeg()) {
                class_9326 class_93262;
                IRecipeSlotBuilder iRecipeSlotBuilder = builder.addSlot(RecipeIngredientRole.OUTPUT, 100, 2);
                class_3611 class_36112 = result.fluid();
                long l = recipe.getUnit().convertToLoader(result.amount());
                class_9323 pourCount = result.components();
                if (pourCount instanceof class_9335) {
                    class_9335 patched = (class_9335)pourCount;
                    class_93262 = patched.method_57940();
                } else {
                    class_93262 = class_9326.field_49588;
                }
                iRecipeSlotBuilder.addFluidStack(class_36112, l, class_93262).setFluidRenderer(((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).keg().localizedCapacity(), false, 26, 30).setOverlay(this.kegOverlay, 0, 0);
            } else {
                class_9326 class_93263;
                IIngredientAcceptor iIngredientAcceptor = builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT);
                class_3611 class_36113 = result.fluid();
                long l = recipe.getUnit().convertToLoader(result.amount());
                class_9323 patched = result.components();
                if (patched instanceof class_9335) {
                    class_9335 patched2 = (class_9335)patched;
                    class_93263 = patched2.method_57940();
                } else {
                    class_93263 = class_9326.field_49588;
                }
                iIngredientAcceptor.addFluidStack(class_36113, l, class_93263);
            }
            class_1799 itemDisplay = BnCFluidItemDisplays.getFluidItemDisplay((class_7225.class_7874)class_310.method_1551().field_1687.method_30349(), result).method_7972();
            Optional<KegPouringRecipe> pouringRecipe = class_310.method_1551().field_1687.method_8433().method_30027(BnCRecipeTypes.KEG_POURING).stream().map(class_8786::comp_1933).sorted(Comparator.comparing(KegPouringRecipe::isStrict)).filter(kegPouringRecipe -> {
                if (kegPouringRecipe.isStrict()) {
                    return class_1799.method_31577((class_1799)itemDisplay, (class_1799)kegPouringRecipe.method_8110((class_7225.class_7874)class_310.method_1551().field_1687.method_30349()));
                }
                return class_1799.method_7984((class_1799)itemDisplay, (class_1799)kegPouringRecipe.method_8110((class_7225.class_7874)class_310.method_1551().field_1687.method_30349()));
            }).findFirst();
            int pourCount = pouringRecipe.map(kegPouringRecipe -> (int)(Math.min(((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).keg().localizedCapacity(), recipe.getFluidIngredient().get().loaderAmount()) / kegPouringRecipe.getLoaderAmount())).orElse(1);
            itemDisplay.method_7939(pourCount);
            if (!itemDisplay.method_7960()) {
                builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 105, 5).addItemStack(itemDisplay);
            }
        }
        if (recipe.getCatalyst() != null) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 73, 39).addItemStack(recipe.getCatalyst());
        }
        if (recipe.getOutput() != null) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 105, 39).addItemStack(recipe.getOutput());
        }
        builder.moveRecipeTransferButton(132, 43);
    }

    public void draw(KegFermentingPouringRecipe recipe, IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 67, 10);
        this.leftBubble.draw(guiGraphics, 90, 3);
        this.rightBubble.draw(guiGraphics, 127, 3);
        if (recipe.getTemperature() <= 2) {
            this.chilly.draw(guiGraphics, 33, 39);
        }
        if (recipe.getTemperature() <= 1) {
            this.cold.draw(guiGraphics, 25, 39);
        }
        if (recipe.getTemperature() >= 4) {
            this.warm.draw(guiGraphics, 50, 39);
        }
        if (recipe.getTemperature() >= 5) {
            this.hot.draw(guiGraphics, 59, 39);
        }
        this.timeIcon.draw(guiGraphics, 70, 2);
        if (recipe.getExperience() > 0.0f) {
            this.expIcon.draw(guiGraphics, 69, 21);
        }
    }

    public void getTooltip(ITooltipBuilder tooltip, KegFermentingPouringRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (ClientRenderUtils.isCursorInsideBounds((int)67, (int)2, (int)22, (int)28, (double)mouseX, (double)mouseY)) {
            float experience;
            int cookTime = recipe.getFermentTime();
            if (cookTime > 0) {
                if (cookTime >= 1200) {
                    tooltip.add((class_5348)class_2561.method_43469((String)"gui.jei.category.smelting.time.minutes", (Object[])new Object[]{cookTime / 1200}));
                } else {
                    tooltip.add((class_5348)class_2561.method_43469((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTime / 20}));
                }
            }
            if ((experience = recipe.getExperience()) > 0.0f) {
                tooltip.add((class_5348)class_2561.method_43469((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)}));
            }
        } else if (ClientRenderUtils.isCursorInsideBounds((int)24, (int)38, (int)44, (int)5, (double)mouseX, (double)mouseY)) {
            class_5250 key;
            switch (recipe.getTemperature()) {
                case 1: {
                    class_5250 class_52502 = BnCTextUtils.getTranslation("container.keg.cold", new Object[0]);
                    break;
                }
                case 2: {
                    class_5250 class_52502 = BnCTextUtils.getTranslation("container.keg.chilly", new Object[0]);
                    break;
                }
                case 3: {
                    class_5250 class_52502 = BnCTextUtils.getTranslation("container.keg.normal", new Object[0]);
                    break;
                }
                case 4: {
                    class_5250 class_52502 = BnCTextUtils.getTranslation("container.keg.warm", new Object[0]);
                    break;
                }
                case 5: {
                    class_5250 class_52502 = BnCTextUtils.getTranslation("container.keg.hot", new Object[0]);
                    break;
                }
                default: {
                    class_5250 class_52502 = key = null;
                }
            }
            if (key != null) {
                tooltip.add((class_5348)key);
            }
        } else if (ClientRenderUtils.isCursorInsideBounds((int)92, (int)39, (int)10, (int)16, (double)mouseX, (double)mouseY) && recipe.getCatalyst() != null) {
            tooltip.add((class_5348)class_2561.method_43470((String)String.valueOf(recipe.getPouringAmount())).method_27693(class_1074.method_4662((String)"generic.unit.millibuckets", (Object[])new Object[0])));
        }
    }
}

