/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.integration.emi.widget;

import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9335;
import umpaz.brewinandchewin.client.BrewinAndChewinClient;
import umpaz.brewinandchewin.client.utility.BnCFluidItemDisplays;
import umpaz.brewinandchewin.common.BnCConfiguration;
import umpaz.brewinandchewin.common.crafting.KegPouringRecipe;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;
import umpaz.brewinandchewin.common.utility.FluidUnit;
import umpaz.brewinandchewin.integration.emi.recipe.FermentingEmiRecipe;

public class BnCFluidWidget
extends SlotWidget {
    private final Function<Random, EmiStack> fluidGenerator = random -> {
        List stacks = fluid.getEmiStacks();
        return (EmiStack)stacks.get(random.nextInt(stacks.size()));
    };
    private final int unique;
    private long lastFluidGenerate = 0L;
    private EmiIngredient fluidIngredient = null;
    private boolean invalidateItemStack = false;
    private EmiIngredient itemIngredient = null;

    public BnCFluidWidget(EmiIngredient fluid, int unique, int x, int y) {
        super((EmiIngredient)EmiStack.EMPTY, x, y);
        this.unique = unique;
        this.custom = true;
        this.customWidth = 28;
        this.customHeight = 32;
        this.output = true;
    }

    public void drawBackground(class_332 draw, int mouseX, int mouseY, float delta) {
        Bounds bounds = this.getBounds();
        AbstractedFluidStack fluidStack = new AbstractedFluidStack((class_3611)((EmiStack)this.getStack().getEmiStacks().getFirst()).getKey(), ((EmiStack)this.getStack().getEmiStacks().getFirst()).getAmount(), (class_9323)class_9335.method_57935((class_9323)class_9323.field_49584, (class_9326)((EmiStack)this.getStack().getEmiStacks().getFirst()).getComponentChanges()), FluidUnit.getLoaderUnit());
        if (((BnCConfiguration.Client)BnCConfiguration.CLIENT_CONFIG.get()).renderFluidInKeg()) {
            BrewinAndChewinClient.getHelper().renderFluidInKeg(fluidStack, draw, bounds.x() + 2, bounds.y() + 2, 1.0f);
        }
    }

    public void drawStack(class_332 draw, int mouseX, int mouseY, float delta) {
        Bounds bounds = this.getBounds();
        int xOff = (bounds.width() - 16) / 2;
        int yOff = (bounds.height() - 16) / 2 - 4;
        this.getItemStack().render(draw, bounds.x() + xOff, bounds.y() + yOff, delta);
    }

    public void drawOverlay(class_332 draw, int mouseX, int mouseY, float delta) {
        Bounds bounds = this.getBounds();
        draw.method_25302(FermentingEmiRecipe.BACKGROUND, bounds.x() + 1, bounds.y() + 1, 170, 45, bounds.width(), bounds.height() - 2);
        super.drawOverlay(draw, mouseX, mouseY, delta);
    }

    public EmiIngredient getStack() {
        long time = System.currentTimeMillis() / 1000L;
        if (this.fluidIngredient == null || time > this.lastFluidGenerate) {
            this.lastFluidGenerate = time;
            this.fluidIngredient = (EmiIngredient)this.fluidGenerator.apply(this.getRandom(time));
            this.invalidateItemStack = true;
        }
        return this.fluidIngredient;
    }

    public EmiIngredient getItemStack() {
        if (this.invalidateItemStack) {
            AbstractedFluidStack fluidStack = new AbstractedFluidStack((class_3611)((EmiStack)this.getStack().getEmiStacks().getFirst()).getKey(), ((EmiStack)this.getStack().getEmiStacks().getFirst()).getAmount(), (class_9323)class_9335.method_57935((class_9323)class_9323.field_49584, (class_9326)((EmiStack)this.getStack().getEmiStacks().getFirst()).getComponentChanges()), FluidUnit.getLoaderUnit());
            class_1799 itemDisplay = BnCFluidItemDisplays.getFluidItemDisplay((class_7225.class_7874)class_310.method_1551().field_1687.method_30349(), fluidStack).method_7972();
            Optional<KegPouringRecipe> pouringRecipe = class_310.method_1551().field_1687.method_8433().method_30027(BnCRecipeTypes.KEG_POURING).stream().map(class_8786::comp_1933).sorted(Comparator.comparing(KegPouringRecipe::isStrict)).filter(kegPouringRecipe -> {
                if (kegPouringRecipe.isStrict()) {
                    return class_1799.method_31577((class_1799)itemDisplay, (class_1799)kegPouringRecipe.method_8110((class_7225.class_7874)class_310.method_1551().field_1687.method_30349()));
                }
                return class_1799.method_7984((class_1799)itemDisplay, (class_1799)kegPouringRecipe.method_8110((class_7225.class_7874)class_310.method_1551().field_1687.method_30349()));
            }).findFirst();
            int pourCount = pouringRecipe.map(kegPouringRecipe -> (int)(Math.min(FluidUnit.convert(((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).keg().capacity(), ((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).keg().capacityUnit(), FluidUnit.getLoaderUnit()), fluidStack.amount()) / kegPouringRecipe.getLoaderAmount())).orElse(1);
            itemDisplay.method_7939(pourCount);
            this.itemIngredient = EmiStack.of((class_1799)itemDisplay);
            this.invalidateItemStack = false;
        }
        return this.itemIngredient;
    }

    private Random getRandom(long time) {
        return new Random(new Random(time ^ (long)this.unique).nextInt());
    }
}

