/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.registry.BnCItems;
import umpaz.brewinandchewin.common.registry.BnCRecipeSerializers;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;
import umpaz.brewinandchewin.common.utility.FluidUnit;
import umpaz.brewinandchewin.common.utility.KegRecipeWrapper;

public class KegPouringRecipe
implements class_1860<KegRecipeWrapper> {
    private final AbstractedFluidStack fluid;
    private final Optional<class_1799> container;
    private final class_1799 output;
    private final Optional<FluidUnit> unit;
    private final boolean strict;
    private final boolean filling;

    public KegPouringRecipe(AbstractedFluidStack fluid, Optional<class_1799> container, class_1799 output, Optional<FluidUnit> unit, boolean strict, boolean filling) {
        if (container.isEmpty() && BrewinAndChewin.getHelper().getCraftingRemainingItem(output).method_7960()) {
            throw new UnsupportedOperationException("'container' field must be specified as the output item stack doesn't have a crafting remainder item.");
        }
        this.fluid = fluid;
        this.container = container;
        this.output = output;
        this.unit = unit;
        this.strict = strict;
        this.filling = filling;
    }

    public class_2371<class_1856> method_8117() {
        class_2371 ingredient = class_2371.method_10211();
        ingredient.add((Object)class_1856.method_8101((class_1799[])new class_1799[]{this.getContainer()}));
        return ingredient;
    }

    public boolean matches(KegRecipeWrapper inv, class_1937 level) {
        return class_1856.method_8101((class_1799[])new class_1799[]{this.getContainer()}).method_8093(inv.method_59984(4));
    }

    public class_1799 assemble(KegRecipeWrapper recipeWrapper, class_7225.class_7874 provider) {
        return this.output.method_7972();
    }

    public boolean method_8113(int pWidth, int pHeight) {
        return true;
    }

    public class_1799 getContainer() {
        return this.container.orElse(BrewinAndChewin.getHelper().getCraftingRemainingItem(this.output));
    }

    public class_1799 getContainer(class_1799 stack) {
        return this.container.orElse(BrewinAndChewin.getHelper().getCraftingRemainingItem(stack));
    }

    public Optional<FluidUnit> getRawUnit() {
        return this.unit;
    }

    public FluidUnit getUnit() {
        return this.unit.orElse(FluidUnit.getLoaderUnit());
    }

    public long getLoaderAmount() {
        return this.getUnit().convertToLoader(this.fluid.amount());
    }

    public Optional<class_1799> getRawContainer() {
        return this.container;
    }

    public class_1799 getOutput() {
        return this.output;
    }

    public class_1799 method_8110(class_7225.class_7874 provider) {
        return this.output;
    }

    public AbstractedFluidStack getFluid(class_1799 container) {
        return this.fluid;
    }

    public AbstractedFluidStack getRawFluid() {
        return this.fluid;
    }

    public boolean hasSpecialFluid() {
        return false;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean canFill() {
        return this.filling;
    }

    public class_1865<?> method_8119() {
        return BnCRecipeSerializers.KEG_POURING;
    }

    public class_3956<?> method_17716() {
        return BnCRecipeTypes.KEG_POURING;
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)BnCItems.KEG);
    }

    public boolean method_8118() {
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.fluid, this.container, this.output, this.strict, this.filling);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KegPouringRecipe that = (KegPouringRecipe)o;
        if (!this.output.equals(that.output)) {
            return false;
        }
        if (!this.fluid.equals(that.fluid)) {
            return false;
        }
        if (!this.container.equals(that.container)) {
            return false;
        }
        if (this.strict != that.strict) {
            return false;
        }
        return this.filling == that.filling;
    }

    public static class Serializer
    implements class_1865<KegPouringRecipe> {
        public static final MapCodec<KegPouringRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)AbstractedFluidStack.CODEC.fieldOf("fluid").forGetter(KegPouringRecipe::getRawFluid), (App)class_1799.field_24671.optionalFieldOf("container").forGetter(KegPouringRecipe::getRawContainer), (App)class_1799.field_24671.fieldOf("output").forGetter(KegPouringRecipe::getOutput), (App)FluidUnit.CODEC.optionalFieldOf("unit").forGetter(KegPouringRecipe::getRawUnit), (App)Codec.BOOL.optionalFieldOf("strict", (Object)false).forGetter(KegPouringRecipe::isStrict), (App)Codec.BOOL.optionalFieldOf("can_fill", (Object)true).forGetter(KegPouringRecipe::canFill)).apply((Applicative)inst, KegPouringRecipe::new));
        public static final class_9139<class_9129, KegPouringRecipe> STREAM_CODEC = class_9139.method_56437(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<KegPouringRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, KegPouringRecipe> method_56104() {
            return STREAM_CODEC;
        }

        public static void toNetwork(class_9129 buf, KegPouringRecipe recipe) {
            AbstractedFluidStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.getRawFluid());
            class_9135.method_56382((class_9139)class_1799.field_48349).encode((Object)buf, recipe.getRawContainer());
            class_1799.field_48349.encode((Object)buf, (Object)recipe.getOutput());
            class_9135.method_56382(FluidUnit.STREAM_CODEC).encode((Object)buf, recipe.getRawUnit());
            class_9135.field_48547.encode((Object)buf, (Object)recipe.isStrict());
            class_9135.field_48547.encode((Object)buf, (Object)recipe.canFill());
        }

        public static KegPouringRecipe fromNetwork(class_9129 buf) {
            AbstractedFluidStack fluid = (AbstractedFluidStack)AbstractedFluidStack.STREAM_CODEC.decode((Object)buf);
            Optional container = (Optional)class_9135.method_56382((class_9139)class_1799.field_48349).decode((Object)buf);
            class_1799 output = (class_1799)class_1799.field_48349.decode((Object)buf);
            Optional unit = (Optional)class_9135.method_56382(FluidUnit.STREAM_CODEC).decode((Object)buf);
            boolean strict = buf.readBoolean();
            boolean canFill = buf.readBoolean();
            return new KegPouringRecipe(fluid, container, output, unit, strict, canFill);
        }
    }
}

