/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedDouble;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_9331;
import net.sweenus.simplyswords.client.util.TooltipUtils;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.item.TwoHandedWeapon;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.item.component.StoredChargeComponent;
import net.sweenus.simplyswords.item.component.TargetedLocationComponent;
import net.sweenus.simplyswords.registry.ComponentTypeRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.AbilityMethods;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class LichbladeSwordItem
extends UniqueSwordItem
implements TwoHandedWeapon {
    class_1309 abilityTarget;

    public LichbladeSwordItem(class_1832 toolMaterial, class_1792.class_1793 settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        HelperMethods.playHitSounds(attacker, target);
        return super.method_7873(stack, target, attacker);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (hand == class_1268.field_5810) {
            return class_1271.method_22431((Object)itemStack);
        }
        if (itemStack.method_7919() >= itemStack.method_7936() - 1) {
            return class_1271.method_22431((Object)itemStack);
        }
        if (itemStack.method_31574((class_1792)ItemsRegistry.SLUMBERING_LICHBLADE.get())) {
            return class_1271.method_22430((Object)itemStack);
        }
        class_1309 abilityTarget = (class_1309)HelperMethods.getTargetedEntity((class_1297)user, Config.uniqueEffects.lichblade.range);
        if (abilityTarget != null) {
            abilityTarget.method_37222(new class_1293(class_1294.field_5912, 10, 0), (class_1297)user);
            world.method_43129(null, (class_1297)user, (class_3414)SoundRegistry.DARK_SWORD_ENCHANT.get(), user.method_5634(), 0.5f, 0.5f);
            itemStack.method_57379((class_9331)ComponentTypeRegistry.TARGETED_LOCATION.get(), (Object)new TargetedLocationComponent(abilityTarget.method_5667(), user.method_23317(), user.method_23318(), user.method_23321()));
        }
        user.method_6019(hand);
        return class_1271.method_22428((Object)itemStack);
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (world.field_9236) {
            return;
        }
        TargetedLocationComponent targetLocation = (TargetedLocationComponent)stack.method_57825((class_9331)ComponentTypeRegistry.TARGETED_LOCATION.get(), (Object)TargetedLocationComponent.DEFAULT);
        class_1309 abilityTarget = targetLocation.getEntity((class_3218)world);
        if (user.method_6118(class_1304.field_6173) == stack && abilityTarget != null) {
            int maxDuration = Config.uniqueEffects.lichblade.duration;
            int radius = Config.uniqueEffects.lichblade.radius;
            if (stack.method_31574((class_1792)ItemsRegistry.AWAKENED_LICHBLADE.get())) {
                if (abilityTarget.method_29504() || abilityTarget == user || remainingUseTicks < maxDuration) {
                    stack.method_57379((class_9331)ComponentTypeRegistry.TARGETED_LOCATION.get(), (Object)targetLocation.setTarget((class_1297)user));
                    abilityTarget = user;
                    if (user.method_5649(targetLocation.lastX(), targetLocation.lastY(), targetLocation.lastZ()) < (double)radius) {
                        int damageTracker = ((StoredChargeComponent)stack.method_57825((class_9331)ComponentTypeRegistry.STORED_CHARGE.get(), (Object)StoredChargeComponent.DEFAULT)).charge();
                        user.method_6073(Math.min(Config.uniqueEffects.abilityAbsorptionCap, user.method_6067() + Math.min((float)damageTracker / 2.0f, (float)Config.uniqueEffects.lichblade.absorptionCap)));
                        user.method_6075();
                        world.method_43129(null, (class_1297)user, (class_3414)SoundRegistry.DARK_SWORD_SPELL.get(), user.method_5634(), 0.04f, 0.5f);
                    }
                }
            } else if (stack.method_31574((class_1792)ItemsRegistry.WAKING_LICHBLADE.get()) && (abilityTarget.method_29504() || remainingUseTicks < maxDuration)) {
                user.method_6075();
            }
            double lastX = targetLocation.lastX();
            double lastY = targetLocation.lastY();
            double lastZ = targetLocation.lastZ();
            if (user.field_6012 % 5 == 0) {
                double targetX = abilityTarget.method_23317();
                double targetY = abilityTarget.method_23318();
                double targetZ = abilityTarget.method_23321();
                if (targetX > lastX) {
                    lastX += 1.0;
                }
                if (targetX < lastX) {
                    lastX -= 1.0;
                }
                if (targetZ > lastZ) {
                    lastZ += 1.0;
                }
                if (targetZ < lastZ) {
                    lastZ -= 1.0;
                }
                if (targetY > lastY) {
                    lastY += 1.0;
                }
                if (targetY < lastY) {
                    lastY -= 1.0;
                }
            }
            stack.method_57379((class_9331)ComponentTypeRegistry.TARGETED_LOCATION.get(), (Object)new TargetedLocationComponent(abilityTarget.method_5667(), lastX, lastY, lastZ));
            float abilityDamage = HelperMethods.spellScaledDamage("soul", (class_1297)user, Config.uniqueEffects.lichblade.spellScaling, Config.uniqueEffects.lichblade.damage);
            float healAmount = Config.uniqueEffects.lichblade.heal;
            AbilityMethods.tickAbilitySoulAnguish(stack, world, user, abilityDamage, radius, lastX, lastY, lastZ, healAmount, abilityTarget);
        }
    }

    @Override
    public int method_7881(class_1799 stack, class_1309 user) {
        return Config.uniqueEffects.lichblade.duration * 2;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8947;
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        TargetedLocationComponent targetLocation = (TargetedLocationComponent)stack.method_57824((class_9331)ComponentTypeRegistry.TARGETED_LOCATION.get());
        if (!world.field_9236 && user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            if (targetLocation != null && ((class_3218)world).method_14190(targetLocation.uuid()) != null) {
                player.method_7357().method_7906(stack.method_7909(), Config.uniqueEffects.lichblade.cooldown);
            }
        }
        stack.method_57379((class_9331)ComponentTypeRegistry.STORED_CHARGE.get(), null);
        stack.method_57379((class_9331)ComponentTypeRegistry.TARGETED_LOCATION.get(), null);
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 user, int slot, boolean selected) {
        if (!user.method_37908().method_8608() && user instanceof class_1309) {
            class_1309 livingUser = (class_1309)user;
            if (livingUser.field_6012 % 35 == 0 && livingUser.method_6118(class_1304.field_6173) == stack && !livingUser.method_6115()) {
                float abilityDamage = HelperMethods.spellScaledDamage("soul", user, Config.uniqueEffects.lichblade.spellScaling, Config.uniqueEffects.lichblade.damage);
                int radius = Config.uniqueEffects.lichblade.radius;
                class_238 box = new class_238(livingUser.method_23317() + (double)radius, livingUser.method_23318() + (double)radius, livingUser.method_23321() + (double)radius, livingUser.method_23317() - (double)radius, livingUser.method_23318() - (double)radius, livingUser.method_23321() - (double)radius);
                for (class_1297 entity : world.method_8333((class_1297)livingUser, box, class_1301.field_6157)) {
                    if (!(entity instanceof class_1309)) continue;
                    class_1309 le = (class_1309)entity;
                    if (!HelperMethods.checkFriendlyFire((class_1309)entity, livingUser)) continue;
                    le.method_5643(livingUser.method_48923().method_48815(user, user), abilityDamage);
                }
                world.method_43129(null, (class_1297)livingUser, (class_3414)SoundRegistry.DARK_SWORD_BLOCK.get(), livingUser.method_5634(), 0.1f, 0.2f);
                double xPos = livingUser.method_23317() - (double)(radius + 1);
                double yPos = livingUser.method_23318();
                double zPos = livingUser.method_23321() - (double)(radius + 1);
                for (int i = radius * 2; i > 0; --i) {
                    for (int j = radius * 2; j > 0; --j) {
                        float choose = (float)(Math.random() * 1.0);
                        HelperMethods.spawnParticle(world, (class_2394)class_2398.field_38002, xPos + (double)i + (double)choose, yPos, zPos + (double)j + (double)choose, 0.0, 0.1, 0.0);
                        HelperMethods.spawnParticle(world, (class_2394)class_2398.field_23114, xPos + (double)i + (double)choose, yPos + 0.1, zPos + (double)j + (double)choose, 0.0, 0.0, 0.0);
                        HelperMethods.spawnParticle(world, (class_2394)class_2398.field_11219, xPos + (double)i + (double)choose, yPos + 2.0, zPos + (double)j + (double)choose, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
        HelperMethods.createFootfalls(user, stack, world, (class_2394)class_2398.field_23114, (class_2394)class_2398.field_23114, (class_2394)class_2398.field_11219, true);
        super.method_7888(stack, world, user, slot, selected);
    }

    @Override
    public void method_7851(class_1799 itemStack, class_1792.class_9635 tooltipContext, List<class_2561> tooltip, class_1836 type) {
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        if (itemStack.method_31574((class_1792)ItemsRegistry.SLUMBERING_LICHBLADE.get())) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.lichbladesworditem.tooltip1").method_10862(Styles.ABILITY));
        } else if (itemStack.method_31574((class_1792)ItemsRegistry.WAKING_LICHBLADE.get())) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.lichbladesworditem.tooltip1.2").method_10862(Styles.ABILITY));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.lichbladesworditem.tooltip1.3").method_10862(Styles.ABILITY));
        }
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.lichbladesworditem.tooltip2").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.lichbladesworditem.tooltip3").method_10862(Styles.TEXT));
        if (!itemStack.method_31574((class_1792)ItemsRegistry.SLUMBERING_LICHBLADE.get())) {
            tooltip.add((class_2561)class_2561.method_43470((String)""));
            tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.onrightclickheld").method_10862(Styles.RIGHT_CLICK));
            tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.lichbladesworditem.tooltip4").method_10862(Styles.TEXT));
            tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.lichbladesworditem.tooltip5").method_10862(Styles.TEXT));
            tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.lichbladesworditem.tooltip6").method_10862(Styles.TEXT));
            if (itemStack.method_31574((class_1792)ItemsRegistry.AWAKENED_LICHBLADE.get())) {
                tooltip.add((class_2561)class_2561.method_43470((String)""));
                tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.lichbladesworditem.tooltip7").method_10862(Styles.TEXT));
                tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.lichbladesworditem.tooltip8").method_10862(Styles.TEXT));
                tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.lichbladesworditem.tooltip9").method_10862(Styles.TEXT));
            }
        }
        super.method_7851(itemStack, tooltipContext, tooltip, type);
        TooltipUtils.appendSpellScaleTooltip(tooltip, "soul");
    }

    @Override
    protected class_2960 getConfigPath() {
        return class_2960.method_60654((String)"simplyswords.unique_effects.lichblade");
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0)
        public int absorptionCap;
        @ValidatedInt.Restrict(min=0)
        public int cooldown;
        @ValidatedFloat.Restrict(min=0.0f)
        public float damage;
        @ValidatedInt.Restrict(min=0)
        public int duration;
        @ValidatedFloat.Restrict(min=0.0f)
        public float heal;
        @ValidatedInt.Restrict(min=1)
        public int radius;
        @ValidatedDouble.Restrict(min=1.0)
        public double range;
        @ValidatedFloat.Restrict(min=0.0f)
        public float spellScaling;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = () -> ItemsRegistry.SLUMBERING_LICHBLADE.get();
            supplierArray[1] = () -> ItemsRegistry.WAKING_LICHBLADE.get();
            supplierArray[2] = () -> ItemsRegistry.AWAKENED_LICHBLADE.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.absorptionCap = 8;
            this.cooldown = 700;
            this.damage = 6.0f;
            this.duration = 200;
            this.heal = 0.5f;
            this.radius = 3;
            this.range = 22.0;
            this.spellScaling = 1.6f;
        }
    }
}

