/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_9331;
import net.sweenus.simplyswords.client.util.TooltipUtils;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.item.TwoHandedWeapon;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.item.component.StoredChargeComponent;
import net.sweenus.simplyswords.registry.ComponentTypeRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.AbilityMethods;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class HearthflameSwordItem
extends UniqueSwordItem
implements TwoHandedWeapon {
    int ability_timer_max = 120;

    public HearthflameSwordItem(class_1832 toolMaterial, class_1792.class_1793 settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (!attacker.method_37908().method_8608()) {
            class_3218 world = (class_3218)attacker.method_37908();
            HelperMethods.playHitSounds(attacker, target);
            if (attacker.method_59922().method_43048(100) <= Config.uniqueEffects.hearthflame.chance) {
                target.method_37222(new class_1293(class_1294.field_5902, 10, 1), (class_1297)attacker);
                target.method_18800(target.method_23317() - attacker.method_23317(), 0.5, target.method_23321() - attacker.method_23321());
                target.method_5639(5.0f);
                int choose_sound = (int)(Math.random() * 30.0);
                if (choose_sound <= 10) {
                    world.method_43129(null, (class_1297)target, (class_3414)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_01.get(), target.method_5634(), 0.5f, 1.2f);
                }
                if (choose_sound <= 20 && choose_sound > 10) {
                    world.method_43129(null, (class_1297)target, (class_3414)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_02.get(), target.method_5634(), 0.5f, 1.2f);
                }
                if (choose_sound <= 30 && choose_sound > 20) {
                    world.method_43129(null, (class_1297)target, (class_3414)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_03.get(), target.method_5634(), 0.5f, 1.2f);
                }
            }
        }
        return super.method_7873(stack, target, attacker);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        user.method_37222(new class_1293(class_1294.field_5909, 20, 5), (class_1297)user);
        user.method_37222(new class_1293(class_1294.field_5901, 20, 8), (class_1297)user);
        user.method_37222(new class_1293(class_1294.field_5907, 20, 5), (class_1297)user);
        class_1799 itemStack = user.method_5998(hand);
        if (itemStack.method_7919() >= itemStack.method_7936() - 1) {
            return class_1271.method_22431((Object)itemStack);
        }
        user.method_6019(hand);
        return class_1271.method_22428((Object)itemStack);
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (HelperMethods.isHolding(stack, user) && user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            int radius = Config.uniqueEffects.hearthflame.radius;
            float spellScaling = HelperMethods.commonSpellAttributeScaling(Config.uniqueEffects.hearthflame.spellScaling, (class_1297)user, "fire");
            float abilityDamage = spellScaling > 0.0f ? spellScaling : Config.uniqueEffects.hearthflame.damage;
            int chargePower = ((StoredChargeComponent)stack.method_57825((class_9331)ComponentTypeRegistry.STORED_CHARGE.get(), (Object)StoredChargeComponent.DEFAULT)).charge();
            AbilityMethods.tickAbilityVolcanicFury(stack, world, user, remainingUseTicks, this.ability_timer_max, abilityDamage, Config.uniqueEffects.hearthflame.cooldown, radius, chargePower);
            if (player.field_6012 % 20 == 0) {
                stack.method_57368((class_9331)ComponentTypeRegistry.STORED_CHARGE.get(), (Object)StoredChargeComponent.DEFAULT, comp -> comp.add(2));
            }
        }
    }

    @Override
    public int method_7881(class_1799 stack, class_1309 user) {
        return this.ability_timer_max;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8947;
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (!world.field_9236) {
            int choose_sound;
            if (user instanceof class_1657) {
                class_1657 player = (class_1657)user;
                player.method_7357().method_7906((class_1792)this, Config.uniqueEffects.hearthflame.chance);
            }
            if ((choose_sound = (int)(Math.random() * 30.0)) <= 10) {
                world.method_43129(null, (class_1297)user, (class_3414)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_01.get(), user.method_5634(), 0.6f, 1.2f);
            } else if (choose_sound <= 20) {
                world.method_43129(null, (class_1297)user, (class_3414)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_02.get(), user.method_5634(), 0.6f, 1.2f);
            } else if (choose_sound <= 30) {
                world.method_43129(null, (class_1297)user, (class_3414)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_03.get(), user.method_5634(), 0.6f, 1.2f);
            }
            int radius = Config.uniqueEffects.hearthflame.radius;
            class_238 box = new class_238(user.method_23317() + (double)radius, user.method_23318() + (double)radius, user.method_23321() + (double)radius, user.method_23317() - (double)radius, user.method_23318() - (double)radius, user.method_23321() - (double)radius);
            for (class_1297 entity : world.method_8333((class_1297)user, box, class_1301.field_6157)) {
                if (!(entity instanceof class_1309)) continue;
                class_1309 le = (class_1309)entity;
                if (!HelperMethods.checkFriendlyFire((class_1309)entity, user)) continue;
                float choose = (float)(Math.random() * 1.0);
                float spellScaling = HelperMethods.commonSpellAttributeScaling(Config.uniqueEffects.hearthflame.spellScaling, (class_1297)user, "fire");
                float abilityDamage = spellScaling > 0.0f ? spellScaling : Config.uniqueEffects.hearthflame.damage;
                int chargePower = ((StoredChargeComponent)stack.method_57825((class_9331)ComponentTypeRegistry.STORED_CHARGE.get(), (Object)StoredChargeComponent.DEFAULT)).charge();
                le.method_5643(user.method_48923().method_48815((class_1297)user, (class_1297)user), abilityDamage * ((float)chargePower * 0.3f));
                le.method_5639(6.0f);
                world.method_43129(null, (class_1297)le, (class_3414)SoundRegistry.ELEMENTAL_BOW_POISON_ATTACK_01.get(), le.method_5634(), 0.1f, choose);
                stack.method_57379((class_9331)ComponentTypeRegistry.STORED_CHARGE.get(), (Object)StoredChargeComponent.DEFAULT);
                le.method_37222(new class_1293(class_1294.field_5902, 10, 1), (class_1297)user);
                le.method_18800(le.method_23317() - user.method_23317(), 0.5, le.method_23321() - user.method_23321());
            }
        }
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        HelperMethods.createFootfalls(entity, stack, world, (class_2394)class_2398.field_11219, (class_2394)class_2398.field_11219, (class_2394)class_2398.field_11219, true);
        super.method_7888(stack, world, entity, slot, selected);
    }

    @Override
    public void method_7851(class_1799 itemStack, class_1792.class_9635 tooltipContext, List<class_2561> tooltip, class_1836 type) {
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.volcanicfurysworditem.tooltip1").method_10862(Styles.ABILITY));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.volcanicfurysworditem.tooltip2").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.volcanicfurysworditem.tooltip3").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.onrightclickheld").method_10862(Styles.RIGHT_CLICK));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.volcanicfurysworditem.tooltip4").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.volcanicfurysworditem.tooltip5").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.volcanicfurysworditem.tooltip6").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.volcanicfurysworditem.tooltip7").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.volcanicfurysworditem.tooltip8").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.volcanicfurysworditem.tooltip9").method_10862(Styles.TEXT));
        super.method_7851(itemStack, tooltipContext, tooltip, type);
        TooltipUtils.appendSpellScaleTooltip(tooltip, "fire");
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0, max=100)
        public int chance;
        @ValidatedInt.Restrict(min=0)
        public int cooldown;
        @ValidatedFloat.Restrict(min=0.0f)
        public float damage;
        @ValidatedInt.Restrict(min=1)
        public int radius;
        @ValidatedFloat.Restrict(min=0.0f)
        public float spellScaling;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ItemsRegistry.HEARTHFLAME.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.chance = 25;
            this.cooldown = 300;
            this.damage = 3.0f;
            this.radius = 3;
            this.spellScaling = 1.4f;
        }
    }
}

