/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.sweenus.simplyswords.client.util.TooltipUtils;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.effect.instance.SimplySwordsStatusEffectInstance;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class FlamewindSwordItem
extends UniqueSwordItem {
    public FlamewindSwordItem(class_1832 toolMaterial, class_1792.class_1793 settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (!attacker.method_37908().method_8608()) {
            class_3218 serverWorld = (class_3218)attacker.method_37908();
            HelperMethods.playHitSounds(attacker, target);
        }
        return super.method_7873(stack, target, attacker);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (!user.method_37908().method_8608() && world instanceof class_3218) {
            class_1309 ee;
            class_3218 serverWorld = (class_3218)world;
            int flameSeedDuration = 101;
            int flameSeedSpreadCap = Config.uniqueEffects.flamewind.spreadCap;
            int skillCooldown = Config.uniqueEffects.flamewind.cooldown;
            class_238 box = HelperMethods.createBox((class_1297)user, 10.0);
            class_1297 closestEntity = world.method_8333((class_1297)user, box, class_1301.field_6157).stream().min(Comparator.comparingDouble(entity -> entity.method_5858((class_1297)user))).orElse(null);
            if (closestEntity != null && closestEntity instanceof class_1309 && HelperMethods.checkFriendlyFire(ee = (class_1309)closestEntity, (class_1309)user) && !ee.method_6059(EffectRegistry.getReference(EffectRegistry.FLAMESEED))) {
                class_3414 soundSelect = (class_3414)SoundRegistry.SPELL_FIRE.get();
                int particleCount = 20;
                HelperMethods.spawnWaistHeightParticles(serverWorld, (class_2394)class_2398.field_11239, (class_1297)user, (class_1297)ee, particleCount);
                world.method_8396(null, user.method_24515(), soundSelect, user.method_5634(), 0.3f, 1.3f);
                SimplySwordsStatusEffectInstance flamSeedEffect = new SimplySwordsStatusEffectInstance(EffectRegistry.getReference(EffectRegistry.FLAMESEED), flameSeedDuration, 0, false, false, true);
                flamSeedEffect.setSourceEntity((class_1309)user);
                flamSeedEffect.setAdditionalData(flameSeedSpreadCap);
                ee.method_6092((class_1293)flamSeedEffect);
                user.method_7357().method_7906((class_1792)this, skillCooldown);
            }
        }
        return super.method_7836(world, user, hand);
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        HelperMethods.createFootfalls(entity, stack, world, (class_2394)class_2398.field_11240, (class_2394)class_2398.field_11240, (class_2394)class_2398.field_22247, true);
        super.method_7888(stack, world, entity, slot, selected);
    }

    @Override
    public void method_7851(class_1799 itemStack, class_1792.class_9635 tooltipContext, List<class_2561> tooltip, class_1836 type) {
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.flamewindsworditem.tooltip1").method_10862(Styles.ABILITY));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.flamewindsworditem.tooltip2").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.flamewindsworditem.tooltip3").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.onrightclick").method_10862(Styles.RIGHT_CLICK));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.flamewindsworditem.tooltip4").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.flamewindsworditem.tooltip5").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.flamewindsworditem.tooltip6").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.flamewindsworditem.tooltip7").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.flamewindsworditem.tooltip8").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.flamewindsworditem.tooltip9").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.flamewindsworditem.tooltip10").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43469((String)"item.simplyswords.flamewindsworditem.tooltip11", (Object[])new Object[]{Config.uniqueEffects.flamewind.spreadCap}).method_10862(Styles.TEXT));
        super.method_7851(itemStack, tooltipContext, tooltip, type);
        TooltipUtils.appendSpellScaleTooltip(tooltip, "fire");
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0)
        public int cooldown;
        @ValidatedFloat.Restrict(min=0.0f)
        public float damage;
        @ValidatedFloat.Restrict(min=0.0f)
        public float spellScaling;
        @ValidatedFloat.Restrict(min=0.0f)
        public float detonationDamage;
        @ValidatedInt.Restrict(min=0)
        public int maxHaste;
        @ValidatedInt.Restrict(min=1)
        public int spreadCap;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ItemsRegistry.FLAMEWIND.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.cooldown = 980;
            this.damage = 5.0f;
            this.spellScaling = 0.4f;
            this.detonationDamage = 15.0f;
            this.maxHaste = 10;
            this.spreadCap = 6;
        }
    }
}

