/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.math2d;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.anti_ad.mc.common.math2d.Line;
import org.anti_ad.mc.common.math2d.LineKt;
import org.anti_ad.mc.common.math2d.Point;
import org.anti_ad.mc.common.math2d.Rectangle;
import org.anti_ad.mc.common.math2d.Size;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\u001a\u0011\u0010\u0002\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0011\u0010\u0004\u001a\u00020\u0000*\u00020\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u0011\u0010\u0006\u001a\u00020\u0000*\u00020\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0011\u0010\u0004\u001a\u00020\u0001*\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\b\u001a\u0019\u0010\u000b\u001a\u00020\t*\u00020\t2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\f\u001a\u0011\u0010\r\u001a\u00020\t*\u00020\t\u00a2\u0006\u0004\b\r\u0010\u000e\u001a\u0013\u0010\u000f\u001a\u00020\t*\u00020\tH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u000e\u001a\u0013\u0010\u0010\u001a\u00020\t*\u00020\tH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000e\u001a\u0011\u0010\u0011\u001a\u00020\t*\u00020\t\u00a2\u0006\u0004\b\u0011\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lorg/anti_ad/mc/common/math2d/Point;", "Lorg/anti_ad/mc/common/math2d/Size;", "toSize", "(Lorg/anti_ad/mc/common/math2d/Point;)Lorg/anti_ad/mc/common/math2d/Size;", "transpose", "(Lorg/anti_ad/mc/common/math2d/Point;)Lorg/anti_ad/mc/common/math2d/Point;", "toPoint", "(Lorg/anti_ad/mc/common/math2d/Size;)Lorg/anti_ad/mc/common/math2d/Point;", "(Lorg/anti_ad/mc/common/math2d/Size;)Lorg/anti_ad/mc/common/math2d/Size;", "Lorg/anti_ad/mc/common/math2d/Rectangle;", "other", "intersect", "(Lorg/anti_ad/mc/common/math2d/Rectangle;Lorg/anti_ad/mc/common/math2d/Rectangle;)Lorg/anti_ad/mc/common/math2d/Rectangle;", "positiveOrEmpty", "(Lorg/anti_ad/mc/common/math2d/Rectangle;)Lorg/anti_ad/mc/common/math2d/Rectangle;", "normalizeWidth", "normalizeHeight", "normalize", "fabric-1.21.1"})
public final class Rect2dKt {
    @NotNull
    public static final Size toSize(@NotNull Point $this$toSize) {
        Intrinsics.checkNotNullParameter((Object)$this$toSize, (String)"<this>");
        return new Size($this$toSize.getX(), $this$toSize.getY());
    }

    @NotNull
    public static final Point transpose(@NotNull Point $this$transpose) {
        Intrinsics.checkNotNullParameter((Object)$this$transpose, (String)"<this>");
        return new Point($this$transpose.getY(), $this$transpose.getX());
    }

    @NotNull
    public static final Point toPoint(@NotNull Size $this$toPoint) {
        Intrinsics.checkNotNullParameter((Object)$this$toPoint, (String)"<this>");
        return new Point($this$toPoint.getWidth(), $this$toPoint.getHeight());
    }

    @NotNull
    public static final Size transpose(@NotNull Size $this$transpose) {
        Intrinsics.checkNotNullParameter((Object)$this$transpose, (String)"<this>");
        return new Size($this$transpose.getHeight(), $this$transpose.getWidth());
    }

    @NotNull
    public static final Rectangle intersect(@NotNull Rectangle $this$intersect, @NotNull Rectangle other) {
        Intrinsics.checkNotNullParameter((Object)$this$intersect, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Line line = LineKt.getDiagonal(Rect2dKt.normalize($this$intersect));
        int x1 = line.component1();
        int y1 = line.component2();
        int x2 = line.component3();
        int y2 = line.component4();
        Line line2 = LineKt.getDiagonal(Rect2dKt.normalize(other));
        int x3 = line2.component1();
        int y3 = line2.component2();
        int x4 = line2.component3();
        int y4 = line2.component4();
        int x5 = Math.max(x1, x3);
        int y5 = Math.max(y1, y3);
        int x6 = Math.min(x2, x4);
        int y6 = Math.min(y2, y4);
        return Rect2dKt.positiveOrEmpty(LineKt.toRectangle(new Line(x5, y5, x6, y6)));
    }

    @NotNull
    public static final Rectangle positiveOrEmpty(@NotNull Rectangle $this$positiveOrEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$positiveOrEmpty, (String)"<this>");
        return $this$positiveOrEmpty.getWidth() > 0 && $this$positiveOrEmpty.getHeight() > 0 ? $this$positiveOrEmpty : new Rectangle(0, 0, 0, 0);
    }

    private static final Rectangle normalizeWidth(Rectangle $this$normalizeWidth) {
        return $this$normalizeWidth.getWidth() >= 0 ? $this$normalizeWidth : new Rectangle($this$normalizeWidth.getX() + $this$normalizeWidth.getWidth(), $this$normalizeWidth.getY(), -$this$normalizeWidth.getWidth(), $this$normalizeWidth.getHeight());
    }

    private static final Rectangle normalizeHeight(Rectangle $this$normalizeHeight) {
        return $this$normalizeHeight.getHeight() >= 0 ? $this$normalizeHeight : new Rectangle($this$normalizeHeight.getX(), $this$normalizeHeight.getY() + $this$normalizeHeight.getHeight(), $this$normalizeHeight.getWidth(), -$this$normalizeHeight.getHeight());
    }

    @NotNull
    public static final Rectangle normalize(@NotNull Rectangle $this$normalize) {
        Intrinsics.checkNotNullParameter((Object)$this$normalize, (String)"<this>");
        return Rect2dKt.normalizeHeight(Rect2dKt.normalizeWidth($this$normalize));
    }
}

