/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.helper;

import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.material.ShadeMode;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.ModelHelper;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1087;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import org.jetbrains.annotations.Nullable;

public class VanillaModelEncoder {
    private static final Renderer RENDERER = RendererAccess.INSTANCE.getRenderer();
    private static final RenderMaterial STANDARD_MATERIAL = RENDERER.materialFinder().shadeMode(ShadeMode.VANILLA).find();
    private static final RenderMaterial NO_AO_MATERIAL = RENDERER.materialFinder().shadeMode(ShadeMode.VANILLA).ambientOcclusion(TriState.FALSE).find();

    public static void emitBlockQuads(class_1087 model, @Nullable class_2680 state, Supplier<class_5819> randomSupplier, RenderContext context) {
        QuadEmitter emitter = context.getEmitter();
        RenderMaterial defaultMaterial = model.method_4708() ? STANDARD_MATERIAL : NO_AO_MATERIAL;
        for (int i = 0; i <= 6; ++i) {
            class_2350 cullFace = ModelHelper.faceFromIndex((int)i);
            if (!context.hasTransform() && context.isFaceCulled(cullFace)) continue;
            List quads = model.method_4707(state, cullFace, randomSupplier.get());
            int count = quads.size();
            for (int j = 0; j < count; ++j) {
                class_777 q = (class_777)quads.get(j);
                emitter.fromVanilla(q, defaultMaterial, cullFace);
                emitter.emit();
            }
        }
    }

    public static void emitItemQuads(class_1087 model, @Nullable class_2680 state, Supplier<class_5819> randomSupplier, RenderContext context) {
        QuadEmitter emitter = context.getEmitter();
        for (int i = 0; i <= 6; ++i) {
            class_2350 cullFace = ModelHelper.faceFromIndex((int)i);
            List quads = model.method_4707(state, cullFace, randomSupplier.get());
            int count = quads.size();
            for (int j = 0; j < count; ++j) {
                class_777 q = (class_777)quads.get(j);
                emitter.fromVanilla(q, STANDARD_MATERIAL, cullFace);
                emitter.emit();
            }
        }
    }
}

