/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.ingredient;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2189;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientBlock;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientBlockTag;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientFuel;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItem;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemStack;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemTag;
import team.creative.creativecore.common.util.registry.NamedTypeRegistry;

public abstract class CreativeIngredient {
    public static final NamedTypeRegistry<CreativeIngredient> REGISTRY = new NamedTypeRegistry().addConstructorPattern(new Class[0]);
    private static final List<Function<Object, ? extends CreativeIngredient>> OBJECT_PARSERS = new ArrayList<Function<Object, ? extends CreativeIngredient>>();
    private static final CreativeIngredient EMPTY = new CreativeIngredient(){

        @Override
        protected void saveExtra(class_7225.class_7874 provider, class_2487 nbt) {
        }

        @Override
        protected void loadExtra(class_7225.class_7874 provider, class_2487 nbt) {
        }

        @Override
        public boolean is(CreativeIngredient info) {
            return false;
        }

        @Override
        public boolean is(class_1799 stack) {
            return false;
        }

        @Override
        public class_1799 getExample() {
            return class_1799.field_8037;
        }

        @Override
        public boolean equals(CreativeIngredient object) {
            return false;
        }

        @Override
        public class_2561 descriptionDetail() {
            return class_2561.method_43470((String)"empty");
        }

        @Override
        public class_2561 description() {
            return class_2561.method_43470((String)"invalid");
        }

        @Override
        public CreativeIngredient copy() {
            return EMPTY;
        }
    };

    public static <T extends CreativeIngredient> void registerType(String id, Class<T> classType, Function<Object, T> parser) {
        REGISTRY.register(id, classType);
        if (parser != null) {
            OBJECT_PARSERS.add(parser);
        }
    }

    public static CreativeIngredient parse(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof CreativeIngredient) {
            return (CreativeIngredient)object;
        }
        for (int i = 0; i < OBJECT_PARSERS.size(); ++i) {
            try {
                CreativeIngredient ingredient = OBJECT_PARSERS.get(i).apply(object);
                if (ingredient == null) continue;
                return ingredient;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static CreativeIngredient load(class_7225.class_7874 provider, class_2487 nbt) {
        Class<CreativeIngredient> classType = REGISTRY.get(nbt.method_10558("id"));
        if (classType == null) {
            CreativeCore.LOGGER.error((Object)new IllegalArgumentException("'" + nbt.method_10558("id") + "' is an invalid type"));
            return EMPTY;
        }
        try {
            CreativeIngredient ingredient = classType.getConstructor(new Class[0]).newInstance(new Object[0]);
            ingredient.loadExtra(provider, nbt);
            return ingredient;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public class_2487 save(class_7225.class_7874 provider) {
        class_2487 nbt = new class_2487();
        nbt.method_10582("id", REGISTRY.getIdOrDefault(this, "empty"));
        this.saveExtra(provider, nbt);
        return nbt;
    }

    protected abstract void saveExtra(class_7225.class_7874 var1, class_2487 var2);

    protected abstract void loadExtra(class_7225.class_7874 var1, class_2487 var2);

    public abstract boolean is(class_1799 var1);

    public abstract boolean is(CreativeIngredient var1);

    public abstract class_1799 getExample();

    public abstract CreativeIngredient copy();

    public boolean equals(Object object) {
        CreativeIngredient c;
        return object instanceof CreativeIngredient && this.equals(c = (CreativeIngredient)object);
    }

    public abstract boolean equals(CreativeIngredient var1);

    public abstract class_2561 description();

    public abstract class_2561 descriptionDetail();

    static {
        CreativeIngredient.registerType("block", CreativeIngredientBlock.class, x -> {
            class_2248 block = null;
            if (x instanceof class_2248) {
                block = (class_2248)x;
            }
            if (x instanceof class_1747) {
                block = class_2248.method_9503((class_1792)((class_1792)x));
            }
            if (block != null && !(block instanceof class_2189)) {
                return new CreativeIngredientBlock(block);
            }
            return null;
        });
        CreativeIngredient.registerType("blocktag", CreativeIngredientBlockTag.class, x -> {
            class_6862 key;
            if (x instanceof class_6862 && (key = (class_6862)x).method_41007(class_7924.field_41254)) {
                return new CreativeIngredientBlockTag((class_6862<class_2248>)((class_6862)x));
            }
            return null;
        });
        CreativeIngredient.registerType("item", CreativeIngredientItem.class, x -> {
            if (x instanceof class_1792 && !(x instanceof class_1747)) {
                return new CreativeIngredientItem((class_1792)x);
            }
            return null;
        });
        CreativeIngredient.registerType("itemtag", CreativeIngredientItemTag.class, x -> {
            class_6862 key;
            if (x instanceof class_6862 && (key = (class_6862)x).method_41007(class_7924.field_41197)) {
                return new CreativeIngredientItemTag((class_6862<class_1792>)((class_6862)x));
            }
            return null;
        });
        CreativeIngredient.registerType("itemstack", CreativeIngredientItemStack.class, x -> {
            CreativeIngredientItemStack creativeIngredientItemStack;
            if (x instanceof class_1799) {
                class_1799 s = (class_1799)x;
                creativeIngredientItemStack = new CreativeIngredientItemStack(s);
            } else {
                creativeIngredientItemStack = null;
            }
            return creativeIngredientItemStack;
        });
        CreativeIngredient.registerType("fuel", CreativeIngredientFuel.class, null);
    }
}

