/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.control.simple;

import java.util.function.Consumer;
import net.minecraft.class_2561;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.control.parent.GuiColumn;
import team.creative.creativecore.common.gui.control.parent.GuiRow;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.control.simple.GuiButtonContext;
import team.creative.creativecore.common.gui.control.simple.GuiButtonHoldSlim;
import team.creative.creativecore.common.gui.control.simple.GuiColorPlate;
import team.creative.creativecore.common.gui.control.simple.GuiColoredSteppedSlider;
import team.creative.creativecore.common.gui.control.simple.GuiTextfield;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.extension.GuiExtensionCreator;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.mc.ColorUtils;
import team.creative.creativecore.common.util.type.Color;

public class GuiColorPicker
extends GuiParent {
    protected GuiColoredSteppedSlider r;
    protected GuiColoredSteppedSlider g;
    protected GuiColoredSteppedSlider b;
    protected GuiColoredSteppedSlider a;
    protected GuiHexButton hex;
    public Color color;

    public GuiColorPicker(String name, Color color, boolean hasAlpha, int alphaMin) {
        super(name);
        this.color = new Color(color);
        GuiRow row = new GuiRow();
        this.add((GuiControl)row);
        GuiColumn sliders = new GuiColumn(GuiFlow.STACK_Y);
        sliders.spacing = -1;
        row.addColumn(sliders);
        GuiParent red = new GuiParent(GuiFlow.STACK_X).setVAlign(VAlign.CENTER);
        sliders.add((GuiControl)red);
        red.add((GuiControl)new GuiButtonHoldSlim("r-", x -> this.r.stepDown()).setTitle((class_2561)class_2561.method_43470((String)"<")));
        this.r = (GuiColoredSteppedSlider)new GuiColoredSteppedSlider("r", this, ColorUtils.ColorPart.RED).setExpandableX();
        red.add((GuiControl)this.r);
        red.add((GuiControl)new GuiButtonHoldSlim("r+", x -> this.r.stepUp()).setTitle((class_2561)class_2561.method_43470((String)">")));
        GuiParent green = new GuiParent(GuiFlow.STACK_X).setVAlign(VAlign.CENTER);
        sliders.add((GuiControl)green);
        green.add((GuiControl)new GuiButtonHoldSlim("g-", x -> this.g.stepDown()).setTitle((class_2561)class_2561.method_43470((String)"<")));
        this.g = (GuiColoredSteppedSlider)new GuiColoredSteppedSlider("g", this, ColorUtils.ColorPart.GREEN).setExpandableX();
        green.add((GuiControl)this.g);
        green.add((GuiControl)new GuiButtonHoldSlim("g+", x -> this.g.stepUp()).setTitle((class_2561)class_2561.method_43470((String)">")));
        GuiParent blue = new GuiParent(GuiFlow.STACK_X).setVAlign(VAlign.CENTER);
        sliders.add((GuiControl)blue);
        blue.add((GuiControl)new GuiButtonHoldSlim("b-", x -> this.b.stepDown()).setTitle((class_2561)class_2561.method_43470((String)"<")));
        this.b = (GuiColoredSteppedSlider)new GuiColoredSteppedSlider("b", this, ColorUtils.ColorPart.BLUE).setExpandableX();
        blue.add((GuiControl)this.b);
        blue.add((GuiControl)new GuiButtonHoldSlim("b+", x -> this.b.stepUp()).setTitle((class_2561)class_2561.method_43470((String)">")));
        if (hasAlpha) {
            GuiParent alpha = new GuiParent(GuiFlow.STACK_X).setVAlign(VAlign.CENTER);
            sliders.add((GuiControl)alpha);
            alpha.add((GuiControl)new GuiButtonHoldSlim("a-", x -> this.a.stepDown()).setTitle((class_2561)class_2561.method_43470((String)"<")));
            this.a = (GuiColoredSteppedSlider)new GuiColoredSteppedSlider("a", this, ColorUtils.ColorPart.ALPHA).setExpandableX();
            alpha.add((GuiControl)this.a);
            alpha.add((GuiControl)new GuiButtonHoldSlim("a+", x -> this.a.stepUp()).setTitle((class_2561)class_2561.method_43470((String)">")));
        } else {
            this.color.setAlpha(255);
        }
        GuiColumn plate = new GuiColumn(30, (GuiFlow)GuiFlow.STACK_Y);
        plate.align = Align.CENTER;
        plate.valign = VAlign.CENTER;
        row.addColumn(plate);
        plate.add(new GuiColorPlate("plate", this.color).setDim(20, 20));
        this.hex = new GuiHexButton(name, hex -> {
            if (hex.intValue() != this.color.toInt()) {
                this.r.setValueSilent(ColorUtils.red(hex));
                this.g.setValueSilent(ColorUtils.green(hex));
                this.b.setValueSilent(ColorUtils.blue(hex));
                this.onColorChanged(false);
            }
        });
        plate.add((GuiControl)this.hex);
    }

    public void setColor(Color color) {
        this.r.setValueSilent(color.getRed());
        this.g.setValueSilent(color.getGreen());
        this.b.setValueSilent(color.getBlue());
        if (this.a != null) {
            this.a.setValueSilent(color.getAlpha());
        }
        this.onColorChanged(true);
    }

    public void onColorChanged(boolean notifyHex) {
        if (notifyHex) {
            this.hex.colorChanged();
        }
        this.raiseEvent(new GuiControlChangedEvent<GuiColorPicker>(this));
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.TRANSPARENT;
    }

    public class GuiHexButton
    extends GuiButton {
        protected GuiExtensionCreator<GuiHexButton, GuiParent> ex;
        protected Consumer<Integer> consumer;
        private boolean updateCall;

        public GuiHexButton(String name, Consumer<Integer> consumer) {
            super(name, null);
            this.ex = new GuiExtensionCreator(this);
            this.pressed = x -> this.ex.toggle(this::createBox, GuiExtensionCreator.ExtensionDirection.RIGHT);
            this.consumer = consumer;
            this.setTitle((class_2561)class_2561.method_43470((String)"#"));
        }

        public void colorChanged() {
            if (this.ex.hasExtension()) {
                this.updateCall = true;
                this.ex.get().get("hex", GuiTextfield.class).setText(GuiColorPicker.this.color.hex());
            }
        }

        protected GuiParent createBox(GuiExtensionCreator<GuiButtonContext, GuiParent> creator) {
            GuiParent parent = new GuiParent();
            GuiTextfield text = new GuiTextfield("hex").setText(GuiColorPicker.this.color.hex()).setHexOnly().setMaxStringLength(6);
            parent.add((GuiControl)text.setDim(42, 8));
            parent.registerEventChanged(x -> {
                if (this.updateCall) {
                    this.updateCall = false;
                } else {
                    this.consumer.accept(ColorUtils.fromHex(text.getText()));
                }
            });
            return parent;
        }
    }
}

