/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.chrr.camerapture.ByteCollector;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.compat.FirstPersonModelCompat;
import me.chrr.camerapture.config.SyncedConfig;
import me.chrr.camerapture.net.clientbound.DownloadPartialPicturePacket;
import me.chrr.camerapture.net.clientbound.PictureErrorPacket;
import me.chrr.camerapture.net.clientbound.RequestUploadPacket;
import me.chrr.camerapture.net.clientbound.SyncConfigPacket;
import me.chrr.camerapture.picture.ClientPictureStore;
import me.chrr.camerapture.picture.PictureTaker;
import me.chrr.camerapture.render.PictureItemRenderer;

public class CameraptureClient {
    public static final float MIN_ZOOM = 1.0f;
    public static final float MAX_ZOOM = 6.0f;
    public static final PictureItemRenderer PICTURE_ITEM_RENDERER = new PictureItemRenderer();
    public static boolean replayModInstalled = false;
    public static SyncedConfig syncedConfig;

    public static void init() {
        ClientPictureStore.getInstance().clear();
        syncedConfig = SyncedConfig.fromServerConfig(Camerapture.CONFIG_MANAGER.getConfig().server);
        if (Camerapture.PLATFORM.isModLoaded("firstperson")) {
            FirstPersonModelCompat.register();
        }
        if (Camerapture.PLATFORM.isModLoaded("replay-mod")) {
            Camerapture.LOGGER.info("Replay Mod is detected, Camerapture will cache pictures, regardless of config.");
            replayModInstalled = true;
        }
    }

    public static void registerPacketHandlers() {
        Camerapture.NETWORK.onReceiveFromServer(RequestUploadPacket.class, packet -> Camerapture.EXECUTOR.execute(() -> PictureTaker.getInstance().uploadStoredPicture(packet.uuid())));
        ConcurrentHashMap collectors = new ConcurrentHashMap();
        Camerapture.NETWORK.onReceiveFromServer(DownloadPartialPicturePacket.class, packet -> {
            ByteCollector collector;
            Object object = collectors;
            synchronized (object) {
                collector = collectors.computeIfAbsent(packet.uuid(), uuid -> new ByteCollector(bytes -> {
                    collectors.remove(uuid);
                    Camerapture.EXECUTOR.execute(() -> ClientPictureStore.getInstance().processReceivedBytes((UUID)uuid, (byte[])bytes));
                }));
            }
            object = collector;
            synchronized (object) {
                if (!collector.push(packet.bytes(), packet.bytesLeft())) {
                    Camerapture.LOGGER.error("received malformed byte section from server");
                    ClientPictureStore.getInstance().processReceivedError(packet.uuid());
                }
            }
        });
        Camerapture.NETWORK.onReceiveFromServer(PictureErrorPacket.class, packet -> {
            ClientPictureStore.getInstance().processReceivedError(packet.uuid());
            collectors.remove(packet.uuid());
        });
        Camerapture.NETWORK.onReceiveFromServer(SyncConfigPacket.class, packet -> {
            Camerapture.LOGGER.info("received synced config: {}", (Object)packet.syncedConfig());
            syncedConfig = packet.syncedConfig();
        });
    }
}

