/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.condition;

import java.lang.reflect.Field;
import team.creative.ambientsounds.condition.AmbientCondition;
import team.creative.ambientsounds.condition.AmbientVolume;
import team.creative.ambientsounds.sound.AmbientSoundProperties;

public class AmbientSelection
extends AmbientVolume {
    public final AmbientCondition condition;
    public AmbientSelection subSelection = null;

    public AmbientSelection(AmbientCondition condition) {
        super(1.0, condition.volume);
        this.condition = condition;
    }

    @Override
    protected void assign(AmbientVolume volume) {
        if (volume instanceof AmbientSelection) {
            AmbientSelection sel = (AmbientSelection)volume;
            this.subSelection = sel.subSelection;
        }
        super.assign(volume);
    }

    @Override
    public double conditionVolume() {
        return this.subSelection != null ? this.subSelection.conditionVolume() * super.conditionVolume() : super.conditionVolume();
    }

    @Override
    public double settingVolume() {
        return this.subSelection != null ? this.subSelection.settingVolume() * super.settingVolume() : super.settingVolume();
    }

    @Override
    public double volume() {
        return this.subSelection != null ? this.subSelection.volume() * super.volume() : super.volume();
    }

    public AmbientSelection last() {
        if (this.subSelection == null) {
            return this;
        }
        return this.subSelection.last();
    }

    public AmbientSoundProperties getProperties() {
        AmbientSoundProperties properties = new AmbientSoundProperties();
        this.assignProperties(properties);
        return properties;
    }

    protected void assignProperties(AmbientSoundProperties properties) {
        try {
            for (Field field : AmbientSoundProperties.class.getFields()) {
                Object value = field.get(this.condition);
                if (value == null) continue;
                field.set(properties, value);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        if (this.subSelection != null) {
            this.subSelection.assignProperties(properties);
        }
    }
}

