/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.melody.resources.audio;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;

public class MinecraftSoundSettingsObserver {
    private static final Map<Long, BiConsumer<class_3419, Float>> VOLUME_LISTENERS = new HashMap<Long, BiConsumer<class_3419, Float>>();
    private static final Map<Long, Runnable> SOUND_ENGINE_RELOAD_LISTENERS = new HashMap<Long, Runnable>();
    private static long idCountVolumeListeners = 0L;
    private static long idCountEngineReloadListeners = 0L;

    public static long registerVolumeListener(@NotNull BiConsumer<class_3419, Float> listener) {
        Objects.requireNonNull(listener);
        VOLUME_LISTENERS.put(++idCountVolumeListeners, listener);
        return idCountVolumeListeners;
    }

    public static void unregisterVolumeListener(long id) {
        VOLUME_LISTENERS.remove(id);
    }

    public static List<BiConsumer<class_3419, Float>> getVolumeListeners() {
        return new ArrayList<BiConsumer<class_3419, Float>>(VOLUME_LISTENERS.values());
    }

    public static long registerSoundEngineReloadListener(@NotNull Runnable listener) {
        Objects.requireNonNull(listener);
        SOUND_ENGINE_RELOAD_LISTENERS.put(++idCountEngineReloadListeners, listener);
        return idCountEngineReloadListeners;
    }

    public static void unregisterSoundEngineReloadListener(long id) {
        SOUND_ENGINE_RELOAD_LISTENERS.remove(id);
    }

    public static List<Runnable> getSoundEngineReloadListeners() {
        return new ArrayList<Runnable>(SOUND_ENGINE_RELOAD_LISTENERS.values());
    }
}

