/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.fabric;

import dev.architectury.platform.Platform;
import java.util.ArrayList;
import net.creeperhost.polylib.PolyLib;
import net.creeperhost.polylib.client.modulargui.sprite.PolyTextures;
import net.creeperhost.polylib.events.ChunkEvents;
import net.creeperhost.polylib.events.ClientRenderEvents;
import net.creeperhost.polylib.fabric.client.ResourceReloadListenerWrapper;
import net.creeperhost.polylib.fabric.compat.EnergyIntegration;
import net.creeperhost.polylib.fabric.inventory.fluid.PolyFabricFluidWrapper;
import net.creeperhost.polylib.fabric.inventory.power.NullEnergyManager;
import net.creeperhost.polylib.inventory.fluid.PolyFluidBlock;
import net.creeperhost.polylib.inventory.fluid.PolyFluidHandler;
import net.creeperhost.polylib.inventory.items.PolyInventoryBlock;
import net.creeperhost.polylib.inventory.power.EnergyManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.impl.transfer.item.InventoryStorageImpl;
import net.minecraft.class_1263;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3264;

public class PolyLibFabric
implements ModInitializer {
    public static EnergyManager ENERGY_MANAGER = new NullEnergyManager();

    public void onInitialize() {
        PolyLib.init();
        ServerChunkEvents.CHUNK_LOAD.register((world, chunk) -> ((ChunkEvents.ChunkLoadEvent)ChunkEvents.CHUNK_LOAD_EVENT.invoker()).onChunkLoad((class_1937)world, chunk));
        ServerChunkEvents.CHUNK_UNLOAD.register((world, chunk) -> ((ChunkEvents.ChunkUnloadEvent)ChunkEvents.CHUNK_UNLOAD_EVENT.invoker()).onChunkUnload((class_1937)world, chunk));
        if (Platform.getEnv() == EnvType.CLIENT) {
            WorldRenderEvents.END.register(context -> ((ClientRenderEvents.LAST)ClientRenderEvents.LAST.invoker()).onRenderLastEvent(context.matrixStack()));
            ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new ResourceReloadListenerWrapper(PolyTextures::getAtlasHolder, class_2960.method_60655((String)"polylib", (String)"gui_atlas_reload")));
        }
        FluidStorage.SIDED.registerFallback((world, pos, state, blockEntity, direction) -> {
            if (blockEntity instanceof PolyFluidBlock) {
                PolyFluidBlock fluidBlock = (PolyFluidBlock)blockEntity;
                PolyFluidHandler handler = fluidBlock.getFluidHandler((class_2350)direction);
                if (handler == null) {
                    return null;
                }
                if (handler.getTanks() == 1) {
                    return new PolyFabricFluidWrapper(handler, 0);
                }
                ArrayList<PolyFabricFluidWrapper> tanks = new ArrayList<PolyFabricFluidWrapper>();
                for (int i = 0; i < handler.getTanks(); ++i) {
                    tanks.add(new PolyFabricFluidWrapper(handler, i));
                }
                return new CombinedStorage(tanks);
            }
            return null;
        });
        ItemStorage.SIDED.registerFallback((world, pos, state, blockEntity, context) -> {
            if (blockEntity instanceof PolyInventoryBlock) {
                PolyInventoryBlock invBlock = (PolyInventoryBlock)blockEntity;
                return InventoryStorageImpl.of((class_1263)invBlock.getContainer((class_2350)context), (class_2350)context);
            }
            return null;
        });
        if (Platform.isModLoaded((String)"team_reborn_energy")) {
            PolyLib.LOGGER.info("Detected team_reborn_energy, registering energy stuff!");
            ENERGY_MANAGER = EnergyIntegration.getEnergyManager();
            EnergyIntegration.registerEnergy();
        }
    }
}

