/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.fluid;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import net.minecraft.class_1058;
import net.minecraft.class_1723;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_9801;
import org.jetbrains.annotations.NotNull;

public class ScreenFluidRenderer {
    public static final ScreenFluidRenderer INSTANCE = new ScreenFluidRenderer(1000, 16, 16, 16);
    private static final int TEX_WIDTH = 16;
    private static final int TEX_HEIGHT = 16;
    private final int capacityMb;
    private final int width;
    private final int height;
    private final int minHeight;

    public ScreenFluidRenderer(int capacityMb, int width, int height, int minHeight) {
        this.capacityMb = capacityMb;
        this.width = width;
        this.height = height;
        this.minHeight = minHeight;
    }

    public void render(int xPosition, int yPosition, @NotNull FluidStack fluidStack) {
        this.drawFluid(xPosition, yPosition, fluidStack);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawFluid(int xPosition, int yPosition, @NotNull FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            return;
        }
        class_3611 fluid = fluidStack.getFluid();
        class_1058 fluidStillSprite = ScreenFluidRenderer.getStillFluidSprite(fluidStack);
        int fluidColor = FluidStackHooks.getColor((class_3611)fluid);
        int amount = (int)fluidStack.getAmount();
        int scaledAmount = amount * this.height / this.capacityMb;
        if (amount > 0 && scaledAmount < this.minHeight) {
            scaledAmount = this.minHeight;
        }
        if (scaledAmount > this.height) {
            scaledAmount = this.height;
        }
        this.drawTiledSprite(xPosition, yPosition, this.width, this.height, fluidColor, scaledAmount, fluidStillSprite);
    }

    private void drawTiledSprite(int xPosition, int yPosition, int tiledWidth, int tiledHeight, int color, int scaledAmount, class_1058 sprite) {
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        ScreenFluidRenderer.setGLColorFromInt(color);
        int xTileCount = tiledWidth / 16;
        int xRemainder = tiledWidth - xTileCount * 16;
        int yTileCount = scaledAmount / 16;
        int yRemainder = scaledAmount - yTileCount * 16;
        int yStart = yPosition + tiledHeight;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int width = xTile == xTileCount ? xRemainder : 16;
                int height = yTile == yTileCount ? yRemainder : 16;
                int x = xPosition + xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                if (width <= 0 || height <= 0) continue;
                int maskTop = 16 - height;
                int maskRight = 16 - width;
                ScreenFluidRenderer.drawTextureWithMasking(x, y, sprite, maskTop, maskRight, 100.0f);
            }
        }
    }

    private static class_1058 getStillFluidSprite(FluidStack fluidStack) {
        return FluidStackHooks.getStillTexture((class_3611)fluidStack.getFluid());
    }

    public static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    private static void drawTextureWithMasking(float xCoord, float yCoord, class_1058 textureSprite, int maskTop, int maskRight, float zLevel) {
        double uMin = textureSprite.method_4594();
        double uMax = textureSprite.method_4577();
        double vMin = textureSprite.method_4593();
        double vMax = textureSprite.method_4575();
        uMax -= (double)maskRight / 16.0 * (uMax - uMin);
        vMax -= (double)maskTop / 16.0 * (vMax - vMin);
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22912(xCoord, yCoord + 16.0f, zLevel).method_22913((float)uMin, (float)vMax);
        bufferBuilder.method_22912(xCoord + 16.0f - (float)maskRight, yCoord + 16.0f, zLevel).method_22913((float)uMax, (float)vMax);
        bufferBuilder.method_22912(xCoord + 16.0f - (float)maskRight, yCoord + (float)maskTop, zLevel).method_22913((float)uMax, (float)vMin);
        bufferBuilder.method_22912(xCoord, yCoord + (float)maskTop, zLevel).method_22913((float)uMin, (float)vMin);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
    }
}

