/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.fabric.config;

import com.anthonyhilyard.iceberg.Iceberg;
import com.anthonyhilyard.iceberg.config.IIcebergConfigSpec;
import com.anthonyhilyard.iceberg.events.common.ConfigEvents;
import com.anthonyhilyard.iceberg.fabric.config.MutableSubconfig;
import com.anthonyhilyard.iceberg.fabric.config.Range;
import com.anthonyhilyard.iceberg.fabric.config.ValueSpec;
import com.anthonyhilyard.iceberg.services.IIcebergConfigSpecBuilder;
import com.anthonyhilyard.iceberg.util.UnsafeUtil;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.EnumGetMethod;
import com.electronwill.nightconfig.core.InMemoryFormat;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.file.FileWatcher;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.utils.StringUtils;
import com.electronwill.nightconfig.core.utils.UnmodifiableConfigWrapper;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.util.BiConsumer;
import org.jetbrains.annotations.Nullable;

public class FabricIcebergConfigSpec
extends UnmodifiableConfigWrapper<UnmodifiableConfig>
implements IIcebergConfigSpec {
    private Map<List<String>, String> levelComments;
    private Map<List<String>, String> levelTranslationKeys;
    private UnmodifiableConfig values;
    private Config childConfig;
    private boolean isCorrecting = false;
    private static final long correctionTimeoutMs = 500L;

    private FabricIcebergConfigSpec(UnmodifiableConfig storage, UnmodifiableConfig values, Map<List<String>, String> levelComments, Map<List<String>, String> levelTranslationKeys) {
        super(Config.copy(storage));
        this.values = Config.copy(values);
        this.levelComments = Map.copyOf(levelComments);
        this.levelTranslationKeys = Map.copyOf(levelTranslationKeys);
        try {
            Field exceptionHandlerField = FileWatcher.class.getDeclaredField("exceptionHandler");
            UnsafeUtil.setField(exceptionHandlerField, FileWatcher.defaultInstance(), e -> Iceberg.LOGGER.warn("An error occurred while reloading config:", (Throwable)e));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void save() {
        Config config = this.childConfig;
        if (config instanceof FileConfig) {
            FileConfig fileConfig = (FileConfig)config;
            fileConfig.save();
        }
    }

    public void setConfig(CommentedConfig config) {
        this.childConfig = config;
        if (config != null && !this.isCorrect(config)) {
            String string;
            FileConfig fileConfig;
            if (config instanceof FileConfig) {
                fileConfig = (FileConfig)((Object)config);
                string = fileConfig.getNioPath().toString();
            } else {
                string = config.toString();
            }
            String configName = string;
            Iceberg.LOGGER.warn("Configuration file {} is not correct. Correcting", (Object)configName);
            this.correct(config, (action, path, incorrectValue, correctedValue) -> Iceberg.LOGGER.warn("Incorrect key {} was corrected from {} to its default, {}. {}", (Object)String.join((CharSequence)".", path), incorrectValue, correctedValue, (Object)(incorrectValue == correctedValue ? "This seems to be an error." : "")), (action, path, incorrectValue, correctedValue) -> Iceberg.LOGGER.debug("The comment on key {} does not match the spec. This may create a backup.", (Object)String.join((CharSequence)".", path)));
            if (config instanceof FileConfig) {
                fileConfig = (FileConfig)((Object)config);
                fileConfig.save();
            }
        }
        this.clearCache(this.values.valueMap().values());
    }

    public boolean applyCorrectionAction(CommentedFileConfig config, BiConsumer<FabricIcebergConfigSpec, CommentedFileConfig> consumer, String modId) {
        long startTime = System.currentTimeMillis();
        while (this.isCorrecting) {
            if (System.currentTimeMillis() - startTime > 500L) {
                return false;
            }
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return true;
            }
        }
        try {
            config.load();
            if (!this.isCorrect(config)) {
                consumer.accept((Object)this, (Object)config);
                config.save();
            }
        }
        catch (ParsingException ex) {
            return false;
        }
        this.clearCache(this.values.valueMap().values());
        ConfigEvents.RELOAD.invoker().onReload(modId);
        return true;
    }

    public synchronized boolean isCorrect(CommentedConfig config) {
        LinkedList<String> parentPath = new LinkedList<String>();
        if (config.valueMap().isEmpty() && config instanceof FileConfig) {
            FileConfig fileConfig = (FileConfig)((Object)config);
            File configFile = fileConfig.getFile();
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (configFile.length() > 0L) {
                return true;
            }
        }
        return this.correct(this.config, config, parentPath, Collections.unmodifiableList(parentPath), (a, b, c, d) -> {}, null, true) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int correct(CommentedConfig config, ConfigSpec.CorrectionListener listener, ConfigSpec.CorrectionListener commentListener) {
        LinkedList<String> parentPath = new LinkedList<String>();
        int ret = -1;
        try {
            this.isCorrecting = true;
            ret = this.correct(this.config, config, parentPath, Collections.unmodifiableList(parentPath), listener, commentListener, false);
        }
        finally {
            this.isCorrecting = false;
        }
        return ret;
    }

    private synchronized int correct(UnmodifiableConfig spec, CommentedConfig config, LinkedList<String> parentPath, List<String> parentPathUnmodifiable, ConfigSpec.CorrectionListener listener, ConfigSpec.CorrectionListener commentListener, boolean dryRun) {
        int count = 0;
        Map<String, Object> specMap = spec.valueMap();
        Map<String, Object> configMap = config.valueMap();
        for (Map.Entry<String, Object> specEntry : specMap.entrySet()) {
            ValueSpec valueSpec;
            String key = specEntry.getKey();
            Object specValue = specEntry.getValue();
            Object configValue = configMap.get(key);
            ConfigSpec.CorrectionAction action = configValue == null ? ConfigSpec.CorrectionAction.ADD : ConfigSpec.CorrectionAction.REPLACE;
            parentPath.addLast(key);
            String subConfigComment = null;
            if (specValue instanceof ValueSpec && (valueSpec = (ValueSpec)specValue).getDefault() instanceof UnmodifiableConfig) {
                subConfigComment = valueSpec.getComment();
                specValue = valueSpec.getDefault();
            }
            if (specValue instanceof UnmodifiableConfig) {
                UnmodifiableConfig specConfig = (UnmodifiableConfig)specValue;
                if (configValue instanceof Config) {
                    CommentedConfig commentedConfig;
                    if ((count += this.correct(specConfig, configValue instanceof CommentedConfig ? (commentedConfig = (CommentedConfig)configValue) : CommentedConfig.copy((Config)configValue), parentPath, parentPathUnmodifiable, listener, commentListener, dryRun)) > 0 && dryRun) {
                        return count;
                    }
                } else {
                    if (dryRun) {
                        return 1;
                    }
                    newValue = config.createSubConfig();
                    configMap.put(key, newValue);
                    listener.onCorrect(action, parentPathUnmodifiable, configValue, newValue);
                    ++count;
                    if (specConfig instanceof MutableSubconfig) {
                        specConfig.valueMap().forEach((arg_0, arg_1) -> FabricIcebergConfigSpec.lambda$correct$4((CommentedConfig)newValue, arg_0, arg_1));
                    } else {
                        count += this.correct((UnmodifiableConfig)specValue, (CommentedConfig)newValue, parentPath, parentPathUnmodifiable, listener, commentListener, dryRun);
                    }
                }
                String newComment = subConfigComment == null ? this.levelComments.get(parentPath) : subConfigComment;
                String oldComment = config.getComment(key);
                if (!this.stringsMatchIgnoringNewlines(oldComment, newComment)) {
                    if (commentListener != null) {
                        commentListener.onCorrect(action, parentPathUnmodifiable, oldComment, newComment);
                    }
                    if (dryRun) {
                        return 1;
                    }
                    config.setComment(key, newComment);
                }
            } else if (specValue instanceof ValueSpec) {
                String oldComment;
                ValueSpec valueSpec2 = (ValueSpec)specValue;
                if (!valueSpec2.test(configValue)) {
                    if (dryRun) {
                        return 1;
                    }
                    newValue = valueSpec2.correct(configValue);
                    configMap.put(key, newValue);
                    listener.onCorrect(action, parentPathUnmodifiable, configValue, newValue);
                    ++count;
                }
                if (!this.stringsMatchIgnoringNewlines(oldComment = config.getComment(key), valueSpec2.getComment())) {
                    if (commentListener != null) {
                        commentListener.onCorrect(action, parentPathUnmodifiable, oldComment, valueSpec2.getComment());
                    }
                    if (dryRun) {
                        return 1;
                    }
                    config.setComment(key, valueSpec2.getComment());
                }
            } else if (spec instanceof MutableSubconfig) {
                MutableSubconfig subconfig = (MutableSubconfig)spec;
                if (configMap.containsKey(key)) {
                    if (!subconfig.keyValidator().test(key)) {
                        if (dryRun) {
                            return 1;
                        }
                        listener.onCorrect(ConfigSpec.CorrectionAction.REMOVE, parentPathUnmodifiable, key, null);
                        configMap.remove(key);
                        ++count;
                    }
                    if (!subconfig.valueValidator().test(configMap.get(key))) {
                        if (dryRun) {
                            return 1;
                        }
                        listener.onCorrect(ConfigSpec.CorrectionAction.REMOVE, parentPathUnmodifiable, configMap.get(key), null);
                        configMap.remove(key);
                        ++count;
                    }
                }
            }
            parentPath.removeLast();
        }
        Iterator<Map.Entry<String, Object>> iterator = configMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            if (spec instanceof MutableSubconfig || specMap.containsKey(entry.getKey())) continue;
            if (dryRun) {
                return 1;
            }
            iterator.remove();
            parentPath.addLast(entry.getKey());
            listener.onCorrect(ConfigSpec.CorrectionAction.REMOVE, parentPathUnmodifiable, entry.getValue(), null);
            parentPath.removeLast();
            ++count;
        }
        return count;
    }

    private boolean stringsMatchIgnoringNewlines(@Nullable Object obj1, @Nullable Object obj2) {
        if (obj1 instanceof String) {
            String string1 = (String)obj1;
            if (obj2 instanceof String) {
                String string2 = (String)obj2;
                if (string1.length() > 0 && string2.length() > 0) {
                    return string1.replaceAll("\r\n", "\n").equals(string2.replaceAll("\r\n", "\n"));
                }
            }
        }
        return Objects.equals(obj1, obj2);
    }

    private void clearCache(Iterable<Object> configValues) {
        configValues.forEach(value -> {
            if (value instanceof ConfigValue) {
                ConfigValue configValue = (ConfigValue)value;
                configValue.clearCache();
            } else if (value instanceof Config) {
                Config innerConfig = (Config)value;
                this.clearCache(innerConfig.valueMap().values());
            }
        });
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    private static /* synthetic */ void lambda$correct$4(CommentedConfig newValue, String k, Object v) {
        Object object;
        Map<String, Object> map = newValue.valueMap();
        if (v instanceof ValueSpec) {
            ValueSpec vSpec = (ValueSpec)v;
            object = vSpec.getDefault();
        } else {
            object = v;
        }
        map.put(k, object);
    }

    public static class ConfigValue<T>
    implements Supplier<T> {
        private final Builder parent;
        private final List<String> path;
        private final Supplier<T> defaultSupplier;
        private final Class<T> clazz;
        private T cachedValue = null;
        private FabricIcebergConfigSpec spec;

        ConfigValue(Builder parent, List<String> path, Supplier<T> defaultSupplier, Class<T> clazz) {
            this.parent = parent;
            this.path = path;
            this.defaultSupplier = defaultSupplier;
            this.clazz = clazz;
            this.parent.values.add(Pair.of(path, (Object)this));
        }

        public List<String> getPath() {
            return Lists.newArrayList(this.path);
        }

        @Override
        public T get() {
            Objects.requireNonNull(this.spec, "Cannot get config value before spec is built");
            if (this.spec.childConfig == null) {
                throw new IllegalStateException("Cannot get config value before config is loaded.");
            }
            if (this.cachedValue == null) {
                this.cachedValue = this.getRaw(this.spec.childConfig, this.path, this.defaultSupplier);
            }
            return this.cachedValue;
        }

        protected T getRaw(Config config, List<String> path, Supplier<T> defaultSupplier) {
            if (this.clazz.isEnum()) {
                return this.getRawEnum(config, path, this.clazz, defaultSupplier);
            }
            T value = config.getOrElse(path, defaultSupplier);
            if (value instanceof Number) {
                Number number = (Number)value;
                if (this.clazz == Integer.class) {
                    return (T)Integer.valueOf(number.intValue());
                }
                if (this.clazz == Long.class) {
                    return (T)Long.valueOf(number.longValue());
                }
                if (this.clazz == Float.class) {
                    return (T)Float.valueOf(number.floatValue());
                }
                if (this.clazz == Double.class) {
                    return (T)Double.valueOf(number.doubleValue());
                }
            }
            return value;
        }

        private <U extends Enum<U>> U getRawEnum(Config config, List<String> path, Class<U> clazz, Supplier<U> defaultSupplier) {
            return config.getEnumOrElse(path, clazz, EnumGetMethod.NAME_IGNORECASE, defaultSupplier);
        }

        public T getDefault() {
            return this.defaultSupplier.get();
        }

        public Builder next() {
            return this.parent;
        }

        public void save() {
            Objects.requireNonNull(this.spec, "Cannot save config value before spec is built");
            Objects.requireNonNull(this.spec.childConfig, "Cannot save config value without assigned Config object present");
            this.spec.save();
        }

        public void set(T value) {
            Objects.requireNonNull(this.spec, "Cannot set config value before spec is built");
            Objects.requireNonNull(this.spec.childConfig, "Cannot set config value without assigned Config object present");
            this.spec.childConfig.set(this.path, value);
            this.cachedValue = value;
        }

        public void clearCache() {
            this.cachedValue = null;
        }
    }

    static class BuilderContext {
        private final List<String> comment = Lists.newLinkedList();
        private String langKey;
        private Range<?> range;
        private boolean worldRestart = false;
        private Class<?> clazz;

        BuilderContext() {
        }

        public void addComment(String value) {
            this.comment.add(value);
        }

        public void clearComment() {
            this.comment.clear();
        }

        public boolean hasComment() {
            return !this.comment.isEmpty();
        }

        public String buildComment() {
            return this.buildComment(List.of("unknown", "unknown"));
        }

        public String buildComment(List<String> path) {
            if (this.comment.stream().allMatch(String::isBlank)) {
                throw new IllegalStateException("Can not build comment for config option " + String.join((CharSequence)".", path) + " as it comprises entirely of blank lines/whitespace. This is not allowed as it causes a \"constantly correcting config\" bug with NightConfig.");
            }
            return String.join((CharSequence)"\n", this.comment);
        }

        public void setTranslationKey(String value) {
            this.langKey = value;
        }

        public String getTranslationKey() {
            return this.langKey;
        }

        public <V extends Comparable<? super V>> void setRange(Range<V> value, Class<V> clazz) {
            this.range = value;
            this.setClazz(clazz);
        }

        public <V extends Comparable<? super V>> Range<V> getRange() {
            return this.range;
        }

        public void setClazz(Class<?> clazz) {
            this.clazz = clazz;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public void ensureEmpty() {
            this.validate(this.hasComment(), "Non-empty comment when empty expected");
            this.validate(this.langKey, "Non-null translation key when null expected");
            this.validate(this.range, "Non-null range when null expected");
            this.validate(this.worldRestart, "Dangling world restart value set to true");
        }

        private void validate(Object value, String message) {
            if (value != null) {
                throw new IllegalStateException(message);
            }
        }

        private void validate(boolean value, String message) {
            if (value) {
                throw new IllegalStateException(message);
            }
        }
    }

    public static class Builder
    implements IIcebergConfigSpecBuilder {
        private final Config storage = Config.of(LinkedHashMap::new, InMemoryFormat.withUniversalSupport());
        private BuilderContext context = new BuilderContext();
        private final Map<List<String>, String> levelComments = Maps.newHashMap();
        private final Map<List<String>, String> levelTranslationKeys = Maps.newHashMap();
        private final List<String> currentPath = Lists.newArrayList();
        private final List<Pair<List<String>, Supplier<?>>> values = Lists.newArrayList();

        @Override
        public void reset() {
            this.storage.clear();
            this.context = new BuilderContext();
            this.levelComments.clear();
            this.levelTranslationKeys.clear();
            this.currentPath.clear();
            this.values.clear();
        }

        @Override
        public Builder comment(String comment) {
            this.context.addComment(comment);
            return this;
        }

        @Override
        public Builder comment(String ... comments) {
            for (String comment : comments) {
                this.comment(comment);
            }
            return this;
        }

        @Override
        public Builder translation(String translationKey) {
            this.context.setTranslationKey(translationKey);
            return this;
        }

        @Override
        public Builder push(String path) {
            return this.push((List)StringUtils.split(path, '.'));
        }

        @Override
        public Builder push(List<String> path) {
            this.currentPath.addAll(path);
            if (this.context.hasComment()) {
                this.levelComments.put(Lists.newArrayList(this.currentPath), this.context.buildComment(path));
                this.context.clearComment();
            }
            if (this.context.getTranslationKey() != null) {
                this.levelTranslationKeys.put(Lists.newArrayList(this.currentPath), this.context.getTranslationKey());
                this.context.setTranslationKey(null);
            }
            this.context.ensureEmpty();
            return this;
        }

        @Override
        public Builder pop() {
            if (this.currentPath.isEmpty()) {
                throw new IllegalArgumentException("Attempted to pop an empty config path!");
            }
            this.currentPath.remove(this.currentPath.size() - 1);
            return this;
        }

        @Override
        public <T> Pair<T, IIcebergConfigSpec> finish(Function<IIcebergConfigSpecBuilder, T> consumer) {
            T o = consumer.apply(this);
            this.context.ensureEmpty();
            Config valueCfg = Config.of(Config.getDefaultMapCreator(true, true), InMemoryFormat.withUniversalSupport());
            this.values.forEach(v -> valueCfg.set((List)v.getKey(), v.getValue()));
            FabricIcebergConfigSpec ret = new FabricIcebergConfigSpec(this.storage, valueCfg, this.levelComments, this.levelTranslationKeys);
            this.values.forEach(v -> {
                ((ConfigValue)v.getValue()).spec = ret;
            });
            this.reset();
            return Pair.of(o, (Object)ret);
        }

        private <T> Supplier<T> add(List<String> path, ValueSpec<T> value, Supplier<T> defaultSupplier, Class<T> clazz) {
            assert (defaultSupplier.get().getClass() == clazz);
            if (!this.currentPath.isEmpty()) {
                path.addAll(0, this.currentPath);
            }
            this.storage.set(path, value);
            this.context = new BuilderContext();
            return new ConfigValue<T>(this, path, defaultSupplier, clazz);
        }

        private <T> Supplier<T> add(List<String> path, Supplier<T> defaultSupplier, Predicate<Object> validator, Class<T> clazz) {
            return this.add(path, new ValueSpec<T>(defaultSupplier, validator, this.context, path), defaultSupplier, clazz);
        }

        @Override
        public <T> Supplier<T> add(String path, T defaultValue) {
            return this.add(path, defaultValue, o -> o != null && defaultValue.getClass().isAssignableFrom(o.getClass()));
        }

        @Override
        public <T> Supplier<T> add(String path, T defaultValue, Predicate<Object> validator) {
            Class<Object> clazz;
            List<String> list = StringUtils.split(path, '.');
            Supplier<Object> supplier = () -> defaultValue;
            if (validator instanceof Range) {
                Range range = (Range)validator;
                clazz = range.getClazz();
            } else {
                clazz = defaultValue.getClass();
            }
            return this.add(list, supplier, validator, clazz);
        }

        @Override
        public <V extends Comparable<? super V>> Supplier<V> addInRange(String path, V defaultValue, V min, V max, Class<V> clazz) {
            Range<V> range = new Range<V>(clazz, min, max);
            this.context.setRange(range, clazz);
            this.comment("Range: " + String.valueOf(range));
            if (min.compareTo(max) > 0) {
                throw new IllegalArgumentException("Range min most be less then max.");
            }
            return this.add(path, defaultValue, range);
        }

        @Override
        public <T> Supplier<T> addInList(String path, T defaultValue, Collection<? extends T> acceptableValues) {
            return this.add(path, defaultValue, o -> o != null && acceptableValues.contains(o));
        }

        @Override
        public <T> Supplier<List<? extends T>> addList(String path, List<? extends T> defaultValue, final Predicate<Object> elementValidator) {
            Supplier<List> defaultSupplier = () -> defaultValue;
            final List<String> splitPath = StringUtils.split(path, '.');
            this.context.setClazz(List.class);
            return this.add(splitPath, new ValueSpec<List<? extends T>>(this, defaultSupplier, x -> x instanceof List && ((List)x).stream().allMatch(elementValidator), this.context, splitPath){

                @Override
                public List<? extends T> correct(List<? extends T> value) {
                    List list;
                    if (!(value instanceof List) || (list = value).isEmpty()) {
                        Iceberg.LOGGER.debug("List on key {} is deemed to need correction. It is null, not a list, or an empty list.", splitPath.get(splitPath.size() - 1));
                        return (List)this.getDefault();
                    }
                    ArrayList copy = Lists.newArrayList(list);
                    copy.removeIf(elementValidator.negate());
                    if (copy.isEmpty()) {
                        Iceberg.LOGGER.debug("List on key {} is deemed to need correction. It failed validation.", splitPath.get(splitPath.size() - 1));
                        return (List)this.getDefault();
                    }
                    return copy;
                }
            }, defaultSupplier, List.class);
        }

        @Override
        public <T> Supplier<List<? extends T>> addListAllowEmpty(String path, List<? extends T> defaultValue, final Predicate<Object> elementValidator) {
            Supplier<List> defaultSupplier = () -> defaultValue;
            final List<String> splitPath = StringUtils.split(path, '.');
            this.context.setClazz(List.class);
            return this.add(splitPath, new ValueSpec<List<? extends T>>(this, defaultSupplier, x -> x instanceof List && ((List)x).stream().allMatch(elementValidator), this.context, splitPath){

                @Override
                public List<? extends T> correct(List<? extends T> value) {
                    if (!(value instanceof List)) {
                        Iceberg.LOGGER.debug("List on key {} is deemed to need correction, as it is null or not a list.", splitPath.get(splitPath.size() - 1));
                        return (List)this.getDefault();
                    }
                    List list = value;
                    ArrayList copy = Lists.newArrayList(list);
                    copy.removeIf(elementValidator.negate());
                    if (copy.isEmpty()) {
                        Iceberg.LOGGER.debug("List on key {} is deemed to need correction. It failed validation.", splitPath.get(splitPath.size() - 1));
                        return (List)this.getDefault();
                    }
                    return copy;
                }
            }, defaultSupplier, List.class);
        }

        @Override
        public <V extends Enum<V>> Supplier<V> addEnum(String path, V defaultValue) {
            Class clazz = defaultValue.getDeclaringClass();
            this.context.setClazz(clazz);
            return this.addEnum(path, defaultValue, o -> {
                if (o == null) {
                    return false;
                }
                if (o instanceof Enum) {
                    return true;
                }
                if (o instanceof String) {
                    String str = (String)o;
                    return EnumUtils.isValidEnumIgnoreCase((Class)clazz, (String)str);
                }
                return false;
            });
        }

        @Override
        public <V extends Enum<V>> Supplier<V> addEnum(String path, V defaultValue, Predicate<Object> validator) {
            Supplier<Enum> defaultSupplier = () -> defaultValue;
            List<String> splitPath = StringUtils.split(path, '.');
            Class<V> clazz = defaultValue.getDeclaringClass();
            this.context.setClazz(clazz);
            Enum[] allowedValues = (Enum[])clazz.getEnumConstants();
            this.comment("Allowed values: " + Arrays.stream(allowedValues).filter(validator).map(Enum::name).collect(Collectors.joining(", ")));
            return new ConfigValue<Enum>(this, ((ConfigValue)this.add(splitPath, new ValueSpec<Enum>(defaultSupplier, validator, this.context, splitPath), defaultSupplier, clazz)).getPath(), defaultSupplier, clazz);
        }

        @Override
        public Supplier<Boolean> add(String path, boolean defaultValue) {
            return this.add(path, (Object)defaultValue);
        }

        @Override
        public Supplier<Double> addInRange(String path, double defaultValue, double min, double max) {
            return this.addInRange(path, defaultValue, min, max, (Class)Double.class);
        }

        @Override
        public Supplier<Integer> addInRange(String path, int defaultValue, int min, int max) {
            return this.addInRange(path, defaultValue, min, max, (Class)Integer.class);
        }

        @Override
        public Supplier<Long> addInRange(String path, long defaultValue, long min, long max) {
            return this.addInRange(path, defaultValue, min, max, (Class)Long.class);
        }

        @Override
        public Supplier<Map<String, Object>> addSubconfig(String path, Map<String, Object> defaultValue, Predicate<Object> keyValidator, Predicate<Object> valueValidator) {
            List<String> splitPath = StringUtils.split(path, '.');
            return this.addSubconfig(splitPath, defaultValue, keyValidator, valueValidator);
        }

        public Supplier<Map<String, Object>> addSubconfig(List<String> path, Map<String, Object> defaultValue, Predicate<Object> keyValidator, Predicate<Object> valueValidator) {
            return this.addSubconfig(path, () -> defaultValue, keyValidator, valueValidator);
        }

        public Supplier<Map<String, Object>> addSubconfig(String path, Supplier<Map<String, Object>> defaultSupplier, Predicate<Object> keyValidator, Predicate<Object> valueValidator) {
            List<String> splitPath = StringUtils.split(path, '.');
            return this.addSubconfig(splitPath, defaultSupplier, keyValidator, valueValidator);
        }

        public Supplier<Map<String, Object>> addSubconfig(List<String> path, Supplier<Map<String, Object>> defaultSupplier, Predicate<Object> keyValidator, Predicate<Object> valueValidator) {
            Config defaultConfig = Config.of(defaultSupplier, TomlFormat.instance());
            Supplier<Config> value = this.add(path, () -> MutableSubconfig.copy(defaultConfig, keyValidator, valueValidator), (Object o) -> o != null, Config.class);
            return () -> ((Config)value.get()).valueMap();
        }
    }
}

