/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.screen.queueable;

import de.keksuccino.fancymenu.util.rendering.ui.screen.queueable.QueueableScreen;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QueueableScreenHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Queue<QueueableScreen> SCREEN_QUEUE = new ConcurrentLinkedQueue<QueueableScreen>();
    private static final AtomicBoolean IS_PROCESSING = new AtomicBoolean(false);
    private static volatile QueueableScreen currentScreen = null;
    private static volatile class_437 cachedOriginalScreen = null;
    private static volatile boolean hasScreenCached = false;

    public static void addToQueue(@NotNull QueueableScreen screen) {
        if (screen == null) {
            throw new IllegalArgumentException("Screen cannot be null!");
        }
        screen.setCloseCallback(QueueableScreenHandler::onScreenClosed);
        SCREEN_QUEUE.offer(screen);
        QueueableScreenHandler.processQueue();
    }

    private static void onScreenClosed(@NotNull QueueableScreen closedScreen) {
        if (currentScreen == closedScreen) {
            currentScreen = null;
            IS_PROCESSING.set(false);
        }
        QueueableScreenHandler.processQueue();
    }

    private static void processQueue() {
        if (IS_PROCESSING.compareAndSet(false, true)) {
            QueueableScreen nextScreen = SCREEN_QUEUE.poll();
            if (nextScreen != null) {
                if (!hasScreenCached && currentScreen == null) {
                    cachedOriginalScreen = class_310.method_1551().field_1755;
                    hasScreenCached = true;
                }
                currentScreen = nextScreen;
                if (class_310.method_1551().method_18854()) {
                    QueueableScreenHandler.openScreen(nextScreen);
                } else {
                    MainThreadTaskExecutor.executeInMainThread(() -> QueueableScreenHandler.openScreen(nextScreen), MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
                }
            } else {
                IS_PROCESSING.set(false);
                if (hasScreenCached) {
                    class_437 screenToRestore = cachedOriginalScreen;
                    cachedOriginalScreen = null;
                    hasScreenCached = false;
                    if (class_310.method_1551().method_18854()) {
                        class_310.method_1551().method_1507(screenToRestore);
                    } else {
                        MainThreadTaskExecutor.executeInMainThread(() -> class_310.method_1551().method_1507(screenToRestore), MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
                    }
                }
            }
        }
    }

    private static void openScreen(@NotNull QueueableScreen screen) {
        try {
            class_310.method_1551().method_1507((class_437)screen);
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to open QueueableScreen!", (Throwable)ex);
            currentScreen = null;
            IS_PROCESSING.set(false);
            QueueableScreenHandler.processQueue();
        }
    }

    public static void clearQueue() {
        SCREEN_QUEUE.clear();
    }

    public static void clearQueue(boolean clearCached) {
        SCREEN_QUEUE.clear();
        if (clearCached && !QueueableScreenHandler.isScreenActive()) {
            cachedOriginalScreen = null;
            hasScreenCached = false;
        }
    }

    public static int getQueueSize() {
        return SCREEN_QUEUE.size();
    }

    public static boolean isScreenActive() {
        return currentScreen != null && IS_PROCESSING.get();
    }

    @Nullable
    public static QueueableScreen getCurrentScreen() {
        return currentScreen;
    }

    @Nullable
    public static class_437 getCachedOriginalScreen() {
        return cachedOriginalScreen;
    }

    public static boolean hasScreenCached() {
        return hasScreenCached;
    }
}

