/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.other;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.SerializationUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1074;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UptimeDurationPlaceholder
extends Placeholder {
    private volatile long registeredAtMs;

    public UptimeDurationPlaceholder() {
        super("uptime_duration");
    }

    @Override
    public void onRegistered() {
        this.registeredAtMs = System.currentTimeMillis();
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        long timestamp = this.registeredAtMs;
        if (timestamp <= 0L) {
            return "0";
        }
        long uptimeMs = System.currentTimeMillis() - timestamp;
        if (uptimeMs < 0L) {
            uptimeMs = 0L;
        }
        if (SerializationUtils.deserializeBoolean(false, dps.values.get("output_as_millis"))) {
            return Long.toString(uptimeMs);
        }
        return Long.toString(uptimeMs / 1000L);
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        return List.of("output_as_millis");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return class_1074.method_4662((String)"fancymenu.placeholders.uptime_seconds", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.uptime_seconds.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662((String)"fancymenu.requirements.categories.other", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("output_as_millis", "false");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }
}

