/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.customization.listener.listeners.helpers.MusicTrackInfoHelper;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.List;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnMusicTrackStoppedListener
extends AbstractListener {
    @Nullable
    private String cachedTrackResourceLocation;
    @Nullable
    private String cachedTrackDisplayName;
    @Nullable
    private String cachedTrackArtist;
    private long cachedTrackDurationMs;

    public OnMusicTrackStoppedListener() {
        super("music_track_stopped");
    }

    public void onMusicTrackStopped(@Nullable String trackResourceLocation, @Nullable String trackEventLocation) {
        this.cachedTrackResourceLocation = trackResourceLocation != null && !trackResourceLocation.isBlank() ? trackResourceLocation : trackEventLocation;
        this.updateTrackInfoCache(trackResourceLocation, trackEventLocation);
        if (trackResourceLocation != null && !trackResourceLocation.isBlank() || trackEventLocation != null && !trackEventLocation.isBlank()) {
            this.notifyAllInstances();
        }
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<AbstractListener.CustomVariable> list) {
        list.add(new AbstractListener.CustomVariable("track_resource_location", () -> this.cachedTrackResourceLocation != null ? this.cachedTrackResourceLocation : "ERROR"));
        list.add(new AbstractListener.CustomVariable("track_display_name", () -> this.cachedTrackDisplayName != null ? this.cachedTrackDisplayName : "UNKNOWN"));
        list.add(new AbstractListener.CustomVariable("track_artist", () -> this.cachedTrackArtist != null ? this.cachedTrackArtist : "UNKNOWN"));
        list.add(new AbstractListener.CustomVariable("track_duration_ms", () -> Long.toString(Math.max(this.cachedTrackDurationMs, 0L))));
    }

    private void updateTrackInfoCache(@Nullable String trackResourceLocation, @Nullable String eventResourceLocation) {
        MusicTrackInfoHelper.MusicTrackInfo info = MusicTrackInfoHelper.findTrackInfo(trackResourceLocation, eventResourceLocation);
        if (info != null) {
            this.cachedTrackDisplayName = info.getDisplayName();
            this.cachedTrackArtist = info.getArtist();
            this.cachedTrackDurationMs = info.getDurationMillis();
        } else {
            this.cachedTrackDisplayName = null;
            this.cachedTrackArtist = null;
            this.cachedTrackDurationMs = 0L;
        }
    }

    @Override
    @NotNull
    public class_2561 getDisplayName() {
        return class_2561.method_43471((String)"fancymenu.listeners.on_music_track_stopped");
    }

    @Override
    @NotNull
    public List<class_2561> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_music_track_stopped.desc", new String[0]));
    }
}

