/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.playerentity.v1;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.elements.playerentity.v1.model.PlayerEntityElementRenderer;
import de.keksuccino.fancymenu.customization.element.elements.playerentity.v1.model.PlayerEntityProperties;
import de.keksuccino.fancymenu.customization.element.elements.playerentity.v1.textures.CapeResourceSupplier;
import de.keksuccino.fancymenu.customization.element.elements.playerentity.v1.textures.SkinResourceSupplier;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import net.minecraft.class_898;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fStack;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class PlayerEntityElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    public final PlayerEntityElementRenderer normalRenderer = PlayerEntityElement.buildEntityRenderer(false);
    public final PlayerEntityElementRenderer slimRenderer = PlayerEntityElement.buildEntityRenderer(true);
    public volatile boolean copyClientPlayer = false;
    @NotNull
    public volatile String playerName = "Steve";
    public boolean showPlayerName = true;
    public boolean hasParrotOnShoulder = false;
    public boolean parrotOnLeftShoulder = false;
    public boolean crouching = false;
    public boolean isBaby = false;
    public String scale = "30";
    public boolean headFollowsMouse = true;
    public boolean bodyFollowsMouse = true;
    public volatile boolean slim = true;
    public volatile boolean autoSkin = false;
    public volatile boolean autoCape = false;
    @Nullable
    public SkinResourceSupplier skinTextureSupplier;
    @Nullable
    public CapeResourceSupplier capeTextureSupplier;
    public String bodyXRot;
    public String bodyYRot;
    public String headXRot;
    public String headYRot;
    public String headZRot;
    public String leftArmXRot;
    public String leftArmYRot;
    public String leftArmZRot;
    public String rightArmXRot;
    public String rightArmYRot;
    public String rightArmZRot;
    public String leftLegXRot;
    public String leftLegYRot;
    public String leftLegZRot;
    public String rightLegXRot;
    public String rightLegYRot;
    public String rightLegZRot;
    public boolean bodyXRotAdvancedMode;
    public boolean bodyYRotAdvancedMode;
    public boolean headXRotAdvancedMode;
    public boolean headYRotAdvancedMode;
    public boolean headZRotAdvancedMode;
    public boolean leftArmXRotAdvancedMode;
    public boolean leftArmYRotAdvancedMode;
    public boolean leftArmZRotAdvancedMode;
    public boolean rightArmXRotAdvancedMode;
    public boolean rightArmYRotAdvancedMode;
    public boolean rightArmZRotAdvancedMode;
    public boolean leftLegXRotAdvancedMode;
    public boolean leftLegYRotAdvancedMode;
    public boolean leftLegZRotAdvancedMode;
    public boolean rightLegXRotAdvancedMode;
    public boolean rightLegYRotAdvancedMode;
    public boolean rightLegZRotAdvancedMode;

    public PlayerEntityElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
        this.supportsRotation = false;
        this.supportsTilting = false;
    }

    @Nullable
    protected static PlayerEntityElementRenderer buildEntityRenderer(boolean slim) {
        try {
            return new PlayerEntityElementRenderer(slim);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (this.shouldRender()) {
            this.updatePlayerDisplayName();
            this.updateSkinAndCape();
            float scale = this.stringToFloat(this.scale);
            if (scale == 0.0f) {
                scale = 30.0f;
            }
            this.baseWidth = (int)(this.getActiveEntityProperties().getDimensions().comp_2185() * scale);
            this.baseHeight = (int)(this.getActiveEntityProperties().getDimensions().comp_2186() * scale);
            RenderSystem.enableBlend();
            PlayerEntityProperties props = this.getActiveEntityProperties();
            int x = this.getAbsoluteX();
            int y = this.getAbsoluteY();
            int mouseOffsetX = this.baseWidth / 2;
            int mouseOffsetY = this.baseHeight / 4 / 2;
            if (props.isBaby) {
                mouseOffsetY += this.baseHeight / 2 - mouseOffsetY;
            }
            this.renderPlayerEntity(x, y, (int)scale, (float)x - (float)mouseX + (float)mouseOffsetX, (float)y - (float)mouseY + (float)mouseOffsetY, props);
            RenderingUtils.resetShaderColor(graphics);
        }
    }

    protected void renderPlayerEntity(int posX, int posY, int scale, float angleXComponent, float angleYComponent, PlayerEntityProperties props) {
        float f = (float)Math.atan(angleXComponent / 40.0f);
        float f1 = (float)Math.atan(angleYComponent / 40.0f);
        this.innerRenderPlayerEntity(posX, posY, scale, f, f1, props, this.getActiveRenderer());
    }

    protected void innerRenderPlayerEntity(int posX, int posY, int scale, float angleXComponent, float angleYComponent, PlayerEntityProperties props, PlayerEntityElementRenderer renderer) {
        float bodyXRot = this.stringToFloat(this.bodyXRot);
        float bodyYRot = this.stringToFloat(this.bodyYRot);
        float headXRot = this.stringToFloat(this.headXRot);
        float headYRot = this.stringToFloat(this.headYRot);
        float headZRot = this.stringToFloat(this.headZRot);
        float leftArmXRot = this.stringToFloat(this.leftArmXRot);
        float leftArmYRot = this.stringToFloat(this.leftArmYRot);
        float leftArmZRot = this.stringToFloat(this.leftArmZRot);
        float rightArmXRot = this.stringToFloat(this.rightArmXRot);
        float rightArmYRot = this.stringToFloat(this.rightArmYRot);
        float rightArmZRot = this.stringToFloat(this.rightArmZRot);
        float leftLegXRot = this.stringToFloat(this.leftLegXRot);
        float leftLegYRot = this.stringToFloat(this.leftLegYRot);
        float leftLegZRot = this.stringToFloat(this.leftLegZRot);
        float rightLegXRot = this.stringToFloat(this.rightLegXRot);
        float rightLegYRot = this.stringToFloat(this.rightLegYRot);
        float rightLegZRot = this.stringToFloat(this.rightLegZRot);
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.translate((float)posX + props.getDimensions().comp_2185() / 2.0f * (float)scale, (float)posY + props.getDimensions().comp_2186() * (float)scale, 1050.0f);
        modelViewStack.scale(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        class_4587 innerPoseStack = new class_4587();
        innerPoseStack.method_22903();
        innerPoseStack.method_46416(0.0f, 0.0f, 1000.0f);
        innerPoseStack.method_22905((float)scale, (float)scale, (float)scale);
        Quaternionf quat1 = this.bodyFollowsMouse ? new Quaternionf().rotateZ((float)Math.PI) : class_7833.field_40718.rotationDegrees(180.0f);
        Quaternionf quat2 = this.bodyFollowsMouse ? new Quaternionf().rotateX(angleYComponent * 20.0f * ((float)Math.PI / 180)) : class_7833.field_40714.rotationDegrees(bodyYRot);
        quat1.mul((Quaternionfc)quat2);
        innerPoseStack.method_22907(quat1);
        props.yBodyRot = 180.0f + angleXComponent * 20.0f;
        props.yRot = 180.0f + angleXComponent * 40.0f;
        props.xRot = -angleYComponent * 20.0f;
        props.yHeadRot = 180.0f + angleXComponent * 40.0f;
        props.yHeadRotO = 180.0f + angleXComponent * 40.0f;
        props.headZRot = 0.0f;
        if (!this.bodyFollowsMouse) {
            props.yBodyRot = 180.0f + bodyXRot;
        }
        if (!this.headFollowsMouse) {
            props.xRot = headYRot;
            props.yRot = 0.0f;
            props.yHeadRot = 180.0f + headXRot;
            props.yHeadRotO = 180.0f + headXRot;
            props.headZRot = headZRot;
        }
        props.leftArmXRot = leftArmXRot;
        props.leftArmYRot = leftArmYRot;
        props.leftArmZRot = leftArmZRot;
        props.rightArmXRot = rightArmXRot;
        props.rightArmYRot = rightArmYRot;
        props.rightArmZRot = rightArmZRot;
        props.leftLegXRot = leftLegXRot;
        props.leftLegYRot = leftLegYRot;
        props.leftLegZRot = leftLegZRot;
        props.rightLegXRot = rightLegXRot;
        props.rightLegYRot = rightLegYRot;
        props.rightLegZRot = rightLegZRot;
        class_308.method_34742();
        class_898 dispatcher = class_310.method_1551().method_1561();
        quat2.conjugate();
        dispatcher.method_24196(quat2);
        dispatcher.method_3948(false);
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        RenderSystem.runAsFancy(() -> renderer.renderPlayerEntityItem(0.0, 0.0, 0.0, 0.0f, 1.0f, innerPoseStack, (class_4597)bufferSource, 0xF000F0));
        bufferSource.method_22993();
        dispatcher.method_3948(true);
        modelViewStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
        innerPoseStack.method_22909();
    }

    protected float stringToFloat(@Nullable String s) {
        if (s == null) {
            return 0.0f;
        }
        s = PlaceholderParser.replacePlaceholders(s);
        s = s.replace(" ", "");
        try {
            return Float.parseFloat(s);
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    public void setCopyClientPlayer(boolean copyClientPlayer) {
        if (copyClientPlayer) {
            this.copyClientPlayer = true;
            this.autoCape = false;
            this.autoSkin = false;
            this.slim = false;
            this.setPlayerName(class_310.method_1551().method_1548().method_1676());
            this.setSkinByPlayerName();
            this.setCapeByPlayerName();
        } else {
            this.copyClientPlayer = false;
            this.skinTextureSupplier = null;
            this.capeTextureSupplier = null;
        }
    }

    public void setPlayerName(@Nullable String playerName) {
        if (playerName == null) {
            playerName = "Steve";
        }
        this.playerName = playerName;
        this.updatePlayerDisplayName();
    }

    public void setShowPlayerName(boolean showName) {
        if (this.normalRenderer == null || this.slimRenderer == null) {
            return;
        }
        this.showPlayerName = showName;
        this.normalRenderer.properties.showDisplayName = showName;
        this.slimRenderer.properties.showDisplayName = showName;
    }

    public void setHasParrotOnShoulder(boolean hasParrot, boolean onLeftShoulder) {
        if (this.normalRenderer == null || this.slimRenderer == null) {
            return;
        }
        this.hasParrotOnShoulder = hasParrot;
        this.parrotOnLeftShoulder = onLeftShoulder;
        this.normalRenderer.properties.hasParrotOnShoulder = hasParrot;
        this.slimRenderer.properties.hasParrotOnShoulder = hasParrot;
        this.normalRenderer.properties.parrotOnLeftShoulder = onLeftShoulder;
        this.slimRenderer.properties.parrotOnLeftShoulder = onLeftShoulder;
    }

    public void setCrouching(boolean crouching) {
        if (this.normalRenderer == null || this.slimRenderer == null) {
            return;
        }
        this.crouching = crouching;
        this.normalRenderer.properties.crouching = crouching;
        this.slimRenderer.properties.crouching = crouching;
    }

    public void setIsBaby(boolean isBaby) {
        if (this.normalRenderer == null || this.slimRenderer == null) {
            return;
        }
        this.isBaby = isBaby;
        this.normalRenderer.properties.isBaby = isBaby;
        this.slimRenderer.properties.isBaby = isBaby;
    }

    public void setCapeByPlayerName() {
        this.capeTextureSupplier = new CapeResourceSupplier(this.playerName, true);
    }

    public void setSkinByPlayerName() {
        this.skinTextureSupplier = new SkinResourceSupplier(this.playerName, true);
    }

    public void setSkinBySource(@NotNull String resourceSource) {
        this.skinTextureSupplier = new SkinResourceSupplier(resourceSource, false);
    }

    public void setCapeBySource(@NotNull String resourceSource) {
        this.capeTextureSupplier = new CapeResourceSupplier(resourceSource, false);
    }

    protected void updateSkinAndCape() {
        if (this.normalRenderer == null || this.slimRenderer == null) {
            return;
        }
        if (this.copyClientPlayer || this.autoSkin) {
            boolean bl = this.slim = this.skinTextureSupplier == null || this.skinTextureSupplier.isSlimPlayerNameSkin();
        }
        if (this.capeTextureSupplier != null && this.capeTextureSupplier.hasNoCape()) {
            this.capeTextureSupplier = null;
        }
        this.normalRenderer.properties.setSkinTextureLocation(this.skinTextureSupplier != null ? this.skinTextureSupplier.getSkinLocation() : SkinResourceSupplier.DEFAULT_SKIN_LOCATION);
        this.slimRenderer.properties.setSkinTextureLocation(this.skinTextureSupplier != null ? this.skinTextureSupplier.getSkinLocation() : SkinResourceSupplier.DEFAULT_SKIN_LOCATION);
        class_2960 capeLoc = null;
        if (this.capeTextureSupplier != null && !this.capeTextureSupplier.hasNoCape() && (capeLoc = this.capeTextureSupplier.getCapeLocation()) == CapeResourceSupplier.DEFAULT_CAPE_LOCATION) {
            capeLoc = null;
        }
        this.normalRenderer.properties.setCapeTextureLocation(capeLoc);
        this.slimRenderer.properties.setCapeTextureLocation(capeLoc);
    }

    protected void updatePlayerDisplayName() {
        if (this.normalRenderer == null || this.slimRenderer == null) {
            return;
        }
        this.normalRenderer.properties.displayName = PlayerEntityElement.buildComponent(this.playerName);
        this.slimRenderer.properties.displayName = PlayerEntityElement.buildComponent(this.playerName);
    }

    public PlayerEntityElementRenderer getActiveRenderer() {
        if (this.slim) {
            return this.slimRenderer;
        }
        return this.normalRenderer;
    }

    public PlayerEntityProperties getActiveEntityProperties() {
        return this.getActiveRenderer().properties;
    }
}

