/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.editor;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.editor.AbstractEditorElement;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;

public class EditorElementBorderDisplay
implements class_4068 {
    private static final int LINE_BACKGROUND_HORIZONTAL_PADDING_FANCYMENU = 2;
    private static final int LINE_BACKGROUND_VERTICAL_PADDING_FANCYMENU = 1;
    public final AbstractEditorElement editorElement;
    public class_327 font;
    public final DisplayPosition defaultPosition;
    public final List<DisplayPosition> alternativePositions;
    public DisplayPosition currentPosition;
    protected final Map<String, Supplier<class_2561>> lines;
    protected List<class_2561> renderLines;
    protected int width;
    protected int height;

    public EditorElementBorderDisplay(@NotNull AbstractEditorElement editorElement, @NotNull DisplayPosition defaultPosition, DisplayPosition ... alternativePositions) {
        this.font = class_310.method_1551().field_1772;
        this.alternativePositions = new ArrayList<DisplayPosition>();
        this.lines = new LinkedHashMap<String, Supplier<class_2561>>();
        this.renderLines = new ArrayList<class_2561>();
        this.width = 0;
        this.height = 0;
        this.defaultPosition = defaultPosition;
        this.currentPosition = defaultPosition;
        this.editorElement = editorElement;
        if (alternativePositions != null) {
            this.alternativePositions.addAll(Arrays.asList(alternativePositions));
        }
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        this.updateDisplay();
        this.renderDisplayLines(graphics);
    }

    protected void renderDisplayLines(class_332 graphics) {
        int x = this.editorElement.getX();
        int y = this.editorElement.getY() - this.getHeight() - 2;
        boolean leftAligned = true;
        if (this.currentPosition == DisplayPosition.TOP_RIGHT) {
            x = this.editorElement.getX() + this.editorElement.getWidth() - this.getWidth();
            leftAligned = false;
        }
        if (this.currentPosition == DisplayPosition.RIGHT_TOP) {
            x = this.editorElement.getX() + this.editorElement.getWidth() + 2;
            y = this.editorElement.getY();
        }
        if (this.currentPosition == DisplayPosition.RIGHT_BOTTOM) {
            x = this.editorElement.getX() + this.editorElement.getWidth() + 2;
            y = this.editorElement.getY() + this.editorElement.getHeight() - this.getHeight();
        }
        if (this.currentPosition == DisplayPosition.BOTTOM_RIGHT) {
            x = this.editorElement.getX() + this.editorElement.getWidth() - this.getWidth();
            y = this.editorElement.getY() + this.editorElement.getHeight() + 2;
            leftAligned = false;
        }
        if (this.currentPosition == DisplayPosition.BOTTOM_LEFT) {
            y = this.editorElement.getY() + this.editorElement.getHeight() + 2;
        }
        if (this.currentPosition == DisplayPosition.LEFT_BOTTOM) {
            x = this.editorElement.getX() - this.getWidth() - 2;
            y = this.editorElement.getY() + this.editorElement.getHeight() - this.getHeight();
            leftAligned = false;
        }
        if (this.currentPosition == DisplayPosition.LEFT_TOP) {
            x = this.editorElement.getX() - this.getWidth() - 2;
            y = this.editorElement.getY();
            leftAligned = false;
        }
        float scale = this.getScale();
        int lineY = y;
        int backgroundColor = UIBase.getUIColorTheme().layout_editor_element_border_display_line_background_color.getColorInt();
        int textColor = UIBase.getUIColorTheme().layout_editor_element_border_display_line_text_color.getColorInt();
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22905(scale, scale, scale);
        for (class_2561 c : this.renderLines) {
            int lineWidth = this.font.method_27525((class_5348)c);
            int lineX = leftAligned ? x : x + (this.getWidth() - (int)((float)lineWidth * scale));
            int scaledLineX = (int)((float)lineX / scale);
            int scaledLineY = (int)((float)lineY / scale);
            int backgroundLeft = scaledLineX - 2;
            int backgroundTop = scaledLineY - 1;
            int backgroundRight = scaledLineX + lineWidth + 2;
            Objects.requireNonNull(this.font);
            int backgroundBottom = scaledLineY + 9 + 1;
            graphics.method_25294(backgroundLeft, backgroundTop, backgroundRight, backgroundBottom, backgroundColor);
            graphics.method_51439(this.font, c, scaledLineX, scaledLineY, textColor, false);
            float f = lineY;
            Objects.requireNonNull(this.font);
            lineY = (int)(f + (float)(9 + 2) * scale);
        }
        graphics.method_51448().method_22909();
    }

    public void addLine(String identifier, Supplier<class_2561> lineSupplier) {
        this.lines.put(identifier, lineSupplier);
    }

    public void removeLine(String identifier) {
        this.lines.remove(identifier);
    }

    public void clearLines() {
        this.lines.clear();
    }

    public boolean hasLine(String identifier) {
        return this.lines.containsKey(identifier);
    }

    protected void updateDisplay() {
        this.width = 0;
        this.height = 0;
        this.renderLines.clear();
        for (Supplier<class_2561> s : this.lines.values()) {
            class_2561 c = s.get();
            if (c == null) continue;
            int w = this.font.method_27525((class_5348)c);
            if (w > this.width) {
                this.width = w;
            }
            Objects.requireNonNull(this.font);
            this.height += 9 + 2;
            this.renderLines.add(c);
        }
        this.height = this.height > 0 ? this.height - 2 : 0;
        this.currentPosition = this.findPosition();
    }

    protected float getScale() {
        return UIBase.getFixedUIScale();
    }

    public int getWidth() {
        return (int)((float)this.width * this.getScale());
    }

    public int getHeight() {
        return (int)((float)this.height * this.getScale());
    }

    @NotNull
    protected DisplayPosition findPosition() {
        ArrayList<DisplayPosition> allowedPositions = new ArrayList<DisplayPosition>(this.alternativePositions);
        allowedPositions.add(0, this.defaultPosition);
        List<DisplayPosition> possiblePositions = this.getPossiblePositions();
        for (DisplayPosition p : allowedPositions) {
            if (!possiblePositions.contains((Object)p)) continue;
            return p;
        }
        return this.defaultPosition;
    }

    protected List<DisplayPosition> getPossiblePositions() {
        ArrayList<DisplayPosition> positions = new ArrayList<DisplayPosition>();
        int screenW = AbstractElement.getScreenWidth();
        int screenH = AbstractElement.getScreenHeight();
        int eleX = this.editorElement.getX();
        int eleY = this.editorElement.getY();
        int eleW = this.editorElement.getWidth();
        int eleH = this.editorElement.getHeight();
        if (eleX >= this.getWidth()) {
            positions.add(DisplayPosition.LEFT_TOP);
            positions.add(DisplayPosition.LEFT_BOTTOM);
        }
        if (eleY >= this.getHeight()) {
            positions.add(DisplayPosition.TOP_LEFT);
            positions.add(DisplayPosition.TOP_RIGHT);
        }
        if (screenW - (eleX + eleW) >= this.getWidth()) {
            positions.add(DisplayPosition.RIGHT_TOP);
            positions.add(DisplayPosition.RIGHT_BOTTOM);
        }
        if (screenH - (eleY + eleH) >= this.getHeight()) {
            positions.add(DisplayPosition.BOTTOM_LEFT);
            positions.add(DisplayPosition.BOTTOM_RIGHT);
        }
        return positions;
    }

    public static enum DisplayPosition {
        TOP_LEFT,
        TOP_RIGHT,
        RIGHT_TOP,
        RIGHT_BOTTOM,
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        LEFT_TOP,
        LEFT_BOTTOM;

    }
}

