/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.actions.file;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.file.DotMinecraftUtils;
import de.keksuccino.fancymenu.util.file.GameDirectoryUtils;
import java.io.File;
import net.minecraft.class_2561;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFileAction
extends Action {
    private static final Logger LOGGER = LogManager.getLogger();

    public CreateFileAction() {
        super("create_file_in_game_dir");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(@Nullable String value) {
        try {
            if (value != null) {
                File f;
                if (!DotMinecraftUtils.isInsideMinecraftDirectory(value = DotMinecraftUtils.resolveMinecraftPath(value))) {
                    value = GameDirectoryUtils.getAbsoluteGameDirectoryPath(value);
                }
                if (!(f = new File(value)).exists()) {
                    File parentDir = f.getParentFile();
                    if (parentDir != null && !parentDir.exists()) {
                        parentDir.mkdirs();
                    }
                    f.createNewFile();
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to create file in game directory via CreateFileAction: " + value, (Throwable)ex);
        }
    }

    @Override
    @NotNull
    public class_2561 getActionDisplayName() {
        return class_2561.method_43471((String)"fancymenu.actions.create_file");
    }

    @Override
    @NotNull
    public class_2561[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.actions.create_file.desc", new String[0]);
    }

    @Override
    public class_2561 getValueDisplayName() {
        return class_2561.method_43471((String)"fancymenu.actions.create_file.value");
    }

    @Override
    public String getValueExample() {
        return "/config/some_mod_folder/new_file.txt";
    }
}

