/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component;

import artifacts.component.ability.SwimInAir;
import artifacts.equipment.EquipmentHelper;
import artifacts.network.NetworkHandler;
import artifacts.network.SwimPacket;
import artifacts.registry.ModDataComponents;
import artifacts.registry.ModSoundEvents;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_3414;

public class SwimData {
    protected boolean isSwimming;
    protected boolean hasTouchedWater;
    protected double swimProgress;

    public boolean isSwimming() {
        return this.isSwimming;
    }

    public boolean isWet() {
        return this.hasTouchedWater;
    }

    public double getSwimProgress() {
        return this.swimProgress;
    }

    public void update(class_1657 player) {
        boolean shouldToggle;
        if (player.method_5799() || player.method_5771() || player.field_6017 > 6.0f) {
            this.hasTouchedWater = true;
        } else if (player.method_24828() || player.method_31549().field_7479) {
            this.hasTouchedWater = false;
        }
        boolean bl = this.isSwimming ? player.method_24828() : (shouldToggle = player.method_5869() && player.method_5681());
        if (shouldToggle) {
            this.toggleSwimming(player);
            this.syncSwimming(player);
        }
        this.updateSwimProgress(player);
    }

    private void updateSwimProgress(class_1657 player) {
        if (this.shouldDeplete(player)) {
            int flightDuration = SwimInAir.getFlightDuration((class_1309)player);
            this.swimProgress += 1.0 / (double)flightDuration;
            if (this.swimProgress >= 1.0) {
                this.swimProgress = 1.0;
                this.toggleSwimming(player);
                this.syncSwimming(player);
            }
        } else if (this.swimProgress > 0.0) {
            int rechargeDuration = SwimInAir.getRechargeDuration((class_1309)player);
            this.swimProgress -= 1.0 / (double)rechargeDuration;
            this.swimProgress = Math.max(0.0, this.swimProgress);
        }
    }

    private boolean shouldDeplete(class_1657 player) {
        return this.isSwimming && !player.method_7337() && (!player.method_5869() || EquipmentHelper.hasAbilityActive(ModDataComponents.SINKING.get(), (class_1309)player, true));
    }

    public void toggleSwimming(class_1657 player) {
        if (this.isSwimming || SwimInAir.canSwim((class_1309)player)) {
            boolean bl = this.isSwimming = !this.isSwimming;
            if (!(this.isSwimming || player.method_37908().method_8608() || player.method_24828())) {
                if (!player.method_5701()) {
                    player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), (class_3414)ModSoundEvents.POP.comp_349(), player.method_5634(), 1.0f, 1.0f);
                }
                EquipmentHelper.iterateAbilities(ModDataComponents.SWIM_IN_AIR.get(), (class_1309)player, true, true, (ability, stack) -> player.method_7357().method_7906(stack.method_7909(), Math.max(5, (Integer)ability.cooldown().get() * 20)));
            }
        }
    }

    public void syncSwimming(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            NetworkHandler.sendToPlayer(serverPlayer, new SwimPacket(this.isSwimming));
        } else {
            NetworkHandler.sendToServer(new SwimPacket(this.isSwimming));
        }
    }
}

