/*
 * Decompiled with CFR 0.152.
 */
package artifacts;

import artifacts.Artifacts;
import artifacts.client.CloudInABottleInputHandler;
import artifacts.client.ToggleKeyHandlers;
import artifacts.client.item.ArtifactLayers;
import artifacts.client.mimic.model.MimicChestLayerModel;
import artifacts.client.mimic.model.MimicModel;
import artifacts.event.SwimInAirInputHooks;
import artifacts.integration.accessories.AccessoriesCompatClient;
import artifacts.integration.trinkets.TrinketsCompatClient;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModItems;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5601;
import net.minecraft.class_5607;
import net.minecraft.class_6395;
import org.apache.logging.log4j.util.TriConsumer;

public class ArtifactsClient {
    public static void setup() {
        if (PlatformServices.platformHelper.isModLoaded("trinkets")) {
            TrinketsCompatClient.setup();
        }
        if (PlatformServices.platformHelper.isModLoaded("accessories")) {
            AccessoriesCompatClient.setup();
        }
    }

    public static void onClientTick(class_310 instance) {
        SwimInAirInputHooks.onClientTick(instance);
        CloudInABottleInputHandler.onClientTick(instance);
        ToggleKeyHandlers.onClientTick();
    }

    public static void onClientStarted() {
        if (!ModItems.NIGHT_VISION_GOGGLES.method_40227()) {
            Artifacts.LOGGER.error("Detected broken mod state, skipping input registration");
            return;
        }
        ToggleKeyHandlers.init();
    }

    public static void registerItemPropertyFunctions(TriConsumer<class_1792, class_2960, class_6395> registration) {
        registration.accept((Object)((class_1792)ModItems.UMBRELLA.comp_349()), (Object)Artifacts.id("blocking"), (stack, level, entity, i) -> entity != null && entity.method_6115() && entity.method_6030() == stack ? 1.0f : 0.0f);
    }

    public static void registerLayerDefinitions(BiConsumer<class_5601, Supplier<class_5607>> registration) {
        ArtifactLayers.register(registration);
        registration.accept(MimicModel.LAYER_LOCATION, MimicModel::createLayer);
        registration.accept(MimicChestLayerModel.LAYER_LOCATION, MimicChestLayerModel::createLayer);
    }
}

