/*
 * Decompiled with CFR 0.152.
 */
package artifacts;

import artifacts.config.ConfigManager;
import artifacts.config.ModConfig;
import artifacts.equipment.EquipmentSlotManager;
import artifacts.integration.accessories.AccessoriesCompat;
import artifacts.integration.minecraft.ArmorSlotProvider;
import artifacts.integration.trinkets.TrinketsCompat;
import artifacts.network.NetworkHandler;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModAttributes;
import artifacts.registry.ModDataComponents;
import artifacts.registry.ModEntityTypes;
import artifacts.registry.ModFeatures;
import artifacts.registry.ModGameEvents;
import artifacts.registry.ModItems;
import artifacts.registry.ModLootConditions;
import artifacts.registry.ModLootFunctions;
import artifacts.registry.ModMobEffects;
import artifacts.registry.ModPlacementModifierTypes;
import artifacts.registry.ModSoundEvents;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class Artifacts {
    public static final String MOD_ID = "artifacts";
    public static final Logger LOGGER = LogManager.getLogger();
    public static ModConfig CONFIG;
    @Nullable
    private static MinecraftServer currentServer;

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static class_2960 id(String path, String ... args) {
        return class_2960.method_60655((String)MOD_ID, (String)String.format(path, args));
    }

    public static <T> class_5321<T> key(class_5321<? extends class_2378<T>> registry, String path) {
        return class_5321.method_29179(registry, (class_2960)Artifacts.id(path));
    }

    @Nullable
    public static MinecraftServer getCurrentServer() {
        return currentServer;
    }

    public static void setup() {
        Artifacts.initConfigs();
        Artifacts.setupIntegrations();
        if (PlatformServices.platformHelper.isModLoaded("trinkets")) {
            TrinketsCompat.setup();
        }
        if (PlatformServices.platformHelper.isModLoaded("accessories")) {
            AccessoriesCompat.setup();
        }
        NetworkHandler.initPayloads();
        ModMobEffects.MOB_EFFECTS.register();
        ModDataComponents.DATA_COMPONENT_TYPES.register();
        ModSoundEvents.SOUND_EVENTS.register();
        ModLootConditions.LOOT_CONDITION_TYPES.register();
        ModLootFunctions.LOOT_FUNCTION_TYPES.register();
        ModPlacementModifierTypes.PLACEMENT_MODIFIER_TYPES.register();
        ModAttributes.ATTRIBUTES.register();
        ModEntityTypes.ENTITY_TYPES.register();
        ModItems.ITEMS.register();
        ModItems.CREATIVE_MODE_TABS.register();
        ModFeatures.FEATURES.register();
        ModGameEvents.GAME_EVENTS.register();
    }

    public static void initConfigs() {
        CONFIG = new ModConfig();
        CONFIG.setup();
        for (ConfigManager config : Artifacts.CONFIG.configs) {
            config.readValuesFromConfig();
        }
    }

    public static void setupIntegrations() {
        EquipmentSlotManager.register(new ArmorSlotProvider());
    }

    public static void onServerStarting(MinecraftServer server) {
        currentServer = server;
        for (ConfigManager config : Artifacts.CONFIG.configs) {
            config.readValuesFromConfig();
        }
    }

    public static void onServerStopping() {
        currentServer = null;
    }

    public static void onPlayerJoin(class_3222 player) {
        Artifacts.CONFIG.items.sendToClient(player);
    }
}

